/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import zz.org.eclipse.jgit.internal.storage.file.ByteWindow;
import zz.org.eclipse.jgit.internal.storage.file.PackFile;
import zz.org.eclipse.jgit.internal.storage.pack.PackOutputStream;

final class ByteBufferWindow
extends ByteWindow {
    private final ByteBuffer buffer;

    ByteBufferWindow(PackFile pack, long o, ByteBuffer b) {
        super(pack, o, b.capacity());
        this.buffer = b;
    }

    @Override
    protected int copy(int p, byte[] b, int o, int n) {
        ByteBuffer s = this.buffer.slice();
        s.position(p);
        n = Math.min(s.remaining(), n);
        s.get(b, o, n);
        return n;
    }

    @Override
    void write(PackOutputStream out, long pos, int cnt) throws IOException {
        ByteBuffer s = this.buffer.slice();
        s.position((int)(pos - this.start));
        while (cnt > 0) {
            byte[] buf = out.getCopyBuffer();
            int n = Math.min(cnt, buf.length);
            s.get(buf, 0, n);
            out.write(buf, 0, n);
            cnt -= n;
        }
    }

    @Override
    protected int setInput(int pos, Inflater inf) throws DataFormatException {
        ByteBuffer s = this.buffer.slice();
        s.position(pos);
        byte[] tmp = new byte[Math.min(s.remaining(), 512)];
        s.get(tmp, 0, tmp.length);
        inf.setInput(tmp, 0, tmp.length);
        return tmp.length;
    }
}

