/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import zz.org.eclipse.jgit.lib.AnyObjectId;
import zz.org.eclipse.jgit.lib.Constants;
import zz.org.eclipse.jgit.lib.ObjectId;
import zz.org.eclipse.jgit.lib.PersonIdent;
import zz.org.eclipse.jgit.revwalk.RevObject;

public class TagBuilder {
    private ObjectId object;
    private int type = -1;
    private String tag;
    private PersonIdent tagger;
    private String message;

    public int getObjectType() {
        return this.type;
    }

    public ObjectId getObjectId() {
        return this.object;
    }

    public void setObjectId(AnyObjectId obj, int objType) {
        this.object = obj.copy();
        this.type = objType;
    }

    public void setObjectId(RevObject obj) {
        this.setObjectId(obj, obj.getType());
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String shortName) {
        this.tag = shortName;
    }

    public PersonIdent getTagger() {
        return this.tagger;
    }

    public void setTagger(PersonIdent taggerIdent) {
        this.tagger = taggerIdent;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String newMessage) {
        this.message = newMessage;
    }

    public byte[] build() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
                w.write("object ");
                this.getObjectId().copyTo(w);
                w.write(10);
                w.write("type ");
                w.write(Constants.typeString(this.getObjectType()));
                w.write("\n");
                w.write("tag ");
                w.write(this.getTag());
                w.write("\n");
                if (this.getTagger() != null) {
                    w.write("tagger ");
                    w.write(this.getTagger().toExternalString());
                    w.write(10);
                }
                w.write(10);
                if (this.getMessage() != null) {
                    w.write(this.getMessage());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
        return os.toByteArray();
    }

    public byte[] toByteArray() {
        return this.build();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Tag");
        r.append("={\n");
        r.append("object ");
        r.append(this.object != null ? this.object.name() : "NOT_SET");
        r.append("\n");
        r.append("type ");
        r.append(this.object != null ? Constants.typeString(this.type) : "NOT_SET");
        r.append("\n");
        r.append("tag ");
        r.append(this.tag != null ? this.tag : "NOT_SET");
        r.append("\n");
        if (this.tagger != null) {
            r.append("tagger ");
            r.append(this.tagger);
            r.append("\n");
        }
        r.append("\n");
        r.append(this.message != null ? this.message : "");
        r.append("}");
        return r.toString();
    }
}

