/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.repository;

import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.repository.LocalRepository;

public class NoLocalRepositoryManagerException
extends RepositoryException {
    private final LocalRepository repository;

    public NoLocalRepositoryManagerException(LocalRepository repository) {
        this(repository, NoLocalRepositoryManagerException.toMessage(repository));
    }

    public NoLocalRepositoryManagerException(LocalRepository repository, String message) {
        super(message);
        this.repository = repository;
    }

    public NoLocalRepositoryManagerException(LocalRepository repository, Throwable cause) {
        this(repository, NoLocalRepositoryManagerException.toMessage(repository), cause);
    }

    public NoLocalRepositoryManagerException(LocalRepository repository, String message, Throwable cause) {
        super(message, cause);
        this.repository = repository;
    }

    private static String toMessage(LocalRepository repository) {
        if (repository != null) {
            return "No manager available for local repository (" + repository.getBasedir().getAbsolutePath() + ") of type " + repository.getContentType();
        }
        return "No connector available to access repository";
    }

    public LocalRepository getRepository() {
        return this.repository;
    }
}

