/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.jacksonstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.core.JsonGenerator;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.com.fasterxml.jackson.databind.SerializationFeature;
import zz.com.fasterxml.jackson.databind.node.ObjectNode;
import zz.com.fasterxml.jackson.dataformat.xml.XmlFactory;
import zz.com.fasterxml.jackson.dataformat.xml.XmlMapper;
import zz.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import zz.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import zz.org.json.JSONObject;
import zz.org.json.XML;
import zz.org.spdx.jacksonstore.JacksonDeSerializer;
import zz.org.spdx.jacksonstore.JacksonSerializer;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.storage.IModelStore;
import zz.org.spdx.storage.ISerializableModelStore;
import zz.org.spdx.storage.simple.ExtendedSpdxStore;

public class MultiFormatStore
extends ExtendedSpdxStore
implements ISerializableModelStore {
    static final Logger logger = LoggerFactory.getLogger(MultiFormatStore.class);
    private Format format;
    private Verbose verbose;
    static final ObjectMapper JSON_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    static final ObjectMapper XML_MAPPER = new XmlMapper().configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true).enable(SerializationFeature.INDENT_OUTPUT);
    static final YAMLFactory yamlFactory = new YAMLFactory();
    static final ObjectMapper YAML_MAPPER = new ObjectMapper(yamlFactory);
    static final XmlFactory xmlFactory = new XmlFactory();
    private ObjectMapper outputMapper;
    private ObjectMapper inputMapper;

    public MultiFormatStore(IModelStore baseStore, Format format, Verbose verbose) {
        super(baseStore);
        Objects.requireNonNull(format);
        Objects.requireNonNull(verbose);
        this.format = format;
        this.verbose = verbose;
        this.setMapper();
    }

    private void setMapper() {
        switch (this.format) {
            case XML: {
                this.outputMapper = XML_MAPPER;
                this.inputMapper = JSON_MAPPER;
                break;
            }
            case YAML: {
                this.outputMapper = YAML_MAPPER;
                this.inputMapper = YAML_MAPPER;
                break;
            }
            default: {
                this.outputMapper = JSON_MAPPER;
                this.inputMapper = JSON_MAPPER;
            }
        }
    }

    public MultiFormatStore(IModelStore baseStore, Format format) {
        this(baseStore, format, Verbose.COMPACT);
    }

    public synchronized Format getFormat() {
        return this.format;
    }

    public synchronized void setFormat(Format format) {
        Objects.requireNonNull(format);
        this.format = format;
        this.setMapper();
    }

    public synchronized Verbose getVerbose() {
        return this.verbose;
    }

    public synchronized void setVerbose(Verbose verbose) {
        Objects.requireNonNull(verbose);
        this.verbose = verbose;
        this.setMapper();
    }

    @Override
    public synchronized void serialize(String documentUri, OutputStream stream) throws InvalidSPDXAnalysisException, IOException {
        JacksonSerializer serializer = new JacksonSerializer(this.outputMapper, this.format, this.verbose, this);
        ObjectNode output = serializer.docToJsonNode(documentUri);
        JsonGenerator jgen = null;
        try {
            switch (this.format) {
                case YAML: {
                    jgen = yamlFactory.createGenerator(stream);
                    break;
                }
                case XML: {
                    jgen = this.outputMapper.getFactory().createGenerator(stream).useDefaultPrettyPrinter();
                    break;
                }
                case JSON: {
                    jgen = this.outputMapper.getFactory().createGenerator(stream);
                    break;
                }
                default: {
                    jgen = this.outputMapper.getFactory().createGenerator(stream).useDefaultPrettyPrinter();
                }
            }
            this.outputMapper.writeTree(jgen, output);
        }
        finally {
            if (Objects.nonNull(jgen)) {
                jgen.close();
            }
        }
    }

    public static String propertyNameToCollectionPropertyName(String propertyName) {
        if (propertyName.endsWith("y")) {
            return String.valueOf(propertyName.substring(0, propertyName.length() - 1)) + "ies";
        }
        if ("licenseInfoFromFiles".equals(propertyName)) {
            return propertyName;
        }
        return String.valueOf(propertyName) + "s";
    }

    public static String collectionPropertyNameToPropertyName(String collectionPropertyName) {
        if (collectionPropertyName.endsWith("ies")) {
            return String.valueOf(collectionPropertyName.substring(0, collectionPropertyName.length() - 3)) + "y";
        }
        if ("licenseInfoFromFiles".equals(collectionPropertyName)) {
            return collectionPropertyName;
        }
        return collectionPropertyName.substring(0, collectionPropertyName.length() - 1);
    }

    @Override
    public synchronized String deSerialize(InputStream stream, boolean overwrite) throws InvalidSPDXAnalysisException, IOException {
        JsonNode doc;
        Objects.requireNonNull(stream, "Input stream must not be null");
        if (this.verbose != Verbose.COMPACT) {
            throw new InvalidSPDXAnalysisException("Only COMPACT verbose option is supported for deserialization");
        }
        if (Format.XML.equals((Object)this.format)) {
            JSONObject jo = XML.toJSONObject(new InputStreamReader(stream, "UTF-8"));
            doc = this.inputMapper.readTree(jo.toString()).get("Document");
        } else {
            doc = this.inputMapper.readTree(stream);
        }
        if (Objects.isNull(doc)) {
            throw new InvalidSPDXAnalysisException("Missing SPDX Document");
        }
        JsonNode namespaceNode = doc.get("documentNamespace");
        if (Objects.isNull(namespaceNode)) {
            throw new InvalidSPDXAnalysisException("Missing document namespace");
        }
        String documentNamespace = namespaceNode.asText();
        if (Objects.isNull(documentNamespace) || documentNamespace.isEmpty()) {
            throw new InvalidSPDXAnalysisException("Empty document namespace");
        }
        if (this.getDocumentUris().contains(documentNamespace)) {
            IModelStore.IModelStoreLock lock = this.enterCriticalSection(documentNamespace, false);
            try {
                if (!overwrite) {
                    throw new InvalidSPDXAnalysisException("Document namespace " + documentNamespace + " already exists.");
                }
                this.clear(documentNamespace);
            }
            finally {
                this.leaveCriticalSection(lock);
            }
        }
        JacksonDeSerializer deSerializer = new JacksonDeSerializer(this, this.format);
        deSerializer.storeDocument(documentNamespace, doc);
        return documentNamespace;
    }

    public static enum Format {
        JSON,
        JSON_PRETTY,
        XML,
        YAML;

    }

    public static enum Verbose {
        COMPACT,
        STANDARD,
        FULL;

    }
}

