/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.utility.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.model.Annotation;
import zz.org.spdx.library.model.Checksum;
import zz.org.spdx.library.model.ExternalDocumentRef;
import zz.org.spdx.library.model.ModelObject;
import zz.org.spdx.library.model.Relationship;
import zz.org.spdx.library.model.SpdxCreatorInformation;
import zz.org.spdx.library.model.SpdxDocument;
import zz.org.spdx.library.model.SpdxElement;
import zz.org.spdx.library.model.SpdxFile;
import zz.org.spdx.library.model.SpdxModelFactory;
import zz.org.spdx.library.model.SpdxPackage;
import zz.org.spdx.library.model.SpdxPackageVerificationCode;
import zz.org.spdx.library.model.SpdxSnippet;
import zz.org.spdx.library.model.license.AnyLicenseInfo;
import zz.org.spdx.library.model.license.ExtractedLicenseInfo;
import zz.org.spdx.utility.compare.LicenseCompareHelper;
import zz.org.spdx.utility.compare.SpdxCompareException;
import zz.org.spdx.utility.compare.SpdxFileComparer;
import zz.org.spdx.utility.compare.SpdxFileDifference;
import zz.org.spdx.utility.compare.SpdxLicenseDifference;
import zz.org.spdx.utility.compare.SpdxPackageComparer;
import zz.org.spdx.utility.compare.SpdxSnippetComparer;

public class SpdxComparer {
    static final Logger logger = LoggerFactory.getLogger(SpdxComparer.class);
    private List<SpdxDocument> spdxDocs = null;
    private boolean differenceFound = false;
    private boolean compareInProgress = false;
    private boolean spdxVersionsEqual = true;
    private boolean documentCommentsEqual = true;
    private boolean dataLicenseEqual = true;
    private boolean licenseListVersionEquals = true;
    private boolean documentContentsEquals = true;
    private boolean creatorCommentsEqual = true;
    private boolean creationDatesEqual = true;
    private Map<SpdxDocument, Map<SpdxDocument, List<ExtractedLicenseInfo>>> uniqueExtractedLicenses = new HashMap<SpdxDocument, Map<SpdxDocument, List<ExtractedLicenseInfo>>>();
    private Map<SpdxDocument, Map<SpdxDocument, List<SpdxLicenseDifference>>> licenseDifferences = new HashMap<SpdxDocument, Map<SpdxDocument, List<SpdxLicenseDifference>>>();
    private Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap = new HashMap<SpdxDocument, Map<SpdxDocument, Map<String, String>>>();
    private boolean creatorInformationEquals;
    private Map<SpdxDocument, Map<SpdxDocument, List<String>>> uniqueCreators = new HashMap<SpdxDocument, Map<SpdxDocument, List<String>>>();
    private Map<SpdxDocument, Map<SpdxDocument, List<SpdxFile>>> uniqueFiles = new HashMap<SpdxDocument, Map<SpdxDocument, List<SpdxFile>>>();
    private Map<SpdxDocument, Map<SpdxDocument, List<SpdxFileDifference>>> fileDifferences = new HashMap<SpdxDocument, Map<SpdxDocument, List<SpdxFileDifference>>>();
    private Map<SpdxDocument, Map<SpdxDocument, List<SpdxPackage>>> uniquePackages = new HashMap<SpdxDocument, Map<SpdxDocument, List<SpdxPackage>>>();
    private Map<String, SpdxPackageComparer> packageComparers = new HashMap<String, SpdxPackageComparer>();
    private Map<SpdxDocument, Map<SpdxDocument, List<Annotation>>> uniqueDocumentAnnotations = new HashMap<SpdxDocument, Map<SpdxDocument, List<Annotation>>>();
    private Map<SpdxDocument, Map<SpdxDocument, List<Relationship>>> uniqueDocumentRelationships = new HashMap<SpdxDocument, Map<SpdxDocument, List<Relationship>>>();
    private Map<SpdxDocument, Map<SpdxDocument, List<ExternalDocumentRef>>> uniqueExternalDocumentRefs = new HashMap<SpdxDocument, Map<SpdxDocument, List<ExternalDocumentRef>>>();
    private Map<SpdxDocument, Map<SpdxDocument, List<SpdxSnippet>>> uniqueSnippets = new HashMap<SpdxDocument, Map<SpdxDocument, List<SpdxSnippet>>>();
    private Map<String, SpdxSnippetComparer> snippetComparers = new HashMap<String, SpdxSnippetComparer>();

    public void compare(SpdxDocument spdxDoc1, SpdxDocument spdxDoc2) throws InvalidSPDXAnalysisException, SpdxCompareException {
        this.compare(Arrays.asList(spdxDoc1, spdxDoc2));
    }

    public synchronized void compare(List<SpdxDocument> spdxDocuments) throws InvalidSPDXAnalysisException, SpdxCompareException {
        this.clearCompareResults();
        this.spdxDocs = spdxDocuments;
        this.differenceFound = false;
        this.performCompare();
    }

    private void performCompare() throws InvalidSPDXAnalysisException, SpdxCompareException {
        this.compareInProgress = true;
        this.differenceFound = false;
        this.compareExtractedLicenseInfos();
        this.compareDocumentFields();
        this.compareSnippets();
        this.compareFiles();
        this.comparePackages();
        this.compareCreators();
        this.compareDocumentAnnotations();
        this.compareDocumentRelationships();
        this.compareExternalDocumentRefs();
        this.compareInProgress = false;
    }

    private void compareSnippets() throws SpdxCompareException {
        if (this.spdxDocs == null || this.spdxDocs.size() < 1) {
            return;
        }
        this.uniqueSnippets.clear();
        this.snippetComparers.clear();
        for (int i = 0; i < this.spdxDocs.size(); ++i) {
            List<SpdxSnippet> snippetsA;
            Stream<?> snippetStreamA = null;
            try {
                snippetStreamA = SpdxModelFactory.getElements(this.spdxDocs.get(i).getModelStore(), this.spdxDocs.get(i).getDocumentUri(), null, SpdxSnippet.class);
                snippetsA = snippetStreamA.collect(Collectors.toList());
            }
            catch (InvalidSPDXAnalysisException e) {
                try {
                    throw new SpdxCompareException("Error collecting snippets from SPDX document " + this.spdxDocs.get(i).getName(), e);
                }
                catch (InvalidSPDXAnalysisException e1) {
                    throw new SpdxCompareException("Error collecting snippets from SPDX document ", e);
                }
            }
            finally {
                if (Objects.nonNull(snippetStreamA)) {
                    snippetStreamA.close();
                }
            }
            Collections.sort(snippetsA);
            this.addSnippetComparers(this.spdxDocs.get(i), snippetsA);
            Map<SpdxDocument, List<SpdxSnippet>> uniqueAMap = this.uniqueSnippets.get(this.spdxDocs.get(i));
            if (uniqueAMap == null) {
                uniqueAMap = new HashMap<SpdxDocument, List<SpdxSnippet>>();
            }
            for (int j = 0; j < this.spdxDocs.size(); ++j) {
                List<SpdxSnippet> snippetsB;
                if (j == i) continue;
                Stream<?> snippetStreamB = null;
                try {
                    snippetStreamB = SpdxModelFactory.getElements(this.spdxDocs.get(j).getModelStore(), this.spdxDocs.get(j).getDocumentUri(), null, SpdxSnippet.class);
                    snippetsB = snippetStreamB.collect(Collectors.toList());
                }
                catch (InvalidSPDXAnalysisException e) {
                    try {
                        throw new SpdxCompareException("Error collecting snippets from SPDX document " + this.spdxDocs.get(j).getName(), e);
                    }
                    catch (InvalidSPDXAnalysisException e1) {
                        throw new SpdxCompareException("Error collecting snippets from SPDX document ", e);
                    }
                }
                finally {
                    if (Objects.nonNull(snippetStreamB)) {
                        snippetStreamB.close();
                    }
                }
                Collections.sort(snippetsB);
                List<SpdxSnippet> uniqueAB = this.findUniqueSnippets(snippetsA, snippetsB);
                if (uniqueAB == null || uniqueAB.size() <= 0) continue;
                uniqueAMap.put(this.spdxDocs.get(j), uniqueAB);
            }
            if (uniqueAMap.isEmpty()) continue;
            this.uniqueSnippets.put(this.spdxDocs.get(i), uniqueAMap);
        }
        if (!this._isSnippetsEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private List<SpdxSnippet> findUniqueSnippets(List<SpdxSnippet> snippetsA, List<SpdxSnippet> snippetsB) {
        int bIndex = 0;
        int aIndex = 0;
        ArrayList<SpdxSnippet> alRetval = new ArrayList<SpdxSnippet>();
        while (aIndex < snippetsA.size()) {
            if (bIndex >= snippetsB.size()) {
                alRetval.add(snippetsA.get(aIndex));
                ++aIndex;
                continue;
            }
            int compareVal = snippetsA.get(aIndex).compareTo(snippetsB.get(bIndex));
            if (compareVal == 0) {
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compareVal > 0) {
                ++bIndex;
                continue;
            }
            alRetval.add(snippetsA.get(aIndex));
            ++aIndex;
        }
        return alRetval;
    }

    private void addSnippetComparers(SpdxDocument spdxDocument, List<SpdxSnippet> snippets) throws SpdxCompareException {
        for (SpdxSnippet snippet : snippets) {
            SpdxSnippetComparer comparer = this.snippetComparers.get(snippet.toString());
            if (comparer == null) {
                comparer = new SpdxSnippetComparer(this.extractedLicenseIdMap);
                this.snippetComparers.put(snippet.toString(), comparer);
            }
            try {
                comparer.addDocumentSnippet(spdxDocument, snippet);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxCompareException("Exception comparing SPDX snippets", e);
            }
        }
    }

    private void compareExternalDocumentRefs() throws InvalidSPDXAnalysisException {
        for (int i = 0; i < this.spdxDocs.size(); ++i) {
            Collection<ExternalDocumentRef> externalDocRefsA = this.spdxDocs.get(i).getExternalDocumentRefs();
            Map<SpdxDocument, List<ExternalDocumentRef>> uniqueAMap = this.uniqueExternalDocumentRefs.get(this.spdxDocs.get(i));
            if (uniqueAMap == null) {
                uniqueAMap = new HashMap<SpdxDocument, List<ExternalDocumentRef>>();
            }
            for (int j = 0; j < this.spdxDocs.size(); ++j) {
                Collection<ExternalDocumentRef> externalDocRefsB;
                List<ExternalDocumentRef> uniqueA;
                if (j == i || (uniqueA = SpdxComparer.findUniqueExternalDocumentRefs(externalDocRefsA, externalDocRefsB = this.spdxDocs.get(j).getExternalDocumentRefs())) == null || uniqueA.size() <= 0) continue;
                uniqueAMap.put(this.spdxDocs.get(j), uniqueA);
            }
            if (uniqueAMap.keySet().size() <= 0) continue;
            this.uniqueExternalDocumentRefs.put(this.spdxDocs.get(i), uniqueAMap);
        }
        if (!this._isExternalDcoumentRefsEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private void compareDocumentRelationships() throws InvalidSPDXAnalysisException {
        for (int i = 0; i < this.spdxDocs.size(); ++i) {
            Collection<Relationship> relationshipsA = this.spdxDocs.get(i).getRelationships();
            Map<SpdxDocument, List<Relationship>> uniqueAMap = this.uniqueDocumentRelationships.get(this.spdxDocs.get(i));
            if (uniqueAMap == null) {
                uniqueAMap = new HashMap<SpdxDocument, List<Relationship>>();
            }
            for (int j = 0; j < this.spdxDocs.size(); ++j) {
                Collection<Relationship> relationshipsB;
                List<Relationship> uniqueA;
                if (j == i || (uniqueA = SpdxComparer.findUniqueRelationships(relationshipsA, relationshipsB = this.spdxDocs.get(j).getRelationships())) == null || uniqueA.size() <= 0) continue;
                uniqueAMap.put(this.spdxDocs.get(j), uniqueA);
            }
            if (uniqueAMap.keySet().size() <= 0) continue;
            this.uniqueDocumentRelationships.put(this.spdxDocs.get(i), uniqueAMap);
        }
        if (!this._isDocumentRelationshipsEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private void compareDocumentAnnotations() throws InvalidSPDXAnalysisException {
        for (int i = 0; i < this.spdxDocs.size(); ++i) {
            Collection<Annotation> annotationsA = this.spdxDocs.get(i).getAnnotations();
            Map<SpdxDocument, List<Annotation>> uniqueAMap = this.uniqueDocumentAnnotations.get(this.spdxDocs.get(i));
            if (uniqueAMap == null) {
                uniqueAMap = new HashMap<SpdxDocument, List<Annotation>>();
            }
            for (int j = 0; j < this.spdxDocs.size(); ++j) {
                Collection<Annotation> annotationsB;
                List<Annotation> uniqueA;
                if (j == i || (uniqueA = SpdxComparer.findUniqueAnnotations(annotationsA, annotationsB = this.spdxDocs.get(j).getAnnotations())) == null || uniqueA.size() <= 0) continue;
                uniqueAMap.put(this.spdxDocs.get(j), uniqueA);
            }
            if (uniqueAMap.keySet().size() <= 0) continue;
            this.uniqueDocumentAnnotations.put(this.spdxDocs.get(i), uniqueAMap);
        }
        if (!this._isDocumentAnnotationsEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private void compareFiles() throws InvalidSPDXAnalysisException, SpdxCompareException {
        this.uniqueFiles.clear();
        this.fileDifferences.clear();
        for (int i = 0; i < this.spdxDocs.size(); ++i) {
            Map<SpdxDocument, List<SpdxFileDifference>> diffMap;
            Stream<?> fileStreamA = SpdxModelFactory.getElements(this.spdxDocs.get(i).getModelStore(), this.spdxDocs.get(i).getDocumentUri(), null, SpdxFile.class);
            List<SpdxFile> filesListA = fileStreamA.collect(Collectors.toList());
            fileStreamA.close();
            Collections.sort(filesListA);
            SpdxFile[] filesA = filesListA.toArray(new SpdxFile[filesListA.size()]);
            Map<SpdxDocument, List<SpdxFile>> uniqueAMap = this.uniqueFiles.get(this.spdxDocs.get(i));
            if (uniqueAMap == null) {
                uniqueAMap = new HashMap<SpdxDocument, List<SpdxFile>>();
            }
            if ((diffMap = this.fileDifferences.get(this.spdxDocs.get(i))) == null) {
                diffMap = new HashMap<SpdxDocument, List<SpdxFileDifference>>();
            }
            for (int j = 0; j < this.spdxDocs.size(); ++j) {
                List<SpdxFileDifference> differences;
                if (j == i) continue;
                Stream<?> fileStreamB = SpdxModelFactory.getElements(this.spdxDocs.get(j).getModelStore(), this.spdxDocs.get(j).getDocumentUri(), null, SpdxFile.class);
                List<SpdxFile> filesListB = fileStreamB.collect(Collectors.toList());
                fileStreamB.close();
                Collections.sort(filesListB);
                SpdxFile[] filesB = filesListB.toArray(new SpdxFile[filesListB.size()]);
                List<SpdxFile> uniqueAB = SpdxComparer.findUniqueFiles(filesA, filesB);
                if (uniqueAB != null && uniqueAB.size() > 0) {
                    uniqueAMap.put(this.spdxDocs.get(j), uniqueAB);
                }
                if ((differences = SpdxComparer.findFileDifferences(this.spdxDocs.get(i), this.spdxDocs.get(j), filesA, filesB, this.extractedLicenseIdMap)) == null || differences.size() <= 0) continue;
                diffMap.put(this.spdxDocs.get(j), differences);
            }
            if (!uniqueAMap.isEmpty()) {
                this.uniqueFiles.put(this.spdxDocs.get(i), uniqueAMap);
            }
            if (diffMap.isEmpty()) continue;
            this.fileDifferences.put(this.spdxDocs.get(i), diffMap);
        }
        if (!this._isFilesEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    protected List<SpdxPackage> collectAllPackages(SpdxDocument spdxDocument) throws InvalidSPDXAnalysisException {
        Stream<?> packageStream = SpdxModelFactory.getElements(spdxDocument.getModelStore(), spdxDocument.getDocumentUri(), null, SpdxPackage.class);
        List<SpdxPackage> retval = packageStream.collect(Collectors.toList());
        packageStream.close();
        return retval;
    }

    public List<SpdxFile> collectAllFiles(SpdxDocument spdxDocument) throws InvalidSPDXAnalysisException {
        Stream<?> fileElementStream = SpdxModelFactory.getElements(spdxDocument.getModelStore(), spdxDocument.getDocumentUri(), null, SpdxFile.class);
        List<SpdxFile> retval = fileElementStream.collect(Collectors.toList());
        fileElementStream.close();
        return retval;
    }

    static List<SpdxFileDifference> findFileDifferences(SpdxDocument docA, SpdxDocument docB, SpdxFile[] filesA, SpdxFile[] filesB, Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> licenseIdXlationMap) throws SpdxCompareException, InvalidSPDXAnalysisException {
        ArrayList<SpdxFileDifference> alRetval = new ArrayList<SpdxFileDifference>();
        int aIndex = 0;
        int bIndex = 0;
        while (aIndex < filesA.length && bIndex < filesB.length) {
            int compare = 0;
            Optional<String> nameA = filesA[aIndex].getName();
            Optional<String> nameB = filesB[bIndex].getName();
            if (nameA.isPresent() && nameB.isPresent()) {
                compare = nameA.get().compareTo(nameB.get());
            }
            if (compare == 0) {
                SpdxFileComparer fileComparer = new SpdxFileComparer(licenseIdXlationMap);
                fileComparer.addDocumentFile(docA, filesA[aIndex]);
                fileComparer.addDocumentFile(docB, filesB[bIndex]);
                if (fileComparer.isDifferenceFound()) {
                    alRetval.add(fileComparer.getFileDifference(docA, docB));
                }
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compare > 0) {
                ++bIndex;
                continue;
            }
            ++aIndex;
        }
        return alRetval;
    }

    static List<SpdxPackage> findUniquePackages(List<SpdxPackage> pkgsA, List<SpdxPackage> pkgsB) {
        int bIndex = 0;
        int aIndex = 0;
        ArrayList<SpdxPackage> alRetval = new ArrayList<SpdxPackage>();
        while (aIndex < pkgsA.size()) {
            if (bIndex >= pkgsB.size()) {
                alRetval.add(pkgsA.get(aIndex));
                ++aIndex;
                continue;
            }
            int compareVal = pkgsA.get(aIndex).compareTo(pkgsB.get(bIndex));
            if (compareVal == 0) {
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compareVal > 0) {
                ++bIndex;
                continue;
            }
            alRetval.add(pkgsA.get(aIndex));
            ++aIndex;
        }
        return alRetval;
    }

    static List<SpdxFile> findUniqueFiles(SpdxFile[] filesA, SpdxFile[] filesB) throws InvalidSPDXAnalysisException {
        int bIndex = 0;
        int aIndex = 0;
        ArrayList<SpdxFile> alRetval = new ArrayList<SpdxFile>();
        while (aIndex < filesA.length) {
            if (bIndex >= filesB.length) {
                alRetval.add(filesA[aIndex]);
                ++aIndex;
                continue;
            }
            int compareVal = SpdxComparer.compareStrings(filesA[aIndex].getName(), filesB[bIndex].getName());
            if (compareVal == 0) {
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compareVal > 0) {
                ++bIndex;
                continue;
            }
            alRetval.add(filesA[aIndex]);
            ++aIndex;
        }
        return alRetval;
    }

    private void compareCreators() throws InvalidSPDXAnalysisException {
        this.creatorInformationEquals = true;
        this.licenseListVersionEquals = true;
        for (int i = 0; i < this.spdxDocs.size(); ++i) {
            SpdxCreatorInformation creatorInfoA = this.spdxDocs.get(i).getCreationInfo();
            Collection<String> creatorsA = creatorInfoA.getCreators();
            Map<SpdxDocument, List<String>> uniqueAMap = this.uniqueCreators.get(this.spdxDocs.get(i));
            if (uniqueAMap == null) {
                uniqueAMap = new HashMap<SpdxDocument, List<String>>();
            }
            for (int j = 0; j < this.spdxDocs.size(); ++j) {
                if (j == i) continue;
                SpdxCreatorInformation creatorInfoB = this.spdxDocs.get(j).getCreationInfo();
                Collection<String> creatorsB = creatorInfoB.getCreators();
                List<String> uniqueA = this.findUniqueString(creatorsA, creatorsB);
                if (uniqueA != null && uniqueA.size() > 0) {
                    uniqueAMap.put(this.spdxDocs.get(j), uniqueA);
                }
                if (!SpdxComparer.stringsEqual(creatorInfoA.getComment(), creatorInfoB.getComment())) {
                    this.creatorCommentsEqual = false;
                    this.creatorInformationEquals = false;
                }
                if (!SpdxComparer.stringsEqual(creatorInfoA.getCreated(), creatorInfoB.getCreated())) {
                    this.creationDatesEqual = false;
                    this.creatorInformationEquals = false;
                }
                if (SpdxComparer.stringsEqual(creatorInfoA.getLicenseListVersion(), creatorInfoB.getLicenseListVersion())) continue;
                this.creatorInformationEquals = false;
                this.licenseListVersionEquals = false;
            }
            if (uniqueAMap.keySet().size() <= 0) continue;
            this.uniqueCreators.put(this.spdxDocs.get(i), uniqueAMap);
            this.creatorInformationEquals = false;
        }
        if (!this.creatorInformationEquals) {
            this.differenceFound = true;
        }
    }

    private List<String> findUniqueString(Collection<String> stringsA, Collection<String> stringsB) {
        if (stringsA == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> al = new ArrayList<String>();
        for (String stringA : stringsA) {
            boolean found = false;
            if (Objects.nonNull(stringsB)) {
                for (String stringB : stringsB) {
                    if (SpdxComparer.compareStrings(stringA, stringB) != 0) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            al.add(stringA);
        }
        return al;
    }

    private void comparePackages() throws SpdxCompareException {
        if (this.spdxDocs == null || this.spdxDocs.size() < 1) {
            return;
        }
        this.uniquePackages.clear();
        this.packageComparers.clear();
        for (int i = 0; i < this.spdxDocs.size(); ++i) {
            List<SpdxPackage> pkgsA;
            try {
                pkgsA = this.collectAllPackages(this.spdxDocs.get(i));
            }
            catch (InvalidSPDXAnalysisException e) {
                try {
                    throw new SpdxCompareException("Error collecting packages from SPDX document " + this.spdxDocs.get(i).getName(), e);
                }
                catch (InvalidSPDXAnalysisException e1) {
                    throw new SpdxCompareException("Error collecting packages from SPDX document ", e);
                }
            }
            Collections.sort(pkgsA);
            this.addPackageComparers(this.spdxDocs.get(i), pkgsA, this.extractedLicenseIdMap);
            Map<SpdxDocument, List<SpdxPackage>> uniqueAMap = this.uniquePackages.get(this.spdxDocs.get(i));
            if (uniqueAMap == null) {
                uniqueAMap = new HashMap<SpdxDocument, List<SpdxPackage>>();
            }
            for (int j = 0; j < this.spdxDocs.size(); ++j) {
                List<SpdxPackage> pkgsB;
                if (j == i) continue;
                try {
                    pkgsB = this.collectAllPackages(this.spdxDocs.get(j));
                }
                catch (InvalidSPDXAnalysisException e) {
                    try {
                        throw new SpdxCompareException("Error collecting packages from SPDX document " + this.spdxDocs.get(i).getName(), e);
                    }
                    catch (InvalidSPDXAnalysisException e1) {
                        throw new SpdxCompareException("Error collecting packages from SPDX document ", e);
                    }
                }
                Collections.sort(pkgsB);
                List<SpdxPackage> uniqueAB = SpdxComparer.findUniquePackages(pkgsA, pkgsB);
                if (uniqueAB == null || uniqueAB.size() <= 0) continue;
                uniqueAMap.put(this.spdxDocs.get(j), uniqueAB);
            }
            if (uniqueAMap.isEmpty()) continue;
            this.uniquePackages.put(this.spdxDocs.get(i), uniqueAMap);
        }
        if (!this._isPackagesEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private void addPackageComparers(SpdxDocument spdxDocument, List<SpdxPackage> pkgs, Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap) throws SpdxCompareException {
        try {
            ArrayList<String> addedPackageNames = new ArrayList<String>();
            for (SpdxPackage pkg : pkgs) {
                if (!pkg.getName().isPresent()) {
                    logger.warn("Missing package name for package comparer.  Skipping unnamed package");
                    continue;
                }
                Optional<String> pkgName = pkg.getName();
                if (!pkgName.isPresent()) continue;
                if (addedPackageNames.contains(pkgName.get())) {
                    logger.warn("Duplicate package names: " + pkgName.get() + ".  Only comparing the first instance");
                    continue;
                }
                SpdxPackageComparer mpc = this.packageComparers.get(pkgName.get());
                if (mpc == null) {
                    mpc = new SpdxPackageComparer(extractedLicenseIdMap);
                    this.packageComparers.put(pkgName.get(), mpc);
                }
                mpc.addDocumentPackage(spdxDocument, pkg);
                addedPackageNames.add(pkgName.get());
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            throw new SpdxCompareException("Error getting package name", ex);
        }
    }

    public boolean compareLicense(int doc1, AnyLicenseInfo license1, int doc2, AnyLicenseInfo license2) throws SpdxCompareException {
        this.checkDocsIndex(doc1);
        this.checkDocsIndex(doc2);
        Map<SpdxDocument, Map<String, String>> hm = this.extractedLicenseIdMap.get(this.spdxDocs.get(doc1));
        if (hm == null) {
            throw new SpdxCompareException("Compare License Error - Extracted license id map has not been initialized.");
        }
        Map<String, String> xlationMap = hm.get(this.spdxDocs.get(doc2));
        if (xlationMap == null) {
            throw new SpdxCompareException("Compare License Exception - Extracted license id map has not been initialized.");
        }
        try {
            return LicenseCompareHelper.isLicenseEqual(license1, license2, xlationMap);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCompareException("Error comparing licenses", e);
        }
    }

    static boolean compareVerificationCodes(Optional<SpdxPackageVerificationCode> verificationCode, Optional<SpdxPackageVerificationCode> verificationCode2) throws InvalidSPDXAnalysisException {
        if (!verificationCode.isPresent()) {
            return !verificationCode2.isPresent();
        }
        if (!verificationCode2.isPresent()) {
            return false;
        }
        if (!SpdxComparer.stringsEqual(verificationCode.get().getValue(), verificationCode2.get().getValue())) {
            return false;
        }
        return SpdxComparer.stringCollectionsEqual(verificationCode.get().getExcludedFileNames(), verificationCode2.get().getExcludedFileNames());
    }

    private void compareDocumentFields() throws SpdxCompareException {
        this.compareDataLicense();
        this.compareDocumentComments();
        this.compareSpdxVerions();
        this.compareDocumentContents();
        if (!(this.dataLicenseEqual && this.spdxVersionsEqual && this.documentCommentsEqual)) {
            this.differenceFound = true;
        }
    }

    private void compareDocumentContents() throws SpdxCompareException {
        this.documentContentsEquals = true;
        try {
            for (int i = 0; i < this.spdxDocs.size() - 1; ++i) {
                Collection<SpdxElement> itemsA = this.spdxDocs.get(i).getDocumentDescribes();
                for (int j = i + 1; j < this.spdxDocs.size(); ++j) {
                    Collection<SpdxElement> itemsB = this.spdxDocs.get(j).getDocumentDescribes();
                    if (SpdxComparer.collectionsEquivalent(itemsA, itemsB)) continue;
                    this.documentContentsEquals = false;
                    this.differenceFound = true;
                    return;
                }
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            throw new SpdxCompareException("Error getting SPDX document items: " + ex.getMessage());
        }
    }

    private void compareSpdxVerions() throws SpdxCompareException {
        try {
            String docVer1 = this.spdxDocs.get(0).getSpecVersion();
            this.spdxVersionsEqual = true;
            for (int i = 1; i < this.spdxDocs.size(); ++i) {
                if (this.spdxDocs.get(i).getSpecVersion().equals(docVer1)) continue;
                this.spdxVersionsEqual = false;
                break;
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            throw new SpdxCompareException("Error getting SPDX version", ex);
        }
    }

    private void compareDocumentComments() throws SpdxCompareException {
        try {
            Optional<String> comment1 = this.spdxDocs.get(0).getComment();
            this.documentCommentsEqual = true;
            for (int i = 1; i < this.spdxDocs.size(); ++i) {
                Optional<String> comment2 = this.spdxDocs.get(i).getComment();
                if (SpdxComparer.stringsEqual(comment1, comment2)) continue;
                this.documentCommentsEqual = false;
                break;
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            throw new SpdxCompareException("Error getting document comments", ex);
        }
    }

    private void compareDataLicense() throws SpdxCompareException {
        try {
            AnyLicenseInfo lic1 = this.spdxDocs.get(0).getDataLicense();
            this.dataLicenseEqual = true;
            for (int i = 1; i < this.spdxDocs.size(); ++i) {
                if (lic1.equals(this.spdxDocs.get(i).getDataLicense())) continue;
                this.dataLicenseEqual = false;
                break;
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCompareException("SPDX analysis error during compare data license: " + e.getMessage(), e);
        }
    }

    private void compareExtractedLicenseInfos() throws InvalidSPDXAnalysisException, SpdxCompareException {
        for (int i = 0; i < this.spdxDocs.size(); ++i) {
            Collection<ExtractedLicenseInfo> extractedLicensesA = this.spdxDocs.get(i).getExtractedLicenseInfos();
            HashMap<SpdxDocument, ArrayList<ExtractedLicenseInfo>> uniqueMap = new HashMap<SpdxDocument, ArrayList<ExtractedLicenseInfo>>();
            HashMap<SpdxDocument, ArrayList<SpdxLicenseDifference>> differenceMap = new HashMap<SpdxDocument, ArrayList<SpdxLicenseDifference>>();
            HashMap<SpdxDocument, HashMap<String, String>> licenseIdMap = new HashMap<SpdxDocument, HashMap<String, String>>();
            for (int j = 0; j < this.spdxDocs.size(); ++j) {
                if (i == j) continue;
                HashMap<String, String> idMap = new HashMap<String, String>();
                ArrayList<SpdxLicenseDifference> alDifferences = new ArrayList<SpdxLicenseDifference>();
                Collection<ExtractedLicenseInfo> extractedLicensesB = this.spdxDocs.get(j).getExtractedLicenseInfos();
                ArrayList<ExtractedLicenseInfo> uniqueLicenses = new ArrayList<ExtractedLicenseInfo>();
                this.compareLicenses(extractedLicensesA, extractedLicensesB, idMap, alDifferences, uniqueLicenses);
                if (uniqueLicenses.size() > 0) {
                    uniqueMap.put(this.spdxDocs.get(j), uniqueLicenses);
                }
                if (alDifferences.size() > 0) {
                    differenceMap.put(this.spdxDocs.get(j), alDifferences);
                }
                licenseIdMap.put(this.spdxDocs.get(j), idMap);
            }
            if (uniqueMap.keySet().size() > 0) {
                this.uniqueExtractedLicenses.put(this.spdxDocs.get(i), uniqueMap);
            }
            if (differenceMap.keySet().size() > 0) {
                this.licenseDifferences.put(this.spdxDocs.get(i), differenceMap);
            }
            this.extractedLicenseIdMap.put(this.spdxDocs.get(i), licenseIdMap);
        }
        if (!this._isExtractedLicensingInfoEqualsNoCheck()) {
            this.differenceFound = true;
        }
    }

    private void compareLicenses(Collection<ExtractedLicenseInfo> extractedLicensesA, Collection<ExtractedLicenseInfo> extractedLicensesB, Map<String, String> idMap, List<SpdxLicenseDifference> alDifferences, List<ExtractedLicenseInfo> uniqueLicenses) throws InvalidSPDXAnalysisException {
        idMap.clear();
        alDifferences.clear();
        uniqueLicenses.clear();
        for (ExtractedLicenseInfo licA : extractedLicensesA) {
            boolean foundMatch = false;
            boolean foundTextMatch = false;
            for (ExtractedLicenseInfo licB : extractedLicensesB) {
                if (!LicenseCompareHelper.isLicenseTextEquivalent(licA.getExtractedText(), licB.getExtractedText())) continue;
                foundTextMatch = true;
                if (!foundMatch) {
                    idMap.put(licA.getLicenseId(), licB.getLicenseId());
                }
                if (this.nonTextLicenseFieldsEqual(licA, licB)) {
                    foundMatch = true;
                    continue;
                }
                alDifferences.add(new SpdxLicenseDifference(licA, licB));
            }
            if (foundTextMatch) continue;
            uniqueLicenses.add(licA);
        }
    }

    private boolean nonTextLicenseFieldsEqual(ExtractedLicenseInfo spdxNonStandardLicenseA, ExtractedLicenseInfo spdxNonStandardLicenseB) throws InvalidSPDXAnalysisException {
        if (!SpdxComparer.stringsEqual(spdxNonStandardLicenseA.getName(), spdxNonStandardLicenseB.getName())) {
            return false;
        }
        if (!SpdxComparer.stringsEqual(spdxNonStandardLicenseA.getComment(), spdxNonStandardLicenseB.getComment())) {
            return false;
        }
        return SpdxComparer.stringCollectionsEqual(spdxNonStandardLicenseA.getSeeAlso(), spdxNonStandardLicenseB.getSeeAlso());
    }

    public static boolean stringCollectionsEqual(Collection<String> stringsA, Collection<String> stringsB) {
        if (stringsA == null) {
            return stringsB == null;
        }
        if (stringsB == null) {
            return false;
        }
        if (stringsA.size() != stringsB.size()) {
            return false;
        }
        for (String stA : stringsA) {
            if (stringsB.contains(stA)) continue;
            return false;
        }
        return true;
    }

    static boolean stringListsEqual(List<String> stringsA, List<String> stringsB) {
        if (stringsA == null) {
            return stringsB == null;
        }
        if (stringsB == null) {
            return false;
        }
        if (stringsA.size() != stringsB.size()) {
            return false;
        }
        for (String stA : stringsA) {
            if (stringsB.contains(stA)) continue;
            return false;
        }
        return true;
    }

    public static boolean objectsEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static boolean elementsEquivalent(Optional<? extends ModelObject> elementA, Optional<? extends ModelObject> elementB) throws InvalidSPDXAnalysisException {
        if (elementA.isPresent()) {
            if (elementB.isPresent()) {
                return elementA.get().equivalent(elementB.get());
            }
            return false;
        }
        return !elementB.isPresent();
    }

    public static boolean collectionsEquivalent(Collection<? extends ModelObject> collectionA, Collection<? extends ModelObject> collectionB) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(collectionA)) {
            return Objects.isNull(collectionB);
        }
        if (Objects.isNull(collectionB)) {
            return false;
        }
        if (collectionA.size() != collectionB.size()) {
            return false;
        }
        for (ModelObject modelObject : collectionA) {
            if (Objects.isNull(modelObject)) continue;
            boolean found = false;
            for (ModelObject modelObject2 : collectionB) {
                if (Objects.isNull(modelObject2) || !modelObject.equivalent(modelObject2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean listsEquals(List<? extends Object> a1, List<? extends Object> a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.size() != a2.size()) {
            return false;
        }
        for (Object object : a1) {
            if (a2.contains(object)) continue;
            return false;
        }
        return true;
    }

    public static boolean collectionsEquals(Collection<? extends Object> a1, Collection<? extends Object> a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.size() != a2.size()) {
            return false;
        }
        for (Object object : a1) {
            if (a2.contains(object)) continue;
            return false;
        }
        return true;
    }

    public static boolean stringsEqual(String stringA, String stringB) {
        String compA = stringA == null ? "" : stringA.replace("\r\n", "\n").trim();
        String compB = stringB == null ? "" : stringB.replace("\r\n", "\n").trim();
        return compA.equals(compB);
    }

    public static boolean stringsEqual(Optional<String> stringA, Optional<String> stringB) {
        String compA = !stringA.isPresent() ? "" : stringA.get().replace("\r\n", "\n").trim();
        String compB = !stringB.isPresent() ? "" : stringB.get().replace("\r\n", "\n").trim();
        return compA.equals(compB);
    }

    public static int compareStrings(String stringA, String stringB) {
        if (stringA == null) {
            if (stringB == null) {
                return 0;
            }
            return -1;
        }
        if (stringB == null) {
            return 1;
        }
        return stringA.trim().compareTo(stringB.trim());
    }

    public static int compareStrings(Optional<String> stringA, Optional<String> stringB) {
        if (!stringA.isPresent()) {
            if (!stringB.isPresent()) {
                return 0;
            }
            return -1;
        }
        if (!stringB.isPresent()) {
            return 1;
        }
        return stringA.get().trim().compareTo(stringB.get().trim());
    }

    private void clearCompareResults() {
        this.differenceFound = false;
        this.licenseDifferences.clear();
        this.uniqueExtractedLicenses.clear();
        this.extractedLicenseIdMap.clear();
        this.uniqueCreators.clear();
    }

    public boolean isDifferenceFound() {
        return this.differenceFound;
    }

    public boolean isSpdxVersionEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this.spdxVersionsEqual;
    }

    private void checkInProgress() throws SpdxCompareException {
        if (this.compareInProgress) {
            throw new SpdxCompareException("Compare in progress - can not obtain compare results until compare has completed");
        }
    }

    private void checkDocsField() throws SpdxCompareException {
        if (this.spdxDocs == null) {
            throw new SpdxCompareException("No compare has been performed");
        }
        if (this.spdxDocs.size() < 2) {
            throw new SpdxCompareException("Insufficient documents compared - must provide at least 2 SPDX documents");
        }
    }

    private void checkDocsIndex(int index) throws SpdxCompareException {
        if (this.spdxDocs == null) {
            throw new SpdxCompareException("No compare has been performed");
        }
        if (index < 0) {
            throw new SpdxCompareException("Invalid index for SPDX document compare - must be greater than or equal to zero");
        }
        if (index >= this.spdxDocs.size()) {
            throw new SpdxCompareException("Invalid index for SPDX document compare - SPDX document index " + String.valueOf(index) + " does not exist.");
        }
    }

    public SpdxDocument getSpdxDoc(int docIndex) throws SpdxCompareException {
        this.checkDocsField();
        if (this.spdxDocs == null) {
            return null;
        }
        if (docIndex < 0) {
            return null;
        }
        if (docIndex > this.spdxDocs.size()) {
            return null;
        }
        return this.spdxDocs.get(docIndex);
    }

    public boolean isDataLicenseEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this.dataLicenseEqual;
    }

    public boolean isDocumentCommentsEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this.documentCommentsEqual;
    }

    private boolean _isExternalDcoumentRefsEqualsNoCheck() {
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, List<ExternalDocumentRef>>>> iter = this.uniqueExternalDocumentRefs.entrySet().iterator();
        while (iter.hasNext()) {
            Iterator<List<ExternalDocumentRef>> docIterator = iter.next().getValue().values().iterator();
            while (docIterator.hasNext()) {
                if (docIterator.next().size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isExternalDcoumentRefsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this._isExternalDcoumentRefsEqualsNoCheck();
    }

    public boolean isExtractedLicensingInfosEqual() throws SpdxCompareException {
        this.checkInProgress();
        this.checkDocsField();
        return this._isExtractedLicensingInfoEqualsNoCheck();
    }

    private boolean _isExtractedLicensingInfoEqualsNoCheck() {
        Iterator<Map.Entry<SpdxDocument, List<Object>>> entryIter;
        for (Map.Entry<SpdxDocument, Map<SpdxDocument, List<ExtractedLicenseInfo>>> entry : this.uniqueExtractedLicenses.entrySet()) {
            entryIter = entry.getValue().entrySet().iterator();
            while (entryIter.hasNext()) {
                List<ExtractedLicenseInfo> licenses = entryIter.next().getValue();
                if (licenses == null || licenses.size() <= 0) continue;
                return false;
            }
        }
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, List<SpdxLicenseDifference>>>> diffIterator = this.licenseDifferences.entrySet().iterator();
        while (diffIterator.hasNext()) {
            entryIter = diffIterator.next().getValue().entrySet().iterator();
            while (entryIter.hasNext()) {
                List<Object> differences = entryIter.next().getValue();
                if (differences == null || differences.size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public List<ExtractedLicenseInfo> getUniqueExtractedLicenses(int docIndexA, int docIndexB) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docIndexA);
        this.checkDocsIndex(docIndexB);
        Map<SpdxDocument, List<ExtractedLicenseInfo>> uniques = this.uniqueExtractedLicenses.get(this.spdxDocs.get(docIndexA));
        if (uniques != null) {
            List<ExtractedLicenseInfo> retval = uniques.get(this.spdxDocs.get(docIndexB));
            if (retval != null) {
                return retval;
            }
            return new ArrayList<ExtractedLicenseInfo>();
        }
        return new ArrayList<ExtractedLicenseInfo>();
    }

    public List<SpdxLicenseDifference> getExtractedLicenseDifferences(int docIndexA, int docIndexB) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docIndexA);
        this.checkDocsIndex(docIndexB);
        Map<SpdxDocument, List<SpdxLicenseDifference>> differences = this.licenseDifferences.get(this.spdxDocs.get(docIndexA));
        if (differences != null) {
            List<SpdxLicenseDifference> retval = differences.get(this.spdxDocs.get(docIndexB));
            if (retval != null) {
                return retval;
            }
            return new ArrayList<SpdxLicenseDifference>();
        }
        return new ArrayList<SpdxLicenseDifference>();
    }

    public boolean isCreatorInformationEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.creatorInformationEquals;
    }

    public boolean isCreatorCommentsEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.creatorCommentsEqual;
    }

    public boolean isCreatorDatesEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.creationDatesEqual;
    }

    public List<String> getUniqueCreators(int doc1index, int doc2index) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        Map<SpdxDocument, List<String>> uniques = this.uniqueCreators.get(this.getSpdxDoc(doc1index));
        if (uniques == null) {
            return new ArrayList<String>();
        }
        List<String> retval = uniques.get(this.getSpdxDoc(doc2index));
        if (retval == null) {
            return new ArrayList<String>();
        }
        return retval;
    }

    public boolean isfilesEquals() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this._isFilesEqualsNoCheck();
    }

    public boolean isPackagesEquals() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this._isPackagesEqualsNoCheck();
    }

    public boolean isDocumentAnnotationsEquals() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this._isDocumentAnnotationsEqualsNoCheck();
    }

    private boolean _isDocumentAnnotationsEqualsNoCheck() {
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, List<Annotation>>>> iter = this.uniqueDocumentAnnotations.entrySet().iterator();
        while (iter.hasNext()) {
            Iterator<List<Annotation>> docIterator = iter.next().getValue().values().iterator();
            while (docIterator.hasNext()) {
                if (docIterator.next().size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDocumentRelationshipsEquals() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this._isDocumentRelationshipsEqualsNoCheck();
    }

    private boolean _isDocumentRelationshipsEqualsNoCheck() {
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, List<Relationship>>>> iter = this.uniqueDocumentRelationships.entrySet().iterator();
        while (iter.hasNext()) {
            Iterator<List<Relationship>> docIterator = iter.next().getValue().values().iterator();
            while (docIterator.hasNext()) {
                if (docIterator.next().size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean _isFilesEqualsNoCheck() {
        if (!this.uniqueFiles.isEmpty()) {
            return false;
        }
        return this.fileDifferences.isEmpty();
    }

    private boolean _isPackagesEqualsNoCheck() throws SpdxCompareException {
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, List<SpdxPackage>>>> iter = this.uniquePackages.entrySet().iterator();
        while (iter.hasNext()) {
            Iterator<List<SpdxPackage>> docIterator = iter.next().getValue().values().iterator();
            while (docIterator.hasNext()) {
                if (docIterator.next().size() <= 0) continue;
                return false;
            }
        }
        Iterator<SpdxPackageComparer> diffIter = this.packageComparers.values().iterator();
        while (diffIter.hasNext()) {
            if (!diffIter.next().isDifferenceFound()) continue;
            return false;
        }
        return true;
    }

    public List<SpdxFile> getUniqueFiles(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, List<SpdxFile>> uniqueMap = this.uniqueFiles.get(this.spdxDocs.get(docindex1));
        if (uniqueMap == null) {
            return new ArrayList<SpdxFile>();
        }
        List<SpdxFile> retval = uniqueMap.get(this.spdxDocs.get(docindex2));
        if (retval == null) {
            return new ArrayList<SpdxFile>();
        }
        return retval;
    }

    public List<SpdxFileDifference> getFileDifferences(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, List<SpdxFileDifference>> uniqueMap = this.fileDifferences.get(this.spdxDocs.get(docindex1));
        if (uniqueMap == null) {
            return new ArrayList<SpdxFileDifference>();
        }
        List<SpdxFileDifference> retval = uniqueMap.get(this.spdxDocs.get(docindex2));
        if (retval == null) {
            return new ArrayList<SpdxFileDifference>();
        }
        return retval;
    }

    public List<SpdxPackage> getUniquePackages(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, List<SpdxPackage>> uniqueMap = this.uniquePackages.get(this.spdxDocs.get(docindex1));
        if (uniqueMap == null) {
            return new ArrayList<SpdxPackage>();
        }
        List<SpdxPackage> retval = uniqueMap.get(this.spdxDocs.get(docindex2));
        if (retval == null) {
            return new ArrayList<SpdxPackage>();
        }
        return retval;
    }

    public List<ExternalDocumentRef> getUniqueExternalDocumentRefs(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, List<ExternalDocumentRef>> uniqueMap = this.uniqueExternalDocumentRefs.get(this.spdxDocs.get(docindex1));
        if (uniqueMap == null) {
            return new ArrayList<ExternalDocumentRef>();
        }
        List<ExternalDocumentRef> retval = uniqueMap.get(this.spdxDocs.get(docindex2));
        if (retval == null) {
            return new ArrayList<ExternalDocumentRef>();
        }
        return retval;
    }

    public List<Annotation> getUniqueDocumentAnnotations(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, List<Annotation>> uniqueMap = this.uniqueDocumentAnnotations.get(this.spdxDocs.get(docindex1));
        if (uniqueMap == null) {
            return new ArrayList<Annotation>();
        }
        List<Annotation> retval = uniqueMap.get(this.spdxDocs.get(docindex2));
        if (retval == null) {
            return new ArrayList<Annotation>();
        }
        return retval;
    }

    public List<Relationship> getUniqueDocumentRelationship(int docindex1, int docindex2) throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        this.checkDocsIndex(docindex1);
        this.checkDocsIndex(docindex2);
        Map<SpdxDocument, List<Relationship>> uniqueMap = this.uniqueDocumentRelationships.get(this.spdxDocs.get(docindex1));
        if (uniqueMap == null) {
            return new ArrayList<Relationship>();
        }
        List<Relationship> retval = uniqueMap.get(this.spdxDocs.get(docindex2));
        if (retval == null) {
            return new ArrayList<Relationship>();
        }
        return retval;
    }

    public List<SpdxPackageComparer> getPackageDifferences() throws SpdxCompareException {
        Collection<SpdxPackageComparer> comparers = this.packageComparers.values();
        Iterator<SpdxPackageComparer> iter = comparers.iterator();
        ArrayList<SpdxPackageComparer> retval = new ArrayList<SpdxPackageComparer>();
        while (iter.hasNext()) {
            SpdxPackageComparer comparer = iter.next();
            if (!comparer.isDifferenceFound()) continue;
            retval.add(comparer);
        }
        return retval;
    }

    public SpdxPackageComparer[] getPackageComparers() {
        return this.packageComparers.values().toArray(new SpdxPackageComparer[this.packageComparers.values().size()]);
    }

    public int getNumSpdxDocs() {
        return this.spdxDocs.size();
    }

    public boolean isLicenseListVersionEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this.licenseListVersionEquals;
    }

    public static List<Checksum> findUniqueChecksums(Collection<Checksum> checksumsA, Collection<Checksum> checksumsB) throws InvalidSPDXAnalysisException {
        ArrayList<Checksum> retval = new ArrayList<Checksum>();
        if (checksumsA != null) {
            for (Checksum ckA : checksumsA) {
                if (Objects.isNull(ckA)) continue;
                boolean found = false;
                if (Objects.nonNull(checksumsB)) {
                    for (Checksum ckB : checksumsB) {
                        if (!ckA.equivalent(ckB)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                retval.add(ckA);
            }
        }
        return retval;
    }

    public static List<Annotation> findUniqueAnnotations(Collection<Annotation> annotationsA, Collection<Annotation> annotationsB) throws InvalidSPDXAnalysisException {
        ArrayList<Annotation> retval = new ArrayList<Annotation>();
        if (Objects.nonNull(annotationsA)) {
            for (Annotation annA : annotationsA) {
                boolean found = false;
                if (Objects.nonNull(annotationsB)) {
                    for (Annotation annB : annotationsB) {
                        if (!annA.equivalent(annB)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                retval.add(annA);
            }
        }
        return retval;
    }

    public static List<Relationship> findUniqueRelationships(Collection<Relationship> relationshipsA, Collection<Relationship> relationshipsB) throws InvalidSPDXAnalysisException {
        ArrayList<Relationship> retval = new ArrayList<Relationship>();
        if (relationshipsA == null) {
            return retval;
        }
        for (Relationship relA : relationshipsA) {
            if (Objects.isNull(relA)) continue;
            boolean found = false;
            if (relationshipsB != null) {
                for (Relationship relB : relationshipsB) {
                    if (!relA.equivalent(relB)) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            retval.add(relA);
        }
        return retval;
    }

    public static List<ExternalDocumentRef> findUniqueExternalDocumentRefs(Collection<ExternalDocumentRef> externalDocRefsA, Collection<ExternalDocumentRef> externalDocRefsB) throws InvalidSPDXAnalysisException {
        ArrayList<ExternalDocumentRef> retval = new ArrayList<ExternalDocumentRef>();
        if (externalDocRefsA == null) {
            return new ArrayList<ExternalDocumentRef>();
        }
        for (ExternalDocumentRef docRefA : externalDocRefsA) {
            if (Objects.isNull(docRefA)) continue;
            boolean found = false;
            if (externalDocRefsB != null) {
                for (ExternalDocumentRef docRefB : externalDocRefsB) {
                    if (SpdxComparer.compareStrings(docRefA.getSpdxDocumentNamespace(), docRefB.getSpdxDocumentNamespace()) != 0 || !SpdxComparer.elementsEquivalent(docRefA.getChecksum(), docRefB.getChecksum())) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            retval.add(docRefA);
        }
        return retval;
    }

    public List<SpdxDocument> getSpdxDocuments() {
        return this.spdxDocs;
    }

    public boolean isDocumentContentsEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.documentContentsEquals;
    }

    public boolean isSnippetsEqual() throws SpdxCompareException {
        this.checkDocsField();
        this.checkInProgress();
        return this._isSnippetsEqualsNoCheck();
    }

    private boolean _isSnippetsEqualsNoCheck() throws SpdxCompareException {
        Iterator<Map.Entry<SpdxDocument, Map<SpdxDocument, List<SpdxSnippet>>>> iter = this.uniqueSnippets.entrySet().iterator();
        while (iter.hasNext()) {
            Iterator<List<SpdxSnippet>> docIterator = iter.next().getValue().values().iterator();
            while (docIterator.hasNext()) {
                if (docIterator.next().size() <= 0) continue;
                return false;
            }
        }
        Iterator<SpdxSnippetComparer> diffIter = this.snippetComparers.values().iterator();
        while (diffIter.hasNext()) {
            if (!diffIter.next().isDifferenceFound()) continue;
            return false;
        }
        return true;
    }

    public SpdxSnippetComparer[] getSnippetComparers() {
        return this.snippetComparers.values().toArray(new SpdxSnippetComparer[this.snippetComparers.values().size()]);
    }
}

