/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.utility.compare;

import java.util.List;
import java.util.Optional;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.model.Annotation;
import zz.org.spdx.library.model.Relationship;
import zz.org.spdx.library.model.SpdxItem;
import zz.org.spdx.library.model.license.AnyLicenseInfo;
import zz.org.spdx.utility.compare.SpdxCompareException;
import zz.org.spdx.utility.compare.SpdxComparer;

public class SpdxItemDifference {
    private String name;
    private String commentA;
    private String commentB;
    private String concludedLicenseA;
    private String concludedLicenseB;
    private boolean concludedLicenseEquals;
    private String copyrightA;
    private String copyrightB;
    private String licenseCommentsA;
    private String licenseCommentsB;
    private boolean seenLicensesEqual;
    private List<AnyLicenseInfo> uniqueSeenLicensesA;
    private List<AnyLicenseInfo> uniqueSeenLicensesB;
    private boolean relationshipsEquals;
    private List<Relationship> uniqueRelationshipA;
    private List<Relationship> uniqueRelationshipB;
    private boolean annotationsEquals;
    private List<Annotation> uniqueAnnotationsA;
    private List<Annotation> uniqueAnnotationsB;

    public SpdxItemDifference(SpdxItem itemA, SpdxItem itemB, boolean concludedLicensesEqual, boolean seenLicensesEqual, List<AnyLicenseInfo> uniqueSeenLicensesA, List<AnyLicenseInfo> uniqueSeenLicensesB, boolean relationshipsEquals, List<Relationship> uniqueRelationshipA, List<Relationship> uniqueRelationshipB, boolean annotationsEquals, List<Annotation> uniqueAnnotationsA, List<Annotation> uniqueAnnotationsB) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Optional<String> oLicenseCommentsA;
        Optional<String> oNameA = itemA.getName();
        this.name = oNameA.isPresent() ? oNameA.get() : "";
        Optional<String> oCommentA = itemA.getComment();
        this.commentA = oCommentA.isPresent() ? oCommentA.get() : "";
        Optional<String> oCommentB = itemB.getComment();
        this.commentB = oCommentB.isPresent() ? oCommentB.get() : "";
        this.concludedLicenseA = itemA.getLicenseConcluded().toString();
        this.concludedLicenseB = itemB.getLicenseConcluded().toString();
        this.concludedLicenseEquals = concludedLicensesEqual;
        this.copyrightA = itemA.getCopyrightText();
        if (this.copyrightA == null) {
            this.copyrightA = "";
        }
        this.copyrightB = itemB.getCopyrightText();
        if (this.copyrightB == null) {
            this.copyrightB = "";
        }
        this.licenseCommentsA = (oLicenseCommentsA = itemA.getLicenseComments()).isPresent() ? oLicenseCommentsA.get() : "";
        Optional<String> oLicenseCommentsB = itemB.getLicenseComments();
        this.licenseCommentsB = oLicenseCommentsB.isPresent() ? oLicenseCommentsB.get() : "";
        this.seenLicensesEqual = seenLicensesEqual;
        this.uniqueSeenLicensesA = uniqueSeenLicensesA;
        this.uniqueSeenLicensesB = uniqueSeenLicensesB;
        this.relationshipsEquals = relationshipsEquals;
        this.uniqueRelationshipA = uniqueRelationshipA;
        this.uniqueRelationshipB = uniqueRelationshipB;
        this.annotationsEquals = annotationsEquals;
        this.uniqueAnnotationsA = uniqueAnnotationsA;
        this.uniqueAnnotationsB = uniqueAnnotationsB;
    }

    public String getName() {
        return this.name;
    }

    public String getCommentA() {
        return this.commentA;
    }

    public String getCommentB() {
        return this.commentB;
    }

    public String getConcludedLicenseA() {
        return this.concludedLicenseA;
    }

    public String getConcludedLicenseB() {
        return this.concludedLicenseB;
    }

    public boolean isConcludedLicenseEquals() {
        return this.concludedLicenseEquals;
    }

    public String getCopyrightA() {
        return this.copyrightA;
    }

    public String getCopyrightB() {
        return this.copyrightB;
    }

    public String getLicenseCommentsA() {
        return this.licenseCommentsA;
    }

    public String getLicenseCommentsB() {
        return this.licenseCommentsB;
    }

    public boolean isSeenLicensesEquals() {
        return this.seenLicensesEqual;
    }

    public List<AnyLicenseInfo> getUniqueSeenLicensesA() {
        return this.uniqueSeenLicensesA;
    }

    public List<AnyLicenseInfo> getUniqueSeenLicensesB() {
        return this.uniqueSeenLicensesB;
    }

    public boolean isCommentsEquals() {
        return SpdxComparer.stringsEqual(this.commentA, this.commentB);
    }

    public boolean isCopyrightsEqual() {
        return SpdxComparer.stringsEqual(this.copyrightA, this.copyrightB);
    }

    public boolean isLicenseCommentsEqual() {
        return SpdxComparer.stringsEqual(this.licenseCommentsA, this.licenseCommentsB);
    }

    public boolean isRelationshipsEquals() {
        return this.relationshipsEquals;
    }

    public List<Relationship> getUniqueRelationshipA() {
        return this.uniqueRelationshipA;
    }

    public List<Relationship> getUniqueRelationshipB() {
        return this.uniqueRelationshipB;
    }

    public boolean isAnnotationsEquals() {
        return this.annotationsEquals;
    }

    public List<Annotation> getUniqueAnnotationsA() {
        return this.uniqueAnnotationsA;
    }

    public List<Annotation> getUniqueAnnotationsB() {
        return this.uniqueAnnotationsB;
    }
}

