/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz;

import java.io.InputStream;
import zz.org.tukaani.xz.BCJCoder;
import zz.org.tukaani.xz.FilterDecoder;
import zz.org.tukaani.xz.SimpleInputStream;
import zz.org.tukaani.xz.UnsupportedOptionsException;
import zz.org.tukaani.xz.simple.ARM;
import zz.org.tukaani.xz.simple.ARMThumb;
import zz.org.tukaani.xz.simple.IA64;
import zz.org.tukaani.xz.simple.PowerPC;
import zz.org.tukaani.xz.simple.SPARC;
import zz.org.tukaani.xz.simple.SimpleFilter;
import zz.org.tukaani.xz.simple.X86;

class BCJDecoder
extends BCJCoder
implements FilterDecoder {
    private final long filterID;
    private final int startOffset;
    static final /* synthetic */ boolean $assertionsDisabled;

    BCJDecoder(long l, byte[] byArray) throws UnsupportedOptionsException {
        if (!$assertionsDisabled && !BCJDecoder.isBCJFilterID(l)) {
            throw new AssertionError();
        }
        this.filterID = l;
        if (byArray.length == 0) {
            this.startOffset = 0;
        } else if (byArray.length == 4) {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                n |= (byArray[i] & 0xFF) << i * 8;
            }
            this.startOffset = n;
        } else {
            throw new UnsupportedOptionsException("Unsupported BCJ filter properties");
        }
    }

    public int getMemoryUsage() {
        return SimpleInputStream.getMemoryUsage();
    }

    public InputStream getInputStream(InputStream inputStream) {
        SimpleFilter simpleFilter = null;
        if (this.filterID == 4L) {
            simpleFilter = new X86(false, this.startOffset);
        } else if (this.filterID == 5L) {
            simpleFilter = new PowerPC(false, this.startOffset);
        } else if (this.filterID == 6L) {
            simpleFilter = new IA64(false, this.startOffset);
        } else if (this.filterID == 7L) {
            simpleFilter = new ARM(false, this.startOffset);
        } else if (this.filterID == 8L) {
            simpleFilter = new ARMThumb(false, this.startOffset);
        } else if (this.filterID == 9L) {
            simpleFilter = new SPARC(false, this.startOffset);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return new SimpleInputStream(inputStream, simpleFilter);
    }

    static {
        $assertionsDisabled = !BCJDecoder.class.desiredAssertionStatus();
    }
}

