/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz;

import java.io.IOException;
import java.io.InputStream;
import zz.org.tukaani.xz.XZIOException;
import zz.org.tukaani.xz.simple.SimpleFilter;

class SimpleInputStream
extends InputStream {
    private static final int FILTER_BUF_SIZE = 4096;
    private InputStream in;
    private final SimpleFilter simpleFilter;
    private final byte[] filterBuf = new byte[4096];
    private int pos = 0;
    private int filtered = 0;
    private int unfiltered = 0;
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];
    static final /* synthetic */ boolean $assertionsDisabled;

    static int getMemoryUsage() {
        return 5;
    }

    SimpleInputStream(InputStream inputStream, SimpleFilter simpleFilter) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (!$assertionsDisabled && simpleFilter == null) {
            throw new AssertionError();
        }
        this.in = inputStream;
        this.simpleFilter = simpleFilter;
    }

    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        try {
            int n3 = 0;
            while (true) {
                int n4 = Math.min(this.filtered, n2);
                System.arraycopy(this.filterBuf, this.pos, byArray, n, n4);
                this.pos += n4;
                this.filtered -= n4;
                n += n4;
                n2 -= n4;
                n3 += n4;
                if (this.pos + this.filtered + this.unfiltered == 4096) {
                    System.arraycopy(this.filterBuf, this.pos, this.filterBuf, 0, this.filtered + this.unfiltered);
                    this.pos = 0;
                }
                if (n2 == 0 || this.endReached) {
                    return n3 > 0 ? n3 : -1;
                }
                if (!$assertionsDisabled && this.filtered != 0) {
                    throw new AssertionError();
                }
                int n5 = 4096 - (this.pos + this.filtered + this.unfiltered);
                if ((n5 = this.in.read(this.filterBuf, this.pos + this.filtered + this.unfiltered, n5)) == -1) {
                    this.endReached = true;
                    this.filtered = this.unfiltered;
                    this.unfiltered = 0;
                    continue;
                }
                this.unfiltered += n5;
                this.filtered = this.simpleFilter.code(this.filterBuf, this.pos, this.unfiltered);
                if (!$assertionsDisabled && this.filtered > this.unfiltered) {
                    throw new AssertionError();
                }
                this.unfiltered -= this.filtered;
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    static {
        $assertionsDisabled = !SimpleInputStream.class.desiredAssertionStatus();
    }
}

