/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer;

import java.util.Arrays;

public class PropertyPath {
    private String[] pathComponents;
    private String pathString;

    public PropertyPath(String path) {
        this.pathString = path;
        this.pathComponents = path.isEmpty() ? null : path.split("/");
    }

    public PropertyPath(PropertyPath path) {
        this.pathString = path.pathString;
        this.pathComponents = path.isEmpty() ? null : Arrays.copyOf(path.pathComponents, path.pathComponents.length);
    }

    public int getNComponents() {
        return this.isEmpty() ? 0 : this.pathComponents.length;
    }

    public boolean isEmpty() {
        return this.pathComponents == null;
    }

    public String getNthComponent(int n) {
        if (n < 0 || n > this.getNComponents() - 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.pathComponents[n];
    }

    public String getPath() {
        return this.pathString;
    }

    public PropertyPath addComponent(String component) {
        return new PropertyPath(this.pathString.isEmpty() ? component : this.pathString + "/" + component);
    }

    public PropertyPath removeLastComponent() {
        if (this.isEmpty()) {
            return this;
        }
        if (this.getNComponents() == 1) {
            return new PropertyPath("");
        }
        StringBuilder sb = new StringBuilder(this.pathComponents[0]);
        for (int i = 1; i < this.pathComponents.length - 1; ++i) {
            sb.append("/").append(this.pathComponents[i]);
        }
        return new PropertyPath(sb.toString());
    }

    public PropertyPath removeFirstComponent() {
        if (this.isEmpty()) {
            return this;
        }
        if (this.getNComponents() == 1) {
            return new PropertyPath("");
        }
        StringBuilder sb = new StringBuilder(this.pathComponents[1]);
        for (int i = 2; i < this.pathComponents.length; ++i) {
            sb.append("/").append(this.pathComponents[i]);
        }
        return new PropertyPath(sb.toString());
    }

    public String getFirstComponent() {
        return this.isEmpty() ? null : this.pathComponents[0];
    }

    public String getLastComponent() {
        return this.isEmpty() ? null : this.pathComponents[this.pathComponents.length - 1];
    }

    public boolean isWild() {
        return !this.isEmpty() && this.getLastComponent().equals("*");
    }

    public boolean equals(Object rhso) {
        if (rhso == null || !(rhso instanceof PropertyPath)) {
            return false;
        }
        PropertyPath rhs = (PropertyPath)rhso;
        return this.pathString.equals(rhs.pathString);
    }

    public int hashCode() {
        return this.pathString.hashCode();
    }

    public String toString() {
        return this.pathString;
    }

    public boolean startsWith(PropertyPath p) {
        if (this.getNComponents() < p.getNComponents()) {
            return false;
        }
        for (int i = 0; i < p.getNComponents(); ++i) {
            if (this.pathComponents[i].equals(p.getNthComponent(i))) continue;
            return false;
        }
        return true;
    }
}

