/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.NoLogWebApplicationException;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnhandledException;
import org.jboss.resteasy.spi.WriterException;

public class ExceptionHandler {
    protected ResteasyProviderFactory providerFactory;
    protected Set<String> unwrappedExceptions = new HashSet<String>();
    protected boolean mapperExecuted;

    public ExceptionHandler(ResteasyProviderFactory providerFactory, Set<String> unwrappedExceptions) {
        this.providerFactory = providerFactory;
        this.unwrappedExceptions = unwrappedExceptions;
    }

    public boolean isMapperExecuted() {
        return this.mapperExecuted;
    }

    public Response executeExactExceptionMapper(Throwable exception) {
        ExceptionMapper mapper = this.providerFactory.getExceptionMappers().get(exception.getClass());
        if (mapper == null) {
            return null;
        }
        this.mapperExecuted = true;
        return mapper.toResponse(exception);
    }

    public Response executeExceptionMapperForClass(Throwable exception, Class clazz) {
        ExceptionMapper mapper = this.providerFactory.getExceptionMappers().get(clazz);
        if (mapper == null) {
            return null;
        }
        this.mapperExecuted = true;
        return mapper.toResponse(exception);
    }

    protected Response handleApplicationException(HttpRequest request, ApplicationException e) {
        Response jaxrsResponse = null;
        jaxrsResponse = this.executeExceptionMapperForClass(e, ApplicationException.class);
        if (jaxrsResponse != null) {
            return jaxrsResponse;
        }
        jaxrsResponse = this.unwrapException(request, e);
        if (jaxrsResponse == null) {
            throw new UnhandledException(e.getCause());
        }
        return jaxrsResponse;
    }

    public Response executeExceptionMapper(Throwable exception) {
        ExceptionMapper mapper = null;
        Class<?> causeClass = exception.getClass();
        while (mapper == null && causeClass != null) {
            mapper = this.providerFactory.getExceptionMappers().get(causeClass);
            if (mapper != null) continue;
            causeClass = causeClass.getSuperclass();
        }
        if (mapper != null) {
            this.mapperExecuted = true;
            Response jaxrsResponse = mapper.toResponse(exception);
            if (jaxrsResponse == null) {
                jaxrsResponse = Response.status((int)204).build();
            }
            return jaxrsResponse;
        }
        return null;
    }

    protected Response unwrapException(HttpRequest request, Throwable e) {
        WebApplicationException wae;
        Response response;
        Response jaxrsResponse = null;
        Throwable unwrappedException = e.getCause();
        if (unwrappedException instanceof WebApplicationException && (response = (wae = (WebApplicationException)unwrappedException).getResponse()) != null) {
            try {
                if (response.getEntity() != null) {
                    return response;
                }
            }
            catch (IllegalStateException ise) {
                return response;
            }
        }
        if ((jaxrsResponse = this.executeExceptionMapper(unwrappedException)) != null) {
            return jaxrsResponse;
        }
        if (unwrappedException instanceof WebApplicationException) {
            return this.handleWebApplicationException((WebApplicationException)unwrappedException);
        }
        if (unwrappedException instanceof Failure) {
            return this.handleFailure(request, (Failure)unwrappedException);
        }
        if (this.unwrappedExceptions.contains(unwrappedException.getClass().getName()) && unwrappedException.getCause() != null) {
            return this.unwrapException(request, unwrappedException);
        }
        return null;
    }

    protected Response handleFailure(HttpRequest request, Failure failure) {
        if (failure.isLoggable()) {
            LogMessages.LOGGER.failedExecutingError(request.getHttpMethod(), request.getUri().getPath(), failure);
        } else {
            LogMessages.LOGGER.failedExecutingDebug(request.getHttpMethod(), request.getUri().getPath(), failure);
        }
        if (failure.getResponse() != null) {
            return failure.getResponse();
        }
        Response.ResponseBuilder builder = Response.status((int)failure.getErrorCode());
        if (failure.getMessage() != null) {
            builder.type("text/html").entity((Object)failure.getMessage());
        }
        return builder.build();
    }

    protected Response handleClientErrorException(Response response, String message, int errorCode, Throwable cause) {
        if (response != null) {
            return response;
        }
        Response.ResponseBuilder builder = Response.status((int)errorCode);
        if (cause == null) {
            if (message != null) {
                builder.type("text/html").entity((Object)message);
            }
        } else {
            if (cause instanceof BadRequestException) {
                builder.status(400);
            } else if (cause instanceof NotFoundException) {
                builder.status(404);
            }
            if (cause.getMessage() != null) {
                builder.type("text/html").entity((Object)cause.getMessage());
            }
        }
        Response resp = builder.build();
        return resp;
    }

    protected Response handleWriterException(HttpRequest request, WriterException e) {
        Response jaxrsResponse = null;
        jaxrsResponse = this.executeExceptionMapperForClass(e, WriterException.class);
        if (jaxrsResponse != null) {
            return jaxrsResponse;
        }
        if (e.getResponse() != null || e.getErrorCode() > -1) {
            return this.handleFailure(request, e);
        }
        if (e.getCause() != null && (jaxrsResponse = this.unwrapException(request, e)) != null) {
            return jaxrsResponse;
        }
        e.setErrorCode(500);
        return this.handleFailure(request, e);
    }

    protected Response handleReaderException(HttpRequest request, ReaderException e) {
        Response jaxrsResponse = null;
        jaxrsResponse = this.executeExceptionMapperForClass(e, ReaderException.class);
        if (jaxrsResponse != null) {
            return jaxrsResponse;
        }
        if (e.getResponse() != null || e.getErrorCode() > -1) {
            return this.handleFailure(request, e);
        }
        if (e.getCause() != null && (jaxrsResponse = this.unwrapException(request, e)) != null) {
            return jaxrsResponse;
        }
        e.setErrorCode(400);
        return this.handleFailure(request, e);
    }

    protected Response handleWebApplicationException(WebApplicationException wae) {
        if (wae instanceof NotFoundException) {
            LogMessages.LOGGER.failedToExecuteDebug((Throwable)wae);
        } else if (!(wae instanceof NoLogWebApplicationException)) {
            LogMessages.LOGGER.failedToExecute((Throwable)wae);
        }
        return wae.getResponse();
    }

    public Response handleException(HttpRequest request, Throwable e) {
        Response jaxrsResponse = null;
        jaxrsResponse = this.executeExactExceptionMapper(e);
        if (jaxrsResponse == null) {
            if (e instanceof InternalServerErrorException || e instanceof ClientErrorException) {
                jaxrsResponse = this.executeExceptionMapper(e);
                if (jaxrsResponse == null) {
                    LogMessages.LOGGER.failedExecutingDebug(request.getHttpMethod(), request.getUri().getPath(), e);
                    jaxrsResponse = e instanceof InternalServerErrorException ? this.handleClientErrorException(((InternalServerErrorException)e).getResponse(), e.getMessage(), ((InternalServerErrorException)e).getErrorCode(), e.getCause()) : this.handleClientErrorException(((ClientErrorException)e).getResponse(), e.getMessage(), ((ClientErrorException)e).getResponse().getStatus(), e.getCause());
                }
            } else if (e instanceof WebApplicationException) {
                WebApplicationException wae = (WebApplicationException)e;
                if (wae.getResponse() != null && wae.getResponse().getEntity() != null) {
                    jaxrsResponse = wae.getResponse();
                } else {
                    jaxrsResponse = this.executeExceptionMapper(e);
                    if (jaxrsResponse == null) {
                        jaxrsResponse = this.handleWebApplicationException((WebApplicationException)e);
                    }
                }
            } else if (e instanceof Failure) {
                if (e instanceof WriterException) {
                    jaxrsResponse = this.handleWriterException(request, (WriterException)e);
                } else if (e instanceof ReaderException) {
                    jaxrsResponse = this.handleReaderException(request, (ReaderException)e);
                } else {
                    jaxrsResponse = this.executeExceptionMapper(e);
                    if (jaxrsResponse == null) {
                        jaxrsResponse = this.handleFailure(request, (Failure)e);
                    }
                }
            } else {
                jaxrsResponse = e instanceof ApplicationException ? this.handleApplicationException(request, (ApplicationException)e) : this.executeExceptionMapper(e);
            }
        }
        if (jaxrsResponse == null) {
            throw new UnhandledException(e);
        }
        return jaxrsResponse;
    }
}

