/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.jetty;

import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.bootstrap.internal.PropertyMap;
import org.sonatype.nexus.bootstrap.internal.ShutdownHelper;
import org.sonatype.nexus.bootstrap.jetty.ConnectorConfiguration;
import org.sonatype.nexus.bootstrap.jetty.ConnectorManager;

public class JettyServer {
    private static final Logger log = LoggerFactory.getLogger(JettyServer.class);
    private final ClassLoader classLoader;
    private final Map<String, String> properties;
    private final String[] args;
    private JettyMainThread thread;
    private ConnectorManager connectorManager;

    public JettyServer(ClassLoader classLoader, Map<String, String> properties, String[] args) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        this.classLoader = classLoader;
        if (properties == null) {
            throw new NullPointerException();
        }
        this.properties = properties;
        if (args == null) {
            throw new NullPointerException();
        }
        this.args = args;
    }

    private Exception propagateThrowable(Throwable e) throws Exception {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Exception) {
            throw (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new Error(e);
    }

    public List<ConnectorConfiguration> defaultConnectors() {
        return this.connectorManager.defaultConnectors();
    }

    public void addCustomConnector(ConnectorConfiguration connectorConfiguration) {
        this.connectorManager.addConnector(connectorConfiguration);
    }

    public void removeCustomConnector(ConnectorConfiguration connectorConfiguration) {
        this.connectorManager.removeConnector(connectorConfiguration);
    }

    public synchronized void start(boolean waitForServer, @Nullable Runnable callback) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            AtomicReference exception = new AtomicReference();
            AccessController.doPrivileged(() -> {
                try {
                    this.doStart(waitForServer, callback);
                }
                catch (Exception e) {
                    exception.set(e);
                }
                return null;
            });
            Throwable e = (Throwable)exception.get();
            if (e != null) {
                log.error("Start failed", e);
                throw this.propagateThrowable(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doStart(boolean waitForServer, @Nullable Runnable callback) throws Exception {
        void var7_10;
        if (this.thread != null) {
            throw new IllegalStateException("Already started");
        }
        log.info("Starting");
        ArrayList<LifeCycle> components = new ArrayList<LifeCycle>();
        PropertyMap props = new PropertyMap();
        props.putAll(this.properties);
        XmlConfiguration last = null;
        String[] stringArray = this.args;
        int n = this.args.length;
        boolean n2 = false;
        while (var7_10 < n) {
            String arg = stringArray[var7_10];
            URL url = Resource.newResource((String)arg).getURL();
            if (url.getFile().toLowerCase(Locale.ENGLISH).endsWith(".properties")) {
                log.info("Loading properties: {}", (Object)url);
                props.load(url);
            } else {
                Object component;
                log.info("Applying configuration: {}", (Object)url);
                XmlConfiguration configuration = new XmlConfiguration(url);
                if (last != null) {
                    configuration.getIdMap().putAll(last.getIdMap());
                }
                if (!props.isEmpty()) {
                    configuration.getProperties().putAll(props);
                }
                if ((component = configuration.configure()) instanceof LifeCycle) {
                    components.add((LifeCycle)component);
                }
                last = configuration;
            }
            ++var7_10;
        }
        if (components.isEmpty()) {
            throw new Exception("Failed to configure any components");
        }
        Server server = null;
        for (Object e : components) {
            if (!(e instanceof Server)) continue;
            server = (Server)e;
            break;
        }
        this.connectorManager = new ConnectorManager(server, last.getIdMap());
        this.thread = new JettyMainThread(components, callback);
        this.thread.setContextClassLoader(this.classLoader);
        this.thread.startComponents(waitForServer);
    }

    public synchronized void stop() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            AtomicReference exception = new AtomicReference();
            AccessController.doPrivileged(() -> {
                try {
                    this.doStop();
                }
                catch (Exception e) {
                    exception.set(e);
                }
                return null;
            });
            Throwable e = (Throwable)exception.get();
            if (e != null) {
                log.error("Stop failed", e);
                throw this.propagateThrowable(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void doStop() throws Exception {
        if (this.thread == null) {
            throw new IllegalStateException("Not started");
        }
        log.info("Stopping");
        this.thread.stopComponents();
        this.connectorManager = null;
        this.thread = null;
        log.info("Stopped");
    }

    private static class JettyMainThread
    extends Thread {
        private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(1);
        private final List<LifeCycle> components;
        private final Runnable callback;
        private final CountDownLatch started;
        private final CountDownLatch stopped;
        private volatile Exception exception;

        public JettyMainThread(List<LifeCycle> components, @Nullable Runnable callback) {
            super("jetty-main-" + INSTANCE_COUNTER.getAndIncrement());
            this.components = components;
            this.callback = callback;
            this.started = new CountDownLatch(1);
            this.stopped = new CountDownLatch(1);
        }

        @Override
        public void run() {
            Server server;
            block16: {
                server = null;
                try {
                    try {
                        block14: {
                            try {
                                try {
                                    for (LifeCycle component : this.components) {
                                        if (!component.isRunning()) {
                                            log.info("Starting: {}", (Object)component);
                                            component.start();
                                        }
                                        if (!(component instanceof Server)) continue;
                                        server = (Server)component;
                                    }
                                }
                                catch (Exception e) {
                                    this.exception = e;
                                    this.started.countDown();
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                this.started.countDown();
                                throw throwable;
                            }
                            this.started.countDown();
                        }
                        if (server != null) {
                            JettyMainThread.logStartupBanner(server);
                            if (this.callback != null) {
                                this.callback.run();
                            }
                            server.join();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.stopped.countDown();
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    this.stopped.countDown();
                    throw throwable;
                }
                this.stopped.countDown();
            }
            if (server == null) {
                log.error("Failed to start", (Throwable)this.exception);
                ShutdownHelper.exit(-1);
            }
        }

        public void startComponents(boolean waitForServer) throws Exception {
            this.start();
            if (waitForServer) {
                this.started.await();
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }

        public void stopComponents() throws Exception {
            Collections.reverse(this.components);
            this.interrupt();
            for (LifeCycle component : this.components) {
                if (!component.isRunning()) continue;
                log.info("Stopping: {}", (Object)component);
                component.stop();
            }
            this.components.clear();
            this.stopped.await();
        }

        private static void logStartupBanner(Server server) {
            ContextHandler.Context context;
            Object banner = null;
            ContextHandler contextHandler = (ContextHandler)server.getChildHandlerByClass(ContextHandler.class);
            if (contextHandler != null && (context = contextHandler.getServletContext()) != null) {
                banner = context.getAttribute("nexus-banner");
            }
            StringBuilder buf = new StringBuilder();
            buf.append("\n-------------------------------------------------\n\n");
            buf.append("Started ").append(banner instanceof String ? banner : "Nexus Repository Manager");
            buf.append("\n\n-------------------------------------------------");
            log.info(buf.toString());
        }
    }
}

