/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.config;

import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.gson.DefaultGsonBuilderConfigurator;
import com.softwarementors.extjs.djn.gson.GsonBuilderConfigurator;
import com.softwarementors.extjs.djn.router.dispatcher.Dispatcher;
import com.softwarementors.extjs.djn.router.processor.standard.json.DefaultJsonRequestProcessorThread;
import com.softwarementors.extjs.djn.router.processor.standard.json.JsonRequestProcessorThread;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;

public class GlobalConfiguration {
    public static final boolean DEFAULT_DEBUG_VALUE = false;
    @CheckForNull
    private String contextPath;
    @NonNull
    private String providersUrl;
    private boolean debug;
    @NonNull
    private Class<? extends GsonBuilderConfigurator> gsonBuilderConfiguratorClass;
    @NonNull
    private Class<? extends JsonRequestProcessorThread> jsonRequestProcessorThreadClass;
    @NonNull
    private Class<? extends Dispatcher> dispatcherClass;
    private boolean batchRequestsMultithreadingEnabled;
    private int batchRequestsMinThreadsPoolSize;
    private int batchRequestsMaxThreadsPoolSize;
    private int batchRequestsThreadKeepAliveSeconds;
    private int batchRequestsMaxThreadsPerRequest;
    private boolean minify;
    private boolean createSourceFiles;
    public static final int MIN_BATCH_REQUESTS_MIN_THREAD_POOL_SIZE = 0;
    public static final int MIN_BATCH_REQUESTS_MAX_THREAD_POOL_SIZE = 1;
    public static final int MIN_BATCH_REQUESTS_MAX_THREADS_PER_REQUEST = 1;
    public static final int MIN_BATCH_REQUESTS_THREAD_KEEP_ALIVE_SECONDS = 0;
    public static final boolean DEFAULT_BATCH_REQUESTS_MULTITHREADING_ENABLED_VALUE = true;
    public static final int DEFAULT_BATCH_REQUESTS_MAX_THREADS_PER_REQUEST = 8;
    public static final int DEFAULT_BATCH_REQUESTS_MIN_THREAD_POOL_SIZE = 16;
    public static final int DEFAULT_BATCH_REQUESTS_MAX_THREAD_POOL_SIZE = 80;
    public static final int DEFAULT_BATCH_REQUESTS_THREAD_KEEP_ALIVE_SECONDS = 60;
    public static final boolean DEFAULT_MINIFY_VALUE = true;
    public static final boolean DEFAULT_CREATE_SOURCE_FILES = true;
    @NonNull
    public static final Class<? extends GsonBuilderConfigurator> DEFAULT_GSON_BUILDER_CONFIGURATOR_CLASS = DefaultGsonBuilderConfigurator.class;
    @NonNull
    public static final Class<? extends JsonRequestProcessorThread> DEFAULT_JSON_REQUEST_PROCESSOR_THREAD_CLASS = DefaultJsonRequestProcessorThread.class;

    public GlobalConfiguration(String contextPath, String providersUrl, boolean debug, Class<? extends GsonBuilderConfigurator> gsonBuilderConfiguratorClass, Class<? extends JsonRequestProcessorThread> jsonRequestProcessorThreadClass, Class<? extends Dispatcher> dispatcherClass, boolean minify, boolean batchRequestsMultithreadingEnabled, int batchRequestsMinThreadsPoolSize, int batchRequestsMaxThreadsPoolSize, int batchRequestsThreadKeepAliveSeconds, int batchRequestsMaxThreadsPerRequest, boolean createSourceFiles) {
        assert (!StringUtils.isEmpty(providersUrl));
        assert (batchRequestsMinThreadsPoolSize >= 0);
        assert (batchRequestsMaxThreadsPoolSize >= 1);
        assert (batchRequestsThreadKeepAliveSeconds >= 0);
        assert (batchRequestsMaxThreadsPerRequest >= 1);
        assert (batchRequestsMinThreadsPoolSize <= batchRequestsMaxThreadsPoolSize);
        assert (gsonBuilderConfiguratorClass != null);
        assert (jsonRequestProcessorThreadClass != null);
        assert (dispatcherClass != null);
        this.contextPath = contextPath;
        this.providersUrl = providersUrl;
        this.debug = debug;
        this.minify = minify;
        this.gsonBuilderConfiguratorClass = gsonBuilderConfiguratorClass;
        this.jsonRequestProcessorThreadClass = jsonRequestProcessorThreadClass;
        this.dispatcherClass = dispatcherClass;
        this.batchRequestsMultithreadingEnabled = batchRequestsMultithreadingEnabled;
        this.batchRequestsMinThreadsPoolSize = batchRequestsMinThreadsPoolSize;
        this.batchRequestsMaxThreadsPoolSize = batchRequestsMaxThreadsPoolSize;
        this.batchRequestsThreadKeepAliveSeconds = batchRequestsThreadKeepAliveSeconds;
        this.batchRequestsMaxThreadsPerRequest = batchRequestsMaxThreadsPerRequest;
        this.createSourceFiles = createSourceFiles;
    }

    public String getProvidersUrl() {
        return this.providersUrl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public Class<? extends GsonBuilderConfigurator> getGsonBuilderConfiguratorClass() {
        return this.gsonBuilderConfiguratorClass;
    }

    public Class<? extends JsonRequestProcessorThread> getJsonRequestProcessorThreadClass() {
        return this.jsonRequestProcessorThreadClass;
    }

    public Class<? extends Dispatcher> getDispatcherClass() {
        return this.dispatcherClass;
    }

    public boolean getMinify() {
        return this.minify;
    }

    public boolean getBatchRequestsMultithreadingEnabled() {
        return this.batchRequestsMultithreadingEnabled;
    }

    public int getBatchRequestsMinThreadsPoolSize() {
        return this.batchRequestsMinThreadsPoolSize;
    }

    public int getBatchRequestsMaxThreadsPoolSize() {
        return this.batchRequestsMaxThreadsPoolSize;
    }

    public int getBatchRequestsThreadKeepAliveSeconds() {
        return this.batchRequestsThreadKeepAliveSeconds;
    }

    public int getBatchRequestsMaxThreadsPerRequest() {
        return this.batchRequestsMaxThreadsPerRequest;
    }

    @CheckForNull
    public String getContextPath() {
        return this.contextPath;
    }

    public boolean getCreateSourceFiles() {
        return this.createSourceFiles;
    }
}

