/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.gson;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.softwarementors.extjs.djn.config.GlobalConfiguration;
import com.softwarementors.extjs.djn.gson.GsonBuilderConfigurator;
import com.softwarementors.extjs.djn.router.processor.ServerExceptionInformation;
import com.softwarementors.extjs.djn.router.processor.poll.PollErrorResponseData;
import java.lang.reflect.Type;
import java.util.Date;

public class DefaultGsonBuilderConfigurator
implements GsonBuilderConfigurator {
    private static String clean(String toClean) {
        return toClean.replaceAll("[^\\w\\s.\\-:/]", "*");
    }

    @Override
    public void configure(GsonBuilder builder, GlobalConfiguration configuration) {
        assert (builder != null);
        assert (configuration != null);
        if (configuration.getDebug()) {
            builder.setPrettyPrinting();
        }
        builder.serializeNulls();
        builder.disableHtmlEscaping();
        builder.registerTypeAdapter(Date.class, (Object)new DateDeserializer());
        builder.registerTypeAdapter(Date.class, (Object)new DateSerializer());
        this.registerEncodingTypeAdapters(builder, configuration);
    }

    protected void registerEncodingTypeAdapters(GsonBuilder builder, GlobalConfiguration configuration) {
        builder.registerTypeAdapter(PollErrorResponseData.class, (Object)new PollErrorResponseDataSerializer());
        builder.registerTypeAdapter(ServerExceptionInformation.ExceptionInformation.class, (Object)new ExceptionInformationSerializer());
    }

    private static class ExceptionInformationSerializer
    implements JsonSerializer<ServerExceptionInformation.ExceptionInformation> {
        private ExceptionInformationSerializer() {
        }

        public JsonElement serialize(ServerExceptionInformation.ExceptionInformation src, Type typeOfSrc, JsonSerializationContext context) {
            assert (src != null);
            assert (typeOfSrc != null);
            assert (context != null);
            JsonObject result = new JsonObject();
            result.addProperty("type", DefaultGsonBuilderConfigurator.clean(src.type));
            result.addProperty("message", DefaultGsonBuilderConfigurator.clean(src.message));
            result.addProperty("where", DefaultGsonBuilderConfigurator.clean(src.where));
            return result;
        }
    }

    private static class PollErrorResponseDataSerializer
    implements JsonSerializer<PollErrorResponseData> {
        private PollErrorResponseDataSerializer() {
        }

        public JsonElement serialize(PollErrorResponseData src, Type typeOfSrc, JsonSerializationContext context) {
            assert (src != null);
            assert (typeOfSrc != null);
            assert (context != null);
            JsonObject result = new JsonObject();
            result.addProperty("message", DefaultGsonBuilderConfigurator.clean(src.message));
            result.addProperty("where", DefaultGsonBuilderConfigurator.clean(src.where));
            result.add("serverException", context.serialize((Object)src.serverException));
            return result;
        }
    }

    private static class DateSerializer
    implements JsonSerializer<Date> {
        private DateSerializer() {
        }

        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            assert (src != null);
            assert (context != null);
            assert (typeOfSrc != null);
            JsonPrimitive result = new JsonPrimitive((Number)src.getTime());
            return result;
        }
    }

    private static class DateDeserializer
    implements JsonDeserializer<Date> {
        private DateDeserializer() {
        }

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            assert (json != null);
            assert (context != null);
            assert (typeOfT != null);
            if (!json.isJsonPrimitive()) {
                throw new JsonParseException("The value for a Date must be a valid number");
            }
            assert (json instanceof JsonPrimitive);
            JsonPrimitive primitivejson = (JsonPrimitive)json;
            if (!primitivejson.isNumber()) {
                throw new JsonParseException("The value for a Date must be a valid number");
            }
            return new Date(primitivejson.getAsLong());
        }
    }
}

