/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.gson;

import com.softwarementors.extjs.djn.ClassUtils;
import com.softwarementors.extjs.djn.CollectionUtils;
import com.softwarementors.extjs.djn.StringUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class JsonDeserializationManager {
    @NonNull
    private static ThreadLocal<JsonDeserializationManager> manager = new ThreadLocal();
    @NonNull
    private static Set<Class<?>> manyValuedClasses = new HashSet();
    @NonNull
    private Stack<Object> parents = new Stack();
    @NonNull
    private Stack<String> fields = new Stack();
    @NonNull
    private Map<Object, Set<String>> fieldExclusions = new IdentityHashMap<Object, Set<String>>();
    @NonNull
    private Set<String> rootExclusions = new HashSet<String>();
    @NonNull
    private Set<String> rootInclusions = new HashSet<String>();
    private Object root;
    private boolean excludeManyValuedFields;

    public static void registerManyValuedClasses(Class<?> clazz, Class<?>[] otherClasses) {
        assert (clazz != null);
        assert (otherClasses != null);
        manyValuedClasses.add(clazz);
        Collections.addAll(manyValuedClasses, otherClasses);
    }

    JsonDeserializationManager() {
    }

    public static JsonDeserializationManager getManager() {
        if (manager.get() == null) {
            manager.set(new JsonDeserializationManager());
        }
        return manager.get();
    }

    public void friendOnlyAccess_pushField(String name) {
        assert (!StringUtils.isEmpty(name));
        this.fields.push(name);
    }

    public void friendOnlyAccess_popField() {
        this.fields.pop();
    }

    public void friendOnlyAccess_pushParent(Object obj) {
        assert (obj != null);
        this.parents.push(obj);
    }

    public void friendOnlyAccess_popParent() {
        this.parents.pop();
    }

    public void excludeManyValuedFields() {
        this.excludeManyValuedFields = true;
    }

    public void excludeFieldPaths(String firstFieldPath, String ... fieldPaths) {
        assert (this.rootExclusions != null);
        assert (firstFieldPath != null);
        assert (fieldPaths != null);
        this.rootInclusions.remove(firstFieldPath);
        CollectionUtils.removeAll(this.rootInclusions, fieldPaths);
        this.rootExclusions.add(firstFieldPath);
        Collections.addAll(this.rootExclusions, fieldPaths);
    }

    public void includeFieldPaths(String firstFieldPath, String ... fieldPaths) {
        assert (this.rootInclusions != null);
        assert (firstFieldPath != null);
        assert (fieldPaths != null);
        this.rootExclusions.remove(firstFieldPath);
        CollectionUtils.removeAll(this.rootExclusions, fieldPaths);
        this.rootInclusions.add(firstFieldPath);
        Collections.addAll(this.rootInclusions, fieldPaths);
    }

    public boolean friendOnlyAccess_isFieldExcluded(Object value, String field) {
        Set<String> ex;
        assert (value != null);
        assert (field != null);
        if (this.isRootManyValuedFieldExcluded(value, field)) {
            return true;
        }
        if (this.fieldExclusions.isEmpty()) {
            return false;
        }
        if (this.fieldExclusions.containsKey(value) && (ex = this.fieldExclusions.get(value)).contains(field)) {
            return true;
        }
        for (Object e : this.parents) {
            boolean exclude;
            if (!this.fieldExclusions.containsKey(e) || !(exclude = this.isFieldExcludedByObjectInParentsChain(e, field))) continue;
            return true;
        }
        return false;
    }

    private boolean isRootManyValuedFieldExcluded(Object value, String field) {
        assert (value != null);
        if (!this.excludeManyValuedFields || value != this.root) {
            return false;
        }
        Class<?> fieldType = ClassUtils.getFieldType(value.getClass(), field);
        if (fieldType == null) {
            return false;
        }
        return JsonDeserializationManager.isManyValuedClass(fieldType);
    }

    boolean isFieldExcludedByObjectInParentsChain(Object obj, String field) {
        assert (obj != null);
        assert (field != null);
        int positionInChain = this.parents.indexOf(obj);
        assert (positionInChain >= 0);
        StringBuilder path = new StringBuilder();
        for (int i = positionInChain; i < this.fields.size(); ++i) {
            path.append((String)this.fields.get(i));
            path.append('.');
        }
        path.append(field);
        Set<String> objectExclusions = this.fieldExclusions.get(obj);
        assert (objectExclusions != null);
        boolean excluded = objectExclusions.contains(path.toString());
        return excluded;
    }

    public void friendOnlyAccess_setRoot(Object root) {
        if (root != null) {
            this.root = root;
            this.fieldExclusions.put(root, this.rootExclusions);
        }
    }

    public void friendOnlyAccess_dispose() {
        manager.remove();
    }

    public static boolean isManyValuedClass(Class<?> clazz) {
        assert (clazz != null);
        if (clazz.isArray()) {
            return true;
        }
        for (Class<?> manyValuedClass : manyValuedClasses) {
            if (!manyValuedClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    static {
        manyValuedClasses.add(Collection.class);
    }
}

