/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.router.processor.standard.form.upload;

import com.softwarementors.extjs.djn.EncodingUtils;
import com.softwarementors.extjs.djn.api.Registry;
import com.softwarementors.extjs.djn.config.GlobalConfiguration;
import com.softwarementors.extjs.djn.router.dispatcher.Dispatcher;
import com.softwarementors.extjs.djn.router.processor.standard.form.FormPostRequestProcessorBase;
import com.softwarementors.extjs.djn.router.processor.standard.form.upload.FileUploadException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;

public class UploadFormPostRequestProcessor
extends FormPostRequestProcessorBase {
    @NonNull
    private static final Logger logger = Logger.getLogger(UploadFormPostRequestProcessor.class);

    public UploadFormPostRequestProcessor(Registry registry, Dispatcher dispatcher, GlobalConfiguration globalConfiguration) {
        super(registry, dispatcher, globalConfiguration);
    }

    public void process(List<FileItem> fileItems, Writer writer) throws IOException {
        assert (fileItems != null);
        assert (writer != null);
        HashMap<String, String> formParameters = new HashMap<String, String>();
        HashMap<String, FileItem> fileFields = new HashMap<String, FileItem>();
        for (FileItem item : fileItems) {
            if (item.isFormField()) {
                formParameters.put(item.getFieldName(), item.getString());
                continue;
            }
            fileFields.put(item.getFieldName(), item);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request data (UPLOAD FORM)=>" + UploadFormPostRequestProcessor.getFormParametersLogString(formParameters) + " FILES: " + UploadFormPostRequestProcessor.getFileParametersLogString(fileFields)));
        }
        String result = this.process(formParameters, fileFields);
        String resultString = "<html><body><textarea>";
        resultString = resultString + EncodingUtils.htmlEncode(result);
        resultString = resultString + "</textarea></body></html>";
        writer.write(resultString);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ResponseData data (UPLOAD FORM)=>" + resultString));
        }
    }

    private static String getFormParametersLogString(Map<String, String> formParameters) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : formParameters.entrySet()) {
            String fieldName = entry.getKey();
            String value = entry.getValue();
            result.append(fieldName);
            result.append("=");
            result.append(value);
            result.append(";");
        }
        return result.toString();
    }

    private static String getFileParametersLogString(Map<String, FileItem> fileFields) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, FileItem> entry : fileFields.entrySet()) {
            FileItem fileItem = entry.getValue();
            String fieldName = entry.getKey();
            result.append(fieldName);
            result.append("=");
            String fileName = fileItem.getName();
            result.append(fileName);
            result.append(";");
        }
        return result.toString();
    }

    public static ServletFileUpload createFileUploader(long maxUploadSize) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(maxUploadSize);
        upload.setFileSizeMax(maxUploadSize);
        return upload;
    }

    public void handleFileUploadException(org.apache.commons.fileupload.FileUploadException e) {
        assert (e != null);
        FileUploadException ex = FileUploadException.forFileUploadException(e);
        logger.error((Object)ex.getMessage(), (Throwable)ex);
        throw ex;
    }
}

