/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.servlet;

import com.softwarementors.extjs.djn.DirectJNgineException;
import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.gson.GsonBuilderConfigurator;
import com.softwarementors.extjs.djn.router.dispatcher.Dispatcher;
import com.softwarementors.extjs.djn.router.processor.standard.json.JsonRequestProcessorThread;
import com.softwarementors.extjs.djn.servlet.ServletRegistryConfigurator;
import java.util.List;

public class ServletConfigurationException
extends DirectJNgineException {
    private static final long serialVersionUID = -3328869605189206809L;

    private ServletConfigurationException(String message) {
        super(message);
        assert (!StringUtils.isEmpty(message));
    }

    private ServletConfigurationException(String message, Throwable cause) {
        super(message, cause);
        assert (!StringUtils.isEmpty(message));
        assert (cause != null);
    }

    public static ServletConfigurationException forMissingRequiredConfigurationParameter(List<String> missingParameters) {
        assert (missingParameters != null);
        assert (!missingParameters.isEmpty());
        String parameterNames = StringUtils.concatWithSeparator(missingParameters, ", ");
        return new ServletConfigurationException("The following servlet configuration parameters are missing: " + parameterNames + ". Please, check your servlet configuration in web.xml.");
    }

    public static ServletConfigurationException forClassNotFound(String className, ClassNotFoundException cause) {
        assert (cause != null);
        return new ServletConfigurationException("Unable to find class '" + className + "'", cause);
    }

    public static ServletConfigurationException forGsonBuilderConfiguratorMustImplementGsonBuilderConfiguratorInterface(String configuratorClassName) {
        return new ServletConfigurationException("The specified gson configurator class, '" + configuratorClassName + "', must implement the '" + GsonBuilderConfigurator.class + "' interface");
    }

    public static ServletConfigurationException forRegistryConfiguratorMustImplementGsonBuilderConfiguratorInterface(String registryConfiguratorClassName) {
        return new ServletConfigurationException("The specified registry configurator class, '" + registryConfiguratorClassName + "', must implement the '" + ServletRegistryConfigurator.class + "' interface");
    }

    public static ServletConfigurationException forParameterMustBeAnIntegerGreaterOrEqualToValue(String parameterName, int result, int minValue) {
        assert (!StringUtils.isEmpty(parameterName));
        return new ServletConfigurationException("Parameter, '" + parameterName + "' must be greater than or equal to '" + minValue + "'. It was '" + result + "'.");
    }

    public static ServletConfigurationException forParameterMustBeAValidInteger(String parameterName, String resultString) {
        assert (!StringUtils.isEmpty(parameterName));
        assert (!StringUtils.isEmpty(resultString));
        return new ServletConfigurationException("Parameter, '" + parameterName + "' must be a valid integer. It was '" + resultString + "'.");
    }

    public static ServletConfigurationException forMaxThreadPoolSizeMustBeEqualOrGreaterThanMinThreadPoolSize(int batchRequestsMinThreadsPoolSize, int batchRequestsMaxThreadsPoolSize) {
        return new ServletConfigurationException("The maximum batch request pool ('batchRequestsMaxThreadsPoolSize') size was " + batchRequestsMaxThreadsPoolSize + ". It must be greater or equal to the minimum request pool size ('" + "batchRequestsMinThreadsPoolSize" + "'), which was " + batchRequestsMinThreadsPoolSize);
    }

    public static ServletConfigurationException forDispatcherMustImplementDispatcherInterface(String dispatcherClassName) {
        return new ServletConfigurationException("The specified dispatcher class, '" + dispatcherClassName + "', must implement the '" + Dispatcher.class + "' interface");
    }

    public static ServletConfigurationException forJsonRequestProcessorThreadMustImplementJsonRequestProcessorThreadInterface(String jsonRequestProcessorThreadClassName) {
        return new ServletConfigurationException("The specified json request processor thread class, '" + jsonRequestProcessorThreadClassName + "', must implement the '" + JsonRequestProcessorThread.class + "' interface");
    }
}

