/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.servlet.ssm;

import com.softwarementors.extjs.djn.servlet.ssm.WebContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebContextManager {
    @NonNull
    private static ThreadLocal<WebContext> webContext = new ThreadLocal();

    public static WebContext get() {
        assert (WebContextManager.isWebContextAttachedToCurrentThread());
        return webContext.get();
    }

    public static void attachWebContextToCurrentThread(WebContext context) {
        assert (context != null);
        assert (!WebContextManager.isWebContextAttachedToCurrentThread());
        webContext.set(new WebContext(context));
    }

    public static void detachFromCurrentThread() {
        assert (WebContextManager.isWebContextAttachedToCurrentThread());
        webContext.get().close();
        webContext.remove();
    }

    public static WebContext initializeWebContextForCurrentThread(HttpServlet servlet, HttpServletRequest request, HttpServletResponse response) {
        assert (request != null);
        assert (response != null);
        assert (servlet != null);
        assert (!WebContextManager.isWebContextAttachedToCurrentThread());
        WebContext result = new WebContext(servlet, request, response);
        webContext.set(result);
        return result;
    }

    public static boolean isWebContextAttachedToCurrentThread() {
        WebContext context = webContext.get();
        return context != null;
    }
}

