/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.brain.client;

import com.sonatype.clm.dto.model.ProprietaryConfig;
import com.sonatype.clm.dto.model.application.ApplicationSummaryList;
import com.sonatype.clm.dto.model.component.FirewallIgnorePatterns;
import com.sonatype.clm.dto.model.organization.OrganizationSummaryList;
import com.sonatype.clm.dto.model.policy.Stage;
import com.sonatype.insight.brain.client.AbstractRequestClient;
import com.sonatype.insight.brain.client.UnsupportedServerVersionException;
import com.sonatype.insight.client.utils.AbstractClientBuilder;
import com.sonatype.insight.client.utils.HttpClientUtils;
import com.sonatype.insight.client.utils.Result;
import com.sonatype.insight.client.utils.UrlUtils;
import com.sonatype.insight.json.store.JsonUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.sonatype.aether.util.version.GenericVersionScheme;
import zz.org.sonatype.aether.version.InvalidVersionSpecificationException;
import zz.org.sonatype.aether.version.Version;

public class ConfigurationClient
extends AbstractRequestClient {
    static final String EVALUATE_APPLICATION = "EVALUATE_APPLICATION";

    public Set<String> getLicensedFeatures() throws IOException {
        Object result = this.path("rest/product/features").get();
        return new HashSet<Object>(Arrays.asList((Object[])this.parseResult((Result)result, String[].class)));
    }

    public ConfigurationClient(HttpClientUtils.Configuration config) {
        super(config);
    }

    public List<Stage> getLicensedStages(Context context) throws IOException {
        if (context == null) {
            throw new IllegalArgumentException("Context can not be null");
        }
        Object result = this.path("rest/policy/stages").query("context", context.name().toLowerCase(Locale.ENGLISH)).get();
        return Arrays.asList((Object[])this.parseResult((Result)result, Stage[].class));
    }

    public ApplicationSummaryList getApplicationsForApplicationEvaluation() throws IOException {
        Object result = this.path("rest/integration/applications").query("goal", EVALUATE_APPLICATION).get();
        return this.parseResult((Result)result, ApplicationSummaryList.class);
    }

    public ApplicationSummaryList getApplicationsForApplicationEvaluation(String organizationId) throws IOException {
        Object result = this.path("rest/integration/applications").query("goal", EVALUATE_APPLICATION, "organizationId", organizationId).get();
        return this.parseResult((Result)result, ApplicationSummaryList.class);
    }

    public OrganizationSummaryList getOrganizationsForApplicationEvaluation() throws IOException {
        Object result = this.path("rest/integration/organizations").query("goal", EVALUATE_APPLICATION).get();
        return this.parseResult((Result)result, OrganizationSummaryList.class);
    }

    public boolean verifyOrCreateApplication(String applicationPublicId, String organizationId) throws IOException {
        AbstractClientBuilder.RequestBuilder builder = this.path("rest/integration/applications/verifyOrCreate", UrlUtils.encodeUrlComponent(applicationPublicId));
        if (StringUtils.isNotBlank(organizationId)) {
            builder.query("goal", EVALUATE_APPLICATION, "organizationId", organizationId);
        } else {
            builder.query("goal", EVALUATE_APPLICATION);
        }
        Object result = builder.post(null);
        return this.parseResult((Result)result, Boolean.class);
    }

    public boolean verifyOrCreateApplication(String applicationPublicId) throws IOException {
        return this.verifyOrCreateApplication(applicationPublicId, null);
    }

    public ApplicationSummaryList getApplicationsForEvaluationSummary() throws IOException {
        Object result = this.path("rest/integration/applications?goal=SUMMARIZE_EVALUATION").get();
        return this.parseResult((Result)result, ApplicationSummaryList.class);
    }

    public void validateConfiguration() throws IOException {
        Object result = this.path("rest/config/proprietary").get();
        this.verifyStatusCode((Result)result);
        String text = ((Result)result).text();
        try {
            JsonUtils.parse(text, Map.class);
        }
        catch (Exception e) {
            throw new IOException("Server is not compatible with this Nexus IQ integration", e);
        }
    }

    public void validateApplicationId(String appId) throws IOException {
        Object result = this.path("rest/application/validate", UrlUtils.encodeUrlComponent(appId)).get();
        this.verifyStatusCode((Result)result);
        String text = ((Result)result).text();
        if (!"OK".equals(text)) {
            throw new IOException(text);
        }
    }

    public ProprietaryConfig getProprietaryConfigForApplicationEvaluation(String applicationPublicId) throws IOException {
        Object result = this.path("rest/config/proprietary").query("goal", EVALUATE_APPLICATION, "applicationPublicId", applicationPublicId).get();
        return this.parseResult((Result)result, ProprietaryConfig.class);
    }

    public ProprietaryConfig getProprietaryConfigForComponentEvaluation(String applicationPublicId) throws IOException {
        Object result = this.path("rest/config/proprietary").query("goal", "EVALUATE_COMPONENT", "applicationPublicId", applicationPublicId).get();
        return this.parseResult((Result)result, ProprietaryConfig.class);
    }

    public FirewallIgnorePatterns getFirewallIgnorePatterns() throws IOException {
        Object result = this.path("rest/integration/repositories/evaluate/ignorePatterns").get();
        return this.parseResult((Result)result, FirewallIgnorePatterns.class);
    }

    public void validateServerVersion(String minimalServerVersionRequiredAsString) throws IOException {
        Object result = this.path("rest/product/version").get();
        Properties serverVersionProperties = this.parseResult((Result)result, Properties.class);
        try {
            String serverVersionAsString = serverVersionProperties.getProperty("version");
            serverVersionAsString = serverVersionAsString.replace("-SNAPSHOT", "");
            GenericVersionScheme scheme = new GenericVersionScheme();
            Version serverVersion = scheme.parseVersion(serverVersionAsString);
            Version minimalServerVersion = scheme.parseVersion(minimalServerVersionRequiredAsString);
            if (serverVersion.compareTo(minimalServerVersion) < 0) {
                throw new UnsupportedServerVersionException(serverVersionAsString, minimalServerVersion.toString());
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static enum Context {
        ALL,
        CI,
        CLI,
        QA,
        RM,
        MAVEN;

    }
}

