/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.brain.client;

import com.sonatype.clm.dto.model.repository.migration.MigrationDetails;
import com.sonatype.insight.brain.client.AbstractRequestClient;
import com.sonatype.insight.client.utils.HttpClientUtils;
import com.sonatype.insight.client.utils.Result;
import java.io.IOException;

public class FirewallMigrationClient
extends AbstractRequestClient {
    private static final String RESOURCE_PATH = "rest/integration/repositories/migration";
    private static final String SUPPORTED_PATH = "supported";
    private static final String HISTORY_PATH = "history";

    public FirewallMigrationClient(HttpClientUtils.Configuration config) {
        super(config);
    }

    public void verifyMigrationSupport(String protocolVersion) throws IOException {
        this.verifyStatusCode((Result)this.path(RESOURCE_PATH, SUPPORTED_PATH, protocolVersion).post(null));
    }

    public void migrateRepositoryHistory(String sourceRepositoryManagerInstanceId, String sourceRepositoryPublicId, String targetRepositoryManagerInstanceId, String targetRepositoryPublicId) throws IOException {
        Object result = this.path(RESOURCE_PATH, HISTORY_PATH, targetRepositoryManagerInstanceId, targetRepositoryPublicId).query("sourceRepositoryManagerInstanceId", sourceRepositoryManagerInstanceId, "sourceRepositoryPublicId", sourceRepositoryPublicId).post(null);
        this.verifyStatusCode((Result)result);
    }

    public MigrationDetails getRepositoryMigrationState(String targetRepositoryManagerInstanceId, String targetRepositoryPublicId) throws IOException {
        Object result = this.path(RESOURCE_PATH, HISTORY_PATH, targetRepositoryManagerInstanceId, targetRepositoryPublicId).get();
        return this.parseResult((Result)result, MigrationDetails.class);
    }
}

