/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.archive;

import com.sonatype.insight.scan.archive.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class RegexSelector
implements Selector {
    public static final String PROPERTY_NAME = "proprietaryRegexes";
    private static final List<String> BLACK_LIST = Collections.unmodifiableList(Arrays.asList(".*", "^.*$"));
    private final List<Pattern> regexExclusionPatterns;
    private final String name;

    public RegexSelector(Collection<String> regexExcludes, String name) {
        if (regexExcludes == null) {
            throw new IllegalArgumentException("Regex patterns may not be null");
        }
        this.name = name;
        this.regexExclusionPatterns = this.convertToPatterns(regexExcludes);
    }

    public static RegexSelector forProprietaryRegexes(String regexExcludes) {
        List<String> regexps = regexExcludes != null && !regexExcludes.trim().isEmpty() ? Arrays.asList(regexExcludes.split(":::")) : Collections.emptyList();
        return RegexSelector.forProprietaryRegexes(regexps);
    }

    public static RegexSelector forProprietaryRegexes(Collection<String> regexExcludes) {
        return new RegexSelector(regexExcludes, "proprietaryRegex");
    }

    @Override
    public Selector.Selection isSelected(String path) {
        for (Pattern regexExclusionPattern : this.regexExclusionPatterns) {
            if (!regexExclusionPattern.matcher(path).matches()) continue;
            return Selector.Selection.EXCLUDED;
        }
        return Selector.Selection.SELECTED;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private List<Pattern> convertToPatterns(Collection<String> regexExcludes) {
        ArrayList<Pattern> regexExclusionPatterns = new ArrayList<Pattern>();
        for (String regexExclude : regexExcludes) {
            if (BLACK_LIST.contains(regexExclude)) {
                throw new IllegalArgumentException("This regex is specifically disallowed: " + regexExclude);
            }
            regexExclusionPatterns.add(Pattern.compile(regexExclude));
        }
        return regexExclusionPatterns;
    }
}

