/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.archive;

import com.sonatype.insight.scan.archive.InsightJarDriver;
import com.sonatype.insight.scan.archive.InsightReadOnlySfxDriver;
import com.sonatype.insight.scan.archive.InsightTarBZip2Driver;
import com.sonatype.insight.scan.archive.InsightTarDriver;
import com.sonatype.insight.scan.archive.InsightTarGZipDriver;
import com.sonatype.insight.scan.archive.InsightTarXZDriver;
import com.sonatype.insight.scan.archive.InsightZipDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import zz.de.schlichtherle.truezip.file.TArchiveDetector;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;
import zz.de.schlichtherle.truezip.fs.FsCharsetArchiveDriver;
import zz.de.schlichtherle.truezip.fs.FsDriver;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsScheme;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarBZip2Driver;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarGZipDriver;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarXZDriver;
import zz.de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import zz.de.schlichtherle.truezip.fs.archive.zip.OdfDriver;
import zz.de.schlichtherle.truezip.fs.archive.zip.ReadOnlySfxDriver;
import zz.de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import zz.de.schlichtherle.truezip.fs.sl.FsDriverLocator;
import zz.de.schlichtherle.truezip.socket.sl.IOPoolLocator;

public class TFileUtils {
    public static long dataLength(TFile file) {
        TFile parent = file.getEnclArchive();
        if (parent == null) {
            return new File(file.getPath()).length();
        }
        TFile innerArchive = file.getInnerArchive();
        if (null != innerArchive) {
            return new TFile((File)file.getParentFile(), file.getName(), TArchiveDetector.NULL).length();
        }
        return file.getFile().length();
    }

    public static InputStream openInputStream(TFile file) throws IOException {
        if (file.isArchive()) {
            TFile parent = file.getEnclArchive();
            if (parent == null) {
                return new FileInputStream(file);
            }
            return new TFileInputStream(new TFile((File)file.getParentFile(), file.getName(), TArchiveDetector.NULL));
        }
        return new TFileInputStream(file);
    }

    public static TArchiveDetector getArchiveDetector(Map<Driver, String> driverMappings, Collection<String> badExtensions) {
        HashMap<FsScheme, FsDriver> drivers = new HashMap<FsScheme, FsDriver>(FsDriverLocator.SINGLETON.get());
        InsightZipDriver zipDriver = new InsightZipDriver(IOPoolLocator.SINGLETON);
        InsightJarDriver jarDriver = new InsightJarDriver(IOPoolLocator.SINGLETON);
        InsightReadOnlySfxDriver sfxDriver = new InsightReadOnlySfxDriver(IOPoolLocator.SINGLETON);
        InsightTarDriver tarDriver = new InsightTarDriver(IOPoolLocator.SINGLETON);
        InsightTarBZip2Driver tarBZip2Driver = new InsightTarBZip2Driver(IOPoolLocator.SINGLETON);
        InsightTarGZipDriver tarGZipDriver = new InsightTarGZipDriver(IOPoolLocator.SINGLETON);
        InsightTarXZDriver tarXZDriver = new InsightTarXZDriver(IOPoolLocator.SINGLETON);
        Iterator it = drivers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() instanceof OdfDriver) {
                it.remove();
                continue;
            }
            if (entry.getValue() instanceof JarDriver) {
                entry.setValue(jarDriver);
                continue;
            }
            if (entry.getValue() instanceof ReadOnlySfxDriver) {
                entry.setValue(sfxDriver);
                continue;
            }
            if (entry.getValue() instanceof ZipDriver) {
                entry.setValue(zipDriver);
                continue;
            }
            if (entry.getValue() instanceof TarBZip2Driver) {
                entry.setValue(tarBZip2Driver);
                continue;
            }
            if (entry.getValue() instanceof TarGZipDriver) {
                entry.setValue(tarGZipDriver);
                continue;
            }
            if (entry.getValue() instanceof TarXZDriver) {
                entry.setValue(tarXZDriver);
                continue;
            }
            if (!(entry.getValue() instanceof TarDriver)) continue;
            entry.setValue(tarDriver);
        }
        for (FsScheme fsScheme : TFileUtils.toSchemes("hpi,wsr,har,sar,aar,rar,mar,nbm,whl", null)) {
            drivers.put(fsScheme, jarDriver);
        }
        for (FsScheme fsScheme : TFileUtils.toSchemes("nupkg", null)) {
            drivers.put(fsScheme, zipDriver);
        }
        for (Map.Entry entry : driverMappings.entrySet()) {
            FsCharsetArchiveDriver driver;
            List<FsScheme> schemes = TFileUtils.toSchemes((String)entry.getValue(), badExtensions);
            if (schemes.isEmpty()) continue;
            switch ((Driver)((Object)entry.getKey())) {
                case ZIP: {
                    driver = zipDriver;
                    break;
                }
                case JAR: {
                    driver = jarDriver;
                    break;
                }
                case TAR: {
                    driver = tarDriver;
                    break;
                }
                case TBZ: {
                    driver = tarBZip2Driver;
                    break;
                }
                case TGZ: {
                    driver = tarGZipDriver;
                    break;
                }
                case TXZ: {
                    driver = tarXZDriver;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown driver " + entry.getKey());
                }
            }
            for (FsScheme scheme : schemes) {
                drivers.put(scheme, driver);
            }
        }
        return new TArchiveDetector(() -> drivers, (String)null);
    }

    private static List<FsScheme> toSchemes(String suffixes, Collection<String> badExtensions) {
        ArrayList<FsScheme> schemes = new ArrayList<FsScheme>();
        if (suffixes != null && !suffixes.isEmpty()) {
            String[] tokens = suffixes.trim().split("[, ]+");
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i].startsWith(".")) {
                    tokens[i] = tokens[i].substring(1);
                }
                try {
                    schemes.add(new FsScheme(tokens[i]));
                    continue;
                }
                catch (URISyntaxException e) {
                    if (badExtensions == null) continue;
                    badExtensions.add(tokens[i]);
                }
            }
        }
        return schemes;
    }

    public static String getDriverErrorMessage(FsModel model, IOException exception) {
        return String.format("Error loading file %s. Exception: %s", model.getMountPoint().getPath().getEntryName(), exception.getMessage());
    }

    public static enum Driver {
        ZIP,
        JAR,
        TAR,
        TGZ,
        TBZ,
        TXZ;

    }
}

