/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.NpmManifestFileReader;
import com.sonatype.insight.scan.manifest.NpmDependencies;
import com.sonatype.insight.scan.manifest.NpmDependency;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.de.schlichtherle.truezip.file.TFile;

abstract class AbstractYarnLockFileReader
implements NpmManifestFileReader {
    private static final Logger log = LoggerFactory.getLogger(AbstractYarnLockFileReader.class);

    AbstractYarnLockFileReader() {
    }

    @Override
    public NpmDependencies read(TFile file, FileVisitor fileVisitor) {
        HashMap<String, NpmDependency> npmDependencyByNameSpecifier = new HashMap<String, NpmDependency>();
        HashMap<String, List<String>> directByNameSpecifier = new HashMap<String, List<String>>();
        LinkedHashSet<NpmDependency> dependencies = new LinkedHashSet<NpmDependency>();
        this.parseDependencyData(npmDependencyByNameSpecifier, directByNameSpecifier, dependencies);
        HashMap<String, NpmDependency> processedNpmDependencyByNameSpecifier = new HashMap<String, NpmDependency>();
        for (String nameSpecifier : npmDependencyByNameSpecifier.keySet()) {
            this.process(processedNpmDependencyByNameSpecifier, npmDependencyByNameSpecifier, directByNameSpecifier, nameSpecifier, file);
        }
        return this.createNpmDependenciesFilteredByPackageJson(file, fileVisitor, dependencies);
    }

    abstract void parseDependencyData(Map<String, NpmDependency> var1, Map<String, List<String>> var2, Set<NpmDependency> var3);

    private NpmDependency process(Map<String, NpmDependency> processedNpmDependencyByNameSpecifier, Map<String, NpmDependency> npmDependencyByNameSpecifier, Map<String, List<String>> directByNameSpecifier, String nameSpecifier, TFile file) {
        NpmDependency dependency = processedNpmDependencyByNameSpecifier.get(nameSpecifier);
        if (dependency != null) {
            return dependency;
        }
        dependency = npmDependencyByNameSpecifier.get(nameSpecifier);
        if (dependency == null) {
            log.debug("no dependency details found for specifier {} in manifest {}", (Object)nameSpecifier, (Object)file);
            return null;
        }
        processedNpmDependencyByNameSpecifier.put(nameSpecifier, dependency);
        List<String> direct = directByNameSpecifier.get(nameSpecifier);
        if (direct != null) {
            for (String directNameSpecifier : direct) {
                NpmDependency child = this.process(processedNpmDependencyByNameSpecifier, npmDependencyByNameSpecifier, directByNameSpecifier, directNameSpecifier, file);
                if (child == null) continue;
                dependency.dependencies.add(child);
            }
        }
        return dependency;
    }
}

