/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.manifest.CargoManifest;
import com.sonatype.insight.scan.manifest.CargoPackage;
import java.util.ListIterator;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;

public class CargoProcessor {
    private final FileVisitor fileVisitor;
    private final Logger log;

    public CargoProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    public String process(TFile cargoFile) {
        this.log.debug("Processing Cargo file: {}", (Object)cargoFile.getAbsolutePath());
        CargoManifest cargoManifest = CargoManifest.fromContents(FileUtils.readLines(cargoFile));
        this.filterSensitiveContent(cargoManifest);
        return cargoManifest.toString();
    }

    private void filterSensitiveContent(CargoManifest cargoManifest) {
        ListIterator<CargoPackage> iterator = cargoManifest.getPackages().listIterator();
        while (iterator.hasNext()) {
            CargoPackage cargoPackage = iterator.next();
            if (this.fileVisitor.includeResourceName(cargoPackage.getName())) continue;
            this.log.debug("Excluding Cargo Package '{}'.", (Object)cargoPackage);
            iterator.remove();
        }
    }
}

