/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.manifest.CocoaPodsDependency;
import com.sonatype.insight.scan.manifest.CocoaPodsSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;

public class CocoaPodsProcessor {
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("^[-]\\s(.*)");
    private static final String PODS_SECTION_HEADER = "PODS:";
    private final Logger log;
    private final FileVisitor fileVisitor;

    public CocoaPodsProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    public String process(TFile file) {
        this.log.debug("Processing cocoapods file: {}", (Object)file.getAbsolutePath());
        List<String> lines = FileUtils.readLines(file);
        List<String> dependencies = this.filterSections(lines);
        CocoaPodsSection podsSection = new CocoaPodsSection(dependencies);
        this.filterSensitiveContent(podsSection.getDependencies());
        return this.toString(podsSection);
    }

    private void filterSensitiveContent(Collection<CocoaPodsDependency> dependencies) {
        Iterator<CocoaPodsDependency> it = dependencies.iterator();
        while (it.hasNext()) {
            CocoaPodsDependency dependency = it.next();
            if (this.fileVisitor.includeResourceName(dependency.getName())) continue;
            this.log.debug("Not including cocoapods dependency '{}'.", (Object)dependency);
            it.remove();
        }
    }

    private List<String> filterSections(List<String> lines) {
        ArrayList<String> sectionLines = new ArrayList<String>();
        ListIterator<String> iterator = lines.listIterator();
        while (iterator.hasNext()) {
            String line = iterator.next().trim();
            if (!line.equals(PODS_SECTION_HEADER)) continue;
            this.filterDependenciesForSection(iterator, sectionLines);
        }
        return sectionLines;
    }

    private void filterDependenciesForSection(ListIterator<String> iterator, List<String> lines) {
        String line;
        Matcher matcher;
        while (iterator.hasNext() && (matcher = DEPENDENCY_PATTERN.matcher((line = iterator.next()).trim())).find()) {
            lines.add(line);
        }
    }

    private String toString(CocoaPodsSection podsSection) {
        StringBuilder sb = new StringBuilder();
        sb.append(podsSection.getHeader());
        sb.append("\n");
        if (!podsSection.getDependencies().isEmpty()) {
            for (CocoaPodsDependency dependency : podsSection.getDependencies()) {
                sb.append(dependency.toString()).append("\n");
            }
        }
        return sb.toString();
    }
}

