/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash;

import java.util.HashMap;
import java.util.Map;

public enum HashType {
    CONTENT("SHA1"),
    BYTECODE("JA001"),
    SIGNATURE("JB001"),
    NOPKG_BYTECODE("JC001"),
    NOPKG_SIGNATURE("JD001"),
    MEMBER("K****", true),
    TYPE("KA001", MEMBER),
    FIELD("KB001", MEMBER),
    METHOD_SIGNATURE("KC001", MEMBER),
    METHOD("KD001", MEMBER),
    NOPKG_MEMBER("L****", true),
    NOPKG_TYPE("LA001", NOPKG_MEMBER),
    NOPKG_FIELD("LB001", NOPKG_MEMBER),
    NOPKG_METHOD_SIGNATURE("LC001", NOPKG_MEMBER),
    NOPKG_METHOD("LD001", NOPKG_MEMBER);

    private final String id;
    private final HashType parentType;
    private final boolean isMultiHash;
    private final boolean isJavaMemberHash;
    private static final Map<String, HashType> TYPES_BY_ID;

    private HashType(String id) {
        this(id, false, false, null);
    }

    private HashType(String id, boolean isMultiHash) {
        this(id, isMultiHash, true, null);
    }

    private HashType(String id, HashType parentType) {
        this(id, false, parentType.isJavaMemberHash, parentType);
    }

    private HashType(String id, boolean isMultiHash, boolean isJavaMemberHash, HashType parentType) {
        this.id = id;
        this.isMultiHash = isMultiHash;
        this.parentType = parentType;
        this.isJavaMemberHash = isJavaMemberHash;
    }

    public String getId() {
        return this.id;
    }

    public static HashType fromId(String id) {
        HashType type = TYPES_BY_ID.get(id);
        if (type == null) {
            throw new IllegalArgumentException("unknown id " + id);
        }
        return type;
    }

    public HashType getParentType() {
        return this.parentType;
    }

    public boolean isMultiHash() {
        return this.isMultiHash;
    }

    public boolean isJavaMemberHash() {
        return this.isJavaMemberHash;
    }

    static {
        TYPES_BY_ID = new HashMap<String, HashType>(32);
        for (HashType type : HashType.values()) {
            if (TYPES_BY_ID.put(type.id, type) == null) continue;
            throw new IllegalStateException("ambiguous hash type " + (Object)((Object)type));
        }
    }
}

