/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash;

import com.sonatype.insight.scan.hash.AbstractSHA1;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA1
extends AbstractSHA1
implements Serializable,
Comparable<SHA1> {
    private static final long serialVersionUID = -1078726529010882761L;

    public SHA1(byte[] bytes) {
        super(bytes);
    }

    public SHA1(byte[] bytes, int offset) {
        super(bytes, offset);
    }

    public SHA1(int w1, int w2, short w3) {
        super(w1, w2, w3);
    }

    public SHA1(AbstractSHA1 other) {
        super(other);
    }

    public SHA1(String hex) {
        this(SHA1.toByteArray(hex));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SHA1)) {
            return false;
        }
        return SHA1.equalsSHA1(this, (AbstractSHA1)obj);
    }

    @Override
    public int compareTo(SHA1 o) {
        return super.compareTo(o);
    }

    public static SHA1 fromHexString(String s) {
        return new SHA1(SHA1.toByteArray(s), 0);
    }

    public static SHA1 fromString(String string) {
        return SHA1.fromBytes(string.getBytes(StandardCharsets.UTF_8));
    }

    public static SHA1 fromBytes(byte[] bytes) {
        return new SHA1(SHA1.getSHA1().digest(bytes));
    }

    public static SHA1 fromStream(InputStream stream) throws IOException {
        int n;
        MessageDigest sha1 = SHA1.getSHA1();
        byte[] buffer = new byte[32768];
        while ((n = stream.read(buffer)) >= 0) {
            sha1.update(buffer, 0, n);
        }
        return new SHA1(sha1.digest());
    }

    public static SHA1 fromFile(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            SHA1 sHA1 = SHA1.fromStream(is);
            return sHA1;
        }
    }

    private static MessageDigest getSHA1() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

