/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import com.sonatype.insight.scan.manifest.AlpineDependency;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class AlpineFile {
    private final Set<AlpineDependency> dependencies = new LinkedHashSet<AlpineDependency>();

    public AlpineFile(List<String> contents) {
        this.filterDependencies(contents);
    }

    public static AlpineFile fromContents(List<String> contents) {
        return new AlpineFile(contents);
    }

    private void filterDependencies(List<String> contents) {
        ListIterator<String> iterator = contents.listIterator();
        while (iterator.hasNext()) {
            String line = iterator.next().trim();
            if (line.isEmpty()) {
                iterator.remove();
                continue;
            }
            AlpineDependency dependency = AlpineDependency.fromContent(line);
            if (dependency == null) {
                iterator.remove();
                continue;
            }
            this.dependencies.add(dependency);
        }
    }

    public Set<AlpineDependency> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<AlpineDependency> it = this.dependencies.iterator();
        while (it.hasNext()) {
            AlpineDependency dependency = it.next();
            sb.append(dependency.getName()).append("-").append(dependency.getVersion());
            if (!it.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

