/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import com.sonatype.insight.scan.manifest.CocoaPodsDependency;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CocoaPodsSection {
    public static final String PODS_SECTION_HEADER = "PODS:";
    private final String header;
    private final Set<CocoaPodsDependency> dependencies = new LinkedHashSet<CocoaPodsDependency>();

    public CocoaPodsSection(List<String> dependencies) {
        this.header = PODS_SECTION_HEADER;
        this.addDependencies(dependencies);
    }

    private void addDependencies(List<String> dependencyLines) {
        for (String line : dependencyLines) {
            CocoaPodsDependency dependency = CocoaPodsDependency.fromString(line);
            if (dependency == null) continue;
            this.dependencies.add(dependency);
        }
    }

    public String getHeader() {
        return this.header;
    }

    public Set<CocoaPodsDependency> getDependencies() {
        return this.dependencies;
    }
}

