/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConanDependency {
    public final String name;
    public final String version;
    public final String owner;
    public final String channel;
    private static final Pattern VALIDATION_PATTERN = Pattern.compile("[a-zA-Z0-9_][a-zA-Z0-9_+.-]{1,50}");
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("^(?<name>" + VALIDATION_PATTERN.pattern() + ")\\s*/\\s*(?<version>" + VALIDATION_PATTERN.pattern() + ")(\\s*@\\s*(?<owner>[^/\\s]+)\\s*/\\s*(?<channel>[^#:\\s]+))?(\\s*#\\s*(?<rrev>\\w+))?(\\s*:\\s*(?<packageId>\\w+))?(\\s*#\\s*(?<prev>\\w+))?$");

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConanDependency that = (ConanDependency)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.owner, that.owner) && Objects.equals(this.channel, that.channel);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.owner, this.channel);
    }

    public static ConanDependency fromDependencyData(String name, String version, String owner, String channel) {
        return new ConanDependency(name, version, owner, channel);
    }

    ConanDependency(String name, String version, String owner, String channel) {
        this.name = name;
        this.version = version;
        this.owner = owner;
        this.channel = channel;
    }

    public String getConanDependencyString() {
        StringBuilder builder = new StringBuilder(this.name);
        if (this.version != null) {
            builder.append("/").append(this.version);
        }
        if (this.owner != null) {
            builder.append("@").append(this.owner);
            if (this.channel != null) {
                builder.append("/").append(this.channel);
            }
        }
        return builder.toString();
    }

    public static ConanDependency fromString(String line) {
        Matcher matcher = DEPENDENCY_PATTERN.matcher(line.trim());
        if (matcher.find()) {
            String name = matcher.group("name");
            String version = matcher.group("version");
            String owner = matcher.group("owner");
            String channel = matcher.group("channel");
            if (version != null) {
                version = version.split("\\+")[0];
            }
            if (name != null && version != null) {
                return new ConanDependency(name, version, owner, channel);
            }
        }
        return null;
    }
}

