/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.tools.manifests.gradle.parser;

import com.sonatype.insight.scan.tools.manifests.gradle.model.BuildModel;
import com.sonatype.insight.scan.tools.manifests.gradle.parser.GroovyBuildFileReader;
import com.sonatype.insight.scan.tools.manifests.gradle.parser.PropertiesFileReader;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyBuildFileParser {
    private static final Logger log = LoggerFactory.getLogger(GroovyBuildFileParser.class);

    public BuildModel convertToModel(Path buildFile) {
        BuildModel model = null;
        try {
            model = buildFile.toString().endsWith(".properties") ? new PropertiesFileReader().read(buildFile) : new GroovyBuildFileReader().read(buildFile);
        }
        catch (NoSuchFileException e) {
            log.error("Path not found: {}", (Object)buildFile, (Object)e);
        }
        catch (Exception e) {
            log.error("Given path could not be read as Gradle model: {}", (Object)buildFile, (Object)e);
        }
        return model;
    }

    public List<BuildModel> convertToModels(Collection<Path> buildFiles) {
        return buildFiles.stream().map(this::convertToModel).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

