/*
 * Decompiled with CFR 0.152.
 */
package zz.com.ethlo.time.internal;

import java.time.DateTimeException;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.util.Arrays;
import zz.com.ethlo.time.DateTime;
import zz.com.ethlo.time.Field;
import zz.com.ethlo.time.LeapSecondException;
import zz.com.ethlo.time.TimezoneOffset;
import zz.com.ethlo.time.internal.AbstractRfc3339;
import zz.com.ethlo.time.internal.DefaultLeapSecondHandler;
import zz.com.ethlo.time.internal.LeapSecondHandler;
import zz.com.ethlo.time.internal.LimitedCharArrayIntegerUtil;
import zz.com.ethlo.time.internal.W3cDateTimeUtil;

public class EthloITU
extends AbstractRfc3339
implements W3cDateTimeUtil {
    public static final char DATE_SEPARATOR = '-';
    public static final char TIME_SEPARATOR = ':';
    public static final char SEPARATOR_UPPER = 'T';
    private static final EthloITU instance = new EthloITU();
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final char SEPARATOR_LOWER = 't';
    private static final char SEPARATOR_SPACE = ' ';
    private static final char FRACTION_SEPARATOR = '.';
    private static final char ZULU_UPPER = 'Z';
    private static final char ZULU_LOWER = 'z';
    private static final int[] widths = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private final LeapSecondHandler leapSecondHandler = new DefaultLeapSecondHandler();

    private EthloITU() {
    }

    public static EthloITU getInstance() {
        return instance;
    }

    public static String finish(char[] buf, int length, TimezoneOffset tz) {
        int tzLen = 0;
        if (tz != null) {
            tzLen = EthloITU.writeTz(buf, length, tz);
        }
        return new String(buf, 0, length + tzLen);
    }

    private static int writeTz(char[] buf, int start, TimezoneOffset tz) {
        if (tz.equals(TimezoneOffset.UTC)) {
            buf[start] = 90;
            return 1;
        }
        buf[start] = tz.getTotalSeconds() < 0 ? 45 : 43;
        LimitedCharArrayIntegerUtil.toString(Math.abs(tz.getHours()), buf, start + 1, 2);
        buf[start + 3] = 58;
        LimitedCharArrayIntegerUtil.toString(Math.abs(tz.getMinutes()), buf, start + 4, 2);
        return 6;
    }

    private int getHour(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 11, 13);
    }

    private int getMinute(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 14, 16);
    }

    private int getDay(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 8, 10);
    }

    private DateTime handleTime(char[] chars, int year, int month, int day, int hour, int minute) {
        switch (chars[16]) {
            case ':': {
                return this.handleSeconds(year, month, day, hour, minute, chars);
            }
            case '+': 
            case '-': 
            case 'Z': 
            case 'z': {
                TimezoneOffset zoneOffset = this.parseTimezone(chars, 16);
                return DateTime.of(year, month, day, hour, minute, zoneOffset);
            }
        }
        this.assertPositionContains(chars, 16, ':', '+', '-', 'Z');
        throw new DateTimeException(new String(chars));
    }

    private void assertPositionContains(char[] chars, int offset, char expected) {
        if (offset >= chars.length) {
            this.raiseDateTimeException(chars, "Unexpected end of input");
        }
        if (chars[offset] != expected) {
            throw new DateTimeException("Expected character " + expected + " at position " + (offset + 1) + " '" + new String(chars) + "'");
        }
    }

    private void assertPositionContains(char[] chars, int offset, char ... expected) {
        if (offset >= chars.length) {
            this.raiseDateTimeException(chars, "Unexpected end of input");
        }
        boolean found = false;
        for (char e : expected) {
            if (chars[offset] != e) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new DateTimeException("Expected character " + Arrays.toString(expected) + " at position " + (offset + 1) + " '" + new String(chars) + "'");
        }
    }

    private TimezoneOffset parseTimezone(char[] chars, int offset) {
        int len = chars.length;
        int left = len - offset;
        char c = chars[offset];
        if (c == 'Z' || c == 'z') {
            this.assertNoMoreChars(chars, offset);
            return TimezoneOffset.UTC;
        }
        if (left != 6) {
            throw new DateTimeException("Invalid timezone offset: " + new String(chars, offset, left));
        }
        char sign = chars[offset];
        int hours = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 1, offset + 3);
        int minutes = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 4, offset + 4 + 2);
        if (sign == '-') {
            hours = -hours;
            minutes = -minutes;
        } else if (sign != '+') {
            throw new DateTimeException("Invalid character starting at position " + offset + 1);
        }
        if (sign == '-' && hours == 0 && minutes == 0) {
            throw new DateTimeException("Unknown 'Local Offset Convention' date-time not allowed");
        }
        return TimezoneOffset.ofHoursMinutes(hours, minutes);
    }

    private void assertNoMoreChars(char[] chars, int lastUsed) {
        if (chars.length > lastUsed + 1) {
            throw new DateTimeException("Trailing junk data after position " + (lastUsed + 1) + ": " + new String(chars));
        }
    }

    @Override
    public String formatUtc(OffsetDateTime date, int fractionDigits) {
        return this.doFormat(date, ZoneOffset.UTC, Field.SECOND, fractionDigits);
    }

    @Override
    public String formatUtc(OffsetDateTime date, Field lastIncluded) {
        return this.doFormat(date, ZoneOffset.UTC, lastIncluded, 0);
    }

    @Override
    public String format(OffsetDateTime date, ZoneOffset adjustTo, int fractionDigits) {
        return this.doFormat(date, adjustTo, Field.NANO, fractionDigits);
    }

    private String doFormat(OffsetDateTime date, ZoneOffset adjustTo, Field lastIncluded, int fractionDigits) {
        boolean hasFractionDigits;
        this.assertMaxFractionDigits(fractionDigits);
        OffsetDateTime adjusted = date;
        if (!date.getOffset().equals(adjustTo)) {
            adjusted = date.atZoneSameInstant(adjustTo).toOffsetDateTime();
        }
        TimezoneOffset tz = TimezoneOffset.of(adjustTo);
        char[] buffer = new char[31];
        if (this.handleDatePart(lastIncluded, buffer, adjusted.getYear(), 0, 4, Field.YEAR)) {
            return EthloITU.finish(buffer, Field.YEAR.getRequiredLength(), null);
        }
        buffer[4] = 45;
        if (this.handleDatePart(lastIncluded, buffer, adjusted.getMonthValue(), 5, 2, Field.MONTH)) {
            return EthloITU.finish(buffer, Field.MONTH.getRequiredLength(), null);
        }
        buffer[7] = 45;
        if (this.handleDatePart(lastIncluded, buffer, adjusted.getDayOfMonth(), 8, 2, Field.DAY)) {
            return EthloITU.finish(buffer, Field.DAY.getRequiredLength(), null);
        }
        buffer[10] = 84;
        LimitedCharArrayIntegerUtil.toString(adjusted.getHour(), buffer, 11, 2);
        buffer[13] = 58;
        if (this.handleDatePart(lastIncluded, buffer, adjusted.getMinute(), 14, 2, Field.MINUTE)) {
            return EthloITU.finish(buffer, Field.MINUTE.getRequiredLength(), tz);
        }
        buffer[16] = 58;
        LimitedCharArrayIntegerUtil.toString(adjusted.getSecond(), buffer, 17, 2);
        boolean bl = hasFractionDigits = fractionDigits > 0;
        if (hasFractionDigits) {
            buffer[19] = 46;
            this.addFractions(buffer, fractionDigits, adjusted.getNano());
            return EthloITU.finish(buffer, 20 + fractionDigits, tz);
        }
        return EthloITU.finish(buffer, 19, tz);
    }

    private boolean handleDatePart(Field lastIncluded, char[] buffer, int value, int offset, int length, Field field) {
        LimitedCharArrayIntegerUtil.toString(value, buffer, offset, length);
        return lastIncluded == field;
    }

    private void addFractions(char[] buf, int fractionDigits, int nano) {
        double d = widths[fractionDigits - 1];
        LimitedCharArrayIntegerUtil.toString((int)((double)nano / d), buf, 20, fractionDigits);
    }

    @Override
    public OffsetDateTime parseDateTime(String dateTime) {
        return this.assertSecondsGranularity(this.parse(dateTime)).toOffsetDatetime();
    }

    private DateTime assertSecondsGranularity(DateTime dt) {
        if (!dt.includesGranularity(Field.SECOND)) {
            throw new DateTimeException("No " + Field.SECOND.name() + " field found");
        }
        return dt;
    }

    @Override
    public String formatUtcMilli(OffsetDateTime date) {
        return this.formatUtc(date, 3);
    }

    @Override
    public String formatUtcMicro(OffsetDateTime date) {
        return this.formatUtc(date, 6);
    }

    @Override
    public String formatUtcNano(OffsetDateTime date) {
        return this.formatUtc(date, 9);
    }

    @Override
    public String formatUtc(OffsetDateTime date) {
        return this.formatUtc(date, 0);
    }

    @Override
    public DateTime parse(String text) {
        if (text == null) {
            throw new NullPointerException("text cannot be null");
        }
        int len = text.length();
        char[] chars = text.toCharArray();
        int years = this.getYear(chars);
        if (4 == len) {
            return DateTime.ofYear(years);
        }
        this.assertPositionContains(chars, 4, '-');
        int months = this.getMonth(chars);
        if (7 == len) {
            return DateTime.ofYearMonth(years, months);
        }
        this.assertPositionContains(chars, 7, '-');
        int days = this.getDay(chars);
        if (10 == len) {
            return DateTime.ofDate(years, months, days);
        }
        this.assertPositionContains(chars, 10, 'T', 't', ' ');
        int hours = this.getHour(chars);
        this.assertPositionContains(chars, 13, ':');
        int minutes = this.getMinute(chars);
        if (16 == len) {
            return DateTime.of(years, months, days, hours, minutes, null);
        }
        return this.handleTime(chars, years, months, days, hours, minutes);
    }

    private int getMonth(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 5, 7);
    }

    private int getYear(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 0, 4);
    }

    private DateTime handleSeconds(int year, int month, int day, int hour, int minute, char[] chars) {
        int remaining = chars.length - 19;
        if (remaining == 0) {
            int seconds = this.getSeconds(chars);
            return this.leapSecondCheck(year, month, day, hour, minute, seconds, 0, null, 0);
        }
        TimezoneOffset offset = null;
        int fractions = 0;
        int fractionDigits = 0;
        char c = chars[19];
        if (remaining == 1 && (c == 'Z' || c == 'z')) {
            offset = TimezoneOffset.UTC;
            this.assertNoMoreChars(chars, 19);
        } else if (remaining >= 1 && c == '.') {
            int idx = LimitedCharArrayIntegerUtil.indexOfNonDigit(chars, 20);
            if (idx != -1) {
                int len = idx - 20;
                fractions = this.getFractions(chars, idx, len);
                fractionDigits = len;
                offset = this.parseTimezone(chars, idx);
            } else {
                this.raiseDateTimeException(chars, "No timezone information");
            }
        } else if (remaining >= 1 && (c == '+' || c == '-')) {
            offset = this.parseTimezone(chars, 19);
        } else {
            this.raiseDateTimeException(chars, "Unexpected character at position 19");
        }
        return this.leapSecondCheck(year, month, day, hour, minute, this.getSeconds(chars), fractions, offset, fractionDigits);
    }

    private DateTime leapSecondCheck(int year, int month, int day, int hour, int minute, int second, int nanos, TimezoneOffset offset, int fractionDigits) {
        YearMonth needle;
        boolean isValidLeapYearMonth;
        if (second == 60 && ((isValidLeapYearMonth = this.leapSecondHandler.isValidLeapSecondDate(needle = YearMonth.of(year, month))) || needle.isAfter(this.leapSecondHandler.getLastKnownLeapSecond()))) {
            int utcHour = hour - offset.getTotalSeconds() / 3600;
            int utcMinute = minute - offset.getTotalSeconds() % 3600 / 60;
            if ((month == Month.DECEMBER.getValue() && day == 31 || month == Month.JUNE.getValue() && day == 30) && utcHour == 23 && utcMinute == 59) {
                OffsetDateTime nearest = OffsetDateTime.of(year, month, day, hour, minute, 59, nanos, offset.toZoneOffset()).plusSeconds(1L);
                throw new LeapSecondException(nearest, second, isValidLeapYearMonth);
            }
        }
        return fractionDigits > 0 ? DateTime.of(year, month, day, hour, minute, second, nanos, offset, fractionDigits) : DateTime.of(year, month, day, hour, minute, second, offset);
    }

    private void raiseDateTimeException(char[] chars, String message) {
        throw new DateTimeException(message + ": " + new String(chars));
    }

    private int getSeconds(char[] chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, 17, 19);
    }

    private int getFractions(char[] chars, int idx, int len) {
        int fractions = LimitedCharArrayIntegerUtil.uncheckedParsePositiveInt(chars, 20, idx);
        switch (len) {
            case 1: {
                return fractions * 100000000;
            }
            case 2: {
                return fractions * 10000000;
            }
            case 3: {
                return fractions * 1000000;
            }
            case 4: {
                return fractions * 100000;
            }
            case 5: {
                return fractions * 10000;
            }
            case 6: {
                return fractions * 1000;
            }
            case 7: {
                return fractions * 100;
            }
            case 8: {
                return fractions * 10;
            }
        }
        return fractions;
    }
}

