/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.ethlo.time.ITU;
import zz.com.ethlo.time.LeapSecondException;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonType;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.TypeFactory;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class DateTimeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeValidator.class);
    private static final String DATE = "date";
    private static final String DATETIME = "date-time";
    private final String formatName;

    public DateTimeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, String formatName, ValidatorTypeCode type) {
        super(schemaPath, schemaNode, parentSchema, type, validationContext);
        this.formatName = formatName;
        this.validationContext = validationContext;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        if (nodeType != JsonType.STRING) {
            return errors;
        }
        if (!this.isLegalDateTime(node.textValue())) {
            errors.add(this.buildValidationMessage(at, node.textValue(), this.formatName));
        }
        return Collections.unmodifiableSet(errors);
    }

    private boolean isLegalDateTime(String string) {
        if (this.formatName.equals(DATE)) {
            return this.tryParse(() -> LocalDate.parse(string));
        }
        if (this.formatName.equals(DATETIME)) {
            return this.tryParse(() -> {
                block2: {
                    try {
                        ITU.parseDateTime(string);
                    }
                    catch (LeapSecondException ex) {
                        if (ex.isVerifiedValidLeapYearMonth()) break block2;
                        throw ex;
                    }
                }
            });
        }
        throw new IllegalStateException("Unknown format: " + this.formatName);
    }

    private boolean tryParse(Runnable parser) {
        try {
            parser.run();
            return true;
        }
        catch (Exception ex) {
            logger.error("Invalid {}: {}", (Object)this.formatName, (Object)ex.getMessage());
            return false;
        }
    }
}

