/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class DependentSchemas
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DependentSchemas.class);
    private final Map<String, JsonSchema> schemaDependencies = new HashMap<String, JsonSchema>();

    public DependentSchemas(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.DEPENDENT_SCHEMAS, validationContext);
        Iterator<String> it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            JsonNode pvalue = schemaNode.get(pname);
            if (!pvalue.isObject() && !pvalue.isBoolean()) continue;
            this.schemaDependencies.put(pname, new JsonSchema(validationContext, pname, parentSchema.getCurrentUri(), pvalue, parentSchema));
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        Iterator<String> it = node.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            JsonSchema schema = this.schemaDependencies.get(pname);
            if (schema == null) continue;
            errors.addAll(schema.validate(node, rootNode, at));
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemaDependencies.values());
    }
}

