/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsDecoratingController;
import zz.de.schlichtherle.truezip.fs.FsEntry;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsFalsePositiveArchiveException;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsNeedsLockRetryException;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsPath;
import zz.de.schlichtherle.truezip.fs.FsPersistentFalsePositiveArchiveException;
import zz.de.schlichtherle.truezip.fs.FsSyncException;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.ControlFlowException;
import zz.de.schlichtherle.truezip.util.JSE7;

@ThreadSafe
final class FsFalsePositiveArchiveController
extends FsDecoratingController<FsModel, FsController<?>> {
    private volatile State state = new TryChild();
    @CheckForNull
    private FsController<?> parent;
    @CheckForNull
    private FsPath path;

    FsFalsePositiveArchiveController(FsController<?> controller) {
        super(controller);
        assert (null != super.getParent());
    }

    @Nullable
    <T> T call(Operation<T> operation, FsEntryName name) throws IOException {
        State state = this.state;
        try {
            return state.call(operation, name);
        }
        catch (FsPersistentFalsePositiveArchiveException ex) {
            assert (state instanceof TryChild);
            this.state = new UseParent(ex);
            return this.state.call(operation, name);
        }
        catch (FsFalsePositiveArchiveException ex) {
            assert (state instanceof TryChild);
            return new UseParent(ex).call(operation, name);
        }
    }

    @Override
    public FsController<?> getParent() {
        FsController<?> parent = this.parent;
        return null != parent ? parent : (this.parent = this.delegate.getParent());
    }

    FsEntryName parent(FsEntryName name) {
        return this.getPath().resolve(name).getEntryName();
    }

    private FsPath getPath() {
        FsPath path = this.path;
        return null != path ? path : (this.path = this.getMountPoint().getPath());
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return this.call(new IsReadOnly(), FsEntryName.ROOT);
    }

    @Override
    public FsEntry getEntry(FsEntryName name) throws IOException {
        return this.call(new GetEntry(), name);
    }

    @Override
    public boolean isReadable(FsEntryName name) throws IOException {
        return this.call(new IsReadable(), name);
    }

    @Override
    public boolean isWritable(FsEntryName name) throws IOException {
        return this.call(new IsWritable(), name);
    }

    @Override
    public boolean isExecutable(FsEntryName name) throws IOException {
        return this.call(new IsExecutable(), name);
    }

    @Override
    public void setReadOnly(FsEntryName name) throws IOException {
        this.call(new SetReadOnly(), name);
    }

    @Override
    public boolean setTime(FsEntryName name, final Map<Entry.Access, Long> times, final BitField<FsOutputOption> options) throws IOException {
        final class SetTime
        implements Operation<Boolean> {
            SetTime() {
            }

            @Override
            public Boolean call(FsController<?> controller, FsEntryName name) throws IOException {
                return controller.setTime(name, times, options);
            }
        }
        return this.call(new SetTime(), name);
    }

    @Override
    public boolean setTime(FsEntryName name, final BitField<Entry.Access> types, final long value, final BitField<FsOutputOption> options) throws IOException {
        final class SetTime
        implements Operation<Boolean> {
            SetTime() {
            }

            @Override
            public Boolean call(FsController<?> controller, FsEntryName name) throws IOException {
                return controller.setTime(name, types, value, options);
            }
        }
        return this.call(new SetTime(), name);
    }

    @Override
    public InputSocket<?> getInputSocket(final FsEntryName name, final BitField<FsInputOption> options) {
        @NotThreadSafe
        final class Input
        extends InputSocket<Entry> {
            @CheckForNull
            FsController<?> lastController;
            @Nullable
            InputSocket<? extends Entry> delegate;

            Input() {
            }

            InputSocket<?> getBoundDelegate(FsController<?> controller, FsEntryName name2) {
                InputSocket<Entry> inputSocket;
                if (this.lastController == controller) {
                    inputSocket = this.delegate;
                } else {
                    this.lastController = controller;
                    inputSocket = this.delegate = this.lastController.getInputSocket(name2, options);
                }
                return inputSocket.bind(this);
            }

            @Override
            public Entry getLocalTarget() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Input.GetLocalTarget(), name);
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Input.NewReadOnlyFile(), name);
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Input.NewSeekableByteChannel(), name);
            }

            @Override
            public InputStream newInputStream() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Input.NewInputStream(), name);
            }

            final class 1Input.NewInputStream
            implements Operation<InputStream> {
                1Input.NewInputStream() {
                }

                @Override
                public InputStream call(FsController<?> controller, FsEntryName name) throws IOException {
                    return this.getBoundDelegate(controller, name).newInputStream();
                }
            }

            final class 1Input.NewSeekableByteChannel
            implements Operation<SeekableByteChannel> {
                1Input.NewSeekableByteChannel() {
                }

                @Override
                public SeekableByteChannel call(FsController<?> controller, FsEntryName name) throws IOException {
                    return this.getBoundDelegate(controller, name).newSeekableByteChannel();
                }
            }

            final class 1Input.NewReadOnlyFile
            implements Operation<ReadOnlyFile> {
                1Input.NewReadOnlyFile() {
                }

                @Override
                public ReadOnlyFile call(FsController<?> controller, FsEntryName name) throws IOException {
                    return this.getBoundDelegate(controller, name).newReadOnlyFile();
                }
            }

            final class 1Input.GetLocalTarget
            implements Operation<Entry> {
                1Input.GetLocalTarget() {
                }

                @Override
                public Entry call(FsController<?> controller, FsEntryName name) throws IOException {
                    return (Entry)this.getBoundDelegate(controller, name).getLocalTarget();
                }
            }
        }
        return new Input();
    }

    @Override
    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public OutputSocket<?> getOutputSocket(final FsEntryName name, final BitField<FsOutputOption> options, final @CheckForNull Entry template) {
        @NotThreadSafe
        final class Output
        extends OutputSocket<Entry> {
            @CheckForNull
            FsController<?> lastController;
            @Nullable
            OutputSocket<? extends Entry> delegate;

            Output() {
            }

            OutputSocket<?> getBoundDelegate(FsController<?> controller, FsEntryName name2) {
                OutputSocket<Entry> outputSocket;
                if (this.lastController == controller) {
                    outputSocket = this.delegate;
                } else {
                    this.lastController = controller;
                    outputSocket = this.delegate = this.lastController.getOutputSocket(name2, options, template);
                }
                return outputSocket.bind(this);
            }

            @Override
            public Entry getLocalTarget() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Output.GetLocalTarget(), name);
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Output.NewSeekableByteChannel(), name);
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                return FsFalsePositiveArchiveController.this.call(new 1Output.NewOutputStream(), name);
            }

            final class 1Output.NewOutputStream
            implements Operation<OutputStream> {
                1Output.NewOutputStream() {
                }

                @Override
                public OutputStream call(FsController<?> controller, FsEntryName name) throws IOException {
                    return this.getBoundDelegate(controller, name).newOutputStream();
                }
            }

            final class 1Output.NewSeekableByteChannel
            implements Operation<SeekableByteChannel> {
                1Output.NewSeekableByteChannel() {
                }

                @Override
                public SeekableByteChannel call(FsController<?> controller, FsEntryName name) throws IOException {
                    return this.getBoundDelegate(controller, name).newSeekableByteChannel();
                }
            }

            final class 1Output.GetLocalTarget
            implements Operation<Entry> {
                1Output.GetLocalTarget() {
                }

                @Override
                public Entry call(FsController<?> controller, FsEntryName name) throws IOException {
                    return (Entry)this.getBoundDelegate(controller, name).getLocalTarget();
                }
            }
        }
        return new Output();
    }

    @Override
    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public void mknod(FsEntryName name, final Entry.Type type, final BitField<FsOutputOption> options, final @CheckForNull Entry template) throws IOException {
        final class Mknod
        implements Operation<Void> {
            Mknod() {
            }

            @Override
            public Void call(FsController<?> controller, FsEntryName name) throws IOException {
                controller.mknod(name, type, options, template);
                return null;
            }
        }
        this.call(new Mknod(), name);
    }

    @Override
    public void unlink(FsEntryName name, final BitField<FsOutputOption> options) throws IOException {
        final class Unlink
        implements Operation<Void> {
            Unlink() {
            }

            @Override
            public Void call(FsController<?> controller, FsEntryName name) throws IOException {
                controller.unlink(name, options);
                if (name.isRoot()) {
                    assert (controller == FsFalsePositiveArchiveController.this.delegate);
                    FsFalsePositiveArchiveController.this.getParent().unlink(FsFalsePositiveArchiveController.this.parent(name), options);
                }
                return null;
            }
        }
        Unlink operation = new Unlink();
        if (name.isRoot()) {
            TryChild tryChild = new TryChild();
            try {
                tryChild.call(operation, FsEntryName.ROOT);
            }
            catch (FsFalsePositiveArchiveException ex) {
                new UseParent(ex).call(operation, FsEntryName.ROOT);
            }
            this.state = tryChild;
        } else {
            this.call(operation, name);
        }
    }

    @Override
    public void sync(BitField<FsSyncOption> options) throws FsSyncException {
        try {
            this.delegate.sync(options);
        }
        catch (FsSyncException ex) {
            assert (this.state instanceof TryChild);
            throw ex;
        }
        catch (ControlFlowException ex) {
            assert (this.state instanceof TryChild);
            throw ex;
        }
        this.state = new TryChild();
    }

    @Immutable
    private final class UseParent
    implements State {
        final IOException originalCause;

        UseParent(FsFalsePositiveArchiveException ex) {
            this.originalCause = ex.getCause();
        }

        public <V> V call(Operation<V> operation, FsEntryName name) throws IOException {
            try {
                return operation.call(FsFalsePositiveArchiveController.this.getParent(), FsFalsePositiveArchiveController.this.parent(name));
            }
            catch (FsFalsePositiveArchiveException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (ControlFlowException ex) {
                assert (ex instanceof FsNeedsLockRetryException);
                throw ex;
            }
            catch (IOException ex) {
                if (JSE7.AVAILABLE && this.originalCause != ex) {
                    this.originalCause.addSuppressed(ex);
                }
                throw this.originalCause;
            }
        }
    }

    @Immutable
    private final class TryChild
    implements State {
        private TryChild() {
        }

        public <V> V call(Operation<V> operation, FsEntryName name) throws IOException {
            return operation.call(FsFalsePositiveArchiveController.this.delegate, name);
        }
    }

    private static interface State {
        @Nullable
        public <T> T call(Operation<T> var1, FsEntryName var2) throws IOException;
    }

    private static interface Operation<V> {
        @Nullable
        public V call(FsController<?> var1, FsEntryName var2) throws IOException;
    }

    private static final class SetReadOnly
    implements Operation<Void> {
        private SetReadOnly() {
        }

        @Override
        public Void call(FsController<?> controller, FsEntryName name) throws IOException {
            controller.setReadOnly(name);
            return null;
        }
    }

    private static final class IsExecutable
    implements Operation<Boolean> {
        private IsExecutable() {
        }

        @Override
        public Boolean call(FsController<?> controller, FsEntryName name) throws IOException {
            return controller.isExecutable(name);
        }
    }

    private static final class IsWritable
    implements Operation<Boolean> {
        private IsWritable() {
        }

        @Override
        public Boolean call(FsController<?> controller, FsEntryName name) throws IOException {
            return controller.isWritable(name);
        }
    }

    private static final class IsReadable
    implements Operation<Boolean> {
        private IsReadable() {
        }

        @Override
        public Boolean call(FsController<?> controller, FsEntryName name) throws IOException {
            return controller.isReadable(name);
        }
    }

    private static final class GetEntry
    implements Operation<FsEntry> {
        private GetEntry() {
        }

        @Override
        public FsEntry call(FsController<?> controller, FsEntryName name) throws IOException {
            return controller.getEntry(name);
        }
    }

    private static final class IsReadOnly
    implements Operation<Boolean> {
        private IsReadOnly() {
        }

        @Override
        public Boolean call(FsController<?> controller, FsEntryName name) throws IOException {
            return controller.isReadOnly();
        }
    }
}

