/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.util.ExceptionHandler;
import zz.de.schlichtherle.truezip.util.HashMaps;

@ThreadSafe
final class FsResourceAccountant {
    private static final ConcurrentMap<Closeable, Account> accounts;
    private final Lock lock;
    private final Condition condition;

    FsResourceAccountant(Lock lock) {
        this.lock = lock;
        this.condition = this.lock.newCondition();
    }

    void startAccountingFor(@WillCloseWhenClosed Closeable resource) {
        accounts.put(resource, new Account());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopAccountingFor(@WillNotClose Closeable resource) {
        if (null != accounts.remove(resource)) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitClosingOfOtherThreadsResources(long timeout) {
        this.lock.lock();
        try {
            try {
                if (0L < timeout) {
                    long toWait = TimeUnit.MILLISECONDS.toNanos(timeout);
                    while (0L < toWait && this.resources().needsWaiting()) {
                        toWait = this.condition.awaitNanos(toWait);
                    }
                } else {
                    while (this.resources().needsWaiting()) {
                        this.condition.await();
                    }
                }
            }
            catch (InterruptedException cancel) {
                if (0 == this.resources().total) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    Resources resources() {
        Thread currentThread = Thread.currentThread();
        int local = 0;
        int total = 0;
        for (Account account : accounts.values()) {
            if (account.getAccountant() != this) continue;
            if (account.owner == currentThread) {
                ++local;
            }
            ++total;
        }
        return new Resources(local, total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <X extends Exception> void closeAllResources(ExceptionHandler<? super IOException, X> handler) throws X {
        assert (null != handler);
        this.lock.lock();
        try {
            Iterator i = accounts.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Account account = (Account)entry.getValue();
                if (account.getAccountant() != this) continue;
                i.remove();
                Closeable closeable = (Closeable)entry.getKey();
                try {
                    closeable.close();
                }
                catch (IOException ex) {
                    handler.warn(ex);
                }
            }
        }
        finally {
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    static {
        int threads = Runtime.getRuntime().availableProcessors() * 10;
        int initialCapacity = HashMaps.initialCapacity(threads);
        accounts = new ConcurrentHashMap<Closeable, Account>(initialCapacity, 0.75f, threads);
    }

    @Immutable
    static final class Resources {
        final int local;
        final int total;

        private Resources(int local, int total) {
            this.local = local;
            this.total = total;
        }

        boolean needsWaiting() {
            return this.local < this.total;
        }
    }

    private final class Account {
        final Thread owner = Thread.currentThread();

        private Account() {
        }

        FsResourceAccountant getAccountant() {
            return FsResourceAccountant.this;
        }
    }
}

