/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsLockModel;
import zz.de.schlichtherle.truezip.fs.FsLockModelDecoratingController;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsNeedsSyncException;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsResourceAccountant;
import zz.de.schlichtherle.truezip.fs.FsResourceOpenException;
import zz.de.schlichtherle.truezip.fs.FsSyncException;
import zz.de.schlichtherle.truezip.fs.FsSyncExceptionBuilder;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.fs.FsSyncWarningException;
import zz.de.schlichtherle.truezip.io.DecoratingInputStream;
import zz.de.schlichtherle.truezip.io.DecoratingOutputStream;
import zz.de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import zz.de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.de.schlichtherle.truezip.socket.DecoratingInputSocket;
import zz.de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.ControlFlowException;
import zz.de.schlichtherle.truezip.util.ExceptionHandler;
import zz.de.schlichtherle.truezip.util.JSE7;

@NotThreadSafe
final class FsResourceController
extends FsLockModelDecoratingController<FsController<? extends FsLockModel>> {
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private final FsResourceAccountant accountant = new FsResourceAccountant(this.writeLock());

    FsResourceController(FsController<? extends FsLockModel> controller) {
        super(controller);
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return SOCKET_FACTORY.newInputSocket(this, name, options);
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return SOCKET_FACTORY.newOutputSocket(this, name, options, template);
    }

    @Override
    public void sync(BitField<FsSyncOption> options) throws FsSyncException {
        assert (this.isWriteLockedByCurrentThread());
        assert (!this.isReadLockedByCurrentThread());
        FsResourceAccountant.Resources beforeWait = this.accountant.resources();
        if (0 == beforeWait.total) {
            this.delegate.sync(options);
            return;
        }
        FsSyncExceptionBuilder builder = new FsSyncExceptionBuilder();
        boolean forceCloseIo = FsResourceController.forceCloseIo(options);
        try {
            if (0 != beforeWait.local && !forceCloseIo) {
                throw new FsResourceOpenException(beforeWait.total, beforeWait.local);
            }
            this.accountant.awaitClosingOfOtherThreadsResources(FsResourceController.waitCloseIo(options) ? 0L : 100L);
            FsResourceAccountant.Resources afterWait = this.accountant.resources();
            if (0 != afterWait.total) {
                throw new FsResourceOpenException(afterWait.total, afterWait.local);
            }
        }
        catch (FsResourceOpenException ex) {
            if (!forceCloseIo) {
                throw (FsSyncException)builder.fail(new FsSyncException((FsModel)this.getModel(), ex));
            }
            builder.warn(new FsSyncWarningException((FsModel)this.getModel(), ex));
        }
        this.closeResources(builder);
        if (beforeWait.needsWaiting()) {
            builder.check();
            throw FsNeedsSyncException.get();
        }
        try {
            this.delegate.sync(options);
        }
        catch (FsSyncException ex) {
            throw (FsSyncException)builder.fail(ex);
        }
        builder.check();
    }

    private static boolean waitCloseIo(BitField<FsSyncOption> options) {
        return options.get(FsSyncOption.WAIT_CLOSE_INPUT) || options.get(FsSyncOption.WAIT_CLOSE_OUTPUT);
    }

    private static boolean forceCloseIo(BitField<FsSyncOption> options) {
        return options.get(FsSyncOption.FORCE_CLOSE_INPUT) || options.get(FsSyncOption.FORCE_CLOSE_OUTPUT);
    }

    private void closeResources(final FsSyncExceptionBuilder builder) {
        final class IOExceptionHandler
        implements ExceptionHandler<IOException, RuntimeException> {
            IOExceptionHandler() {
            }

            @Override
            public RuntimeException fail(IOException ex) {
                throw new AssertionError((Object)ex);
            }

            @Override
            public void warn(IOException ex) {
                builder.warn(new FsSyncWarningException((FsModel)FsResourceController.this.getModel(), ex));
            }
        }
        this.accountant.closeAllResources(new IOExceptionHandler());
    }

    private void close(Closeable delegate, Closeable thiz) throws IOException {
        boolean cfe = false;
        try {
            delegate.close();
        }
        catch (ControlFlowException ex) {
            cfe = true;
            throw ex;
        }
        finally {
            if (!cfe) {
                this.accountant.stopAccountingFor(thiz);
            }
        }
    }

    private final class ResourceOutputStream
    extends DecoratingOutputStream {
        @CreatesObligation
        ResourceOutputStream(OutputStream out) {
            super(out);
            FsResourceController.this.accountant.startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            FsResourceController.this.close(this.delegate, this);
        }
    }

    private final class ResourceInputStream
    extends DecoratingInputStream {
        @CreatesObligation
        ResourceInputStream(InputStream in) {
            super(in);
            FsResourceController.this.accountant.startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            FsResourceController.this.close(this.delegate, this);
        }
    }

    private final class ResourceSeekableByteChannel
    extends DecoratingSeekableByteChannel {
        @CreatesObligation
        ResourceSeekableByteChannel(SeekableByteChannel sbc) {
            super(sbc);
            FsResourceController.this.accountant.startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            FsResourceController.this.close(this.delegate, this);
        }
    }

    private final class ResourceReadOnlyFile
    extends DecoratingReadOnlyFile {
        @CreatesObligation
        ResourceReadOnlyFile(ReadOnlyFile rof) {
            super(rof);
            FsResourceController.this.accountant.startAccountingFor(this);
        }

        @Override
        public void close() throws IOException {
            FsResourceController.this.close(this.delegate, this);
        }
    }

    @Immutable
    private class Output
    extends DecoratingOutputSocket<Entry> {
        Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(FsResourceController.this.delegate.getOutputSocket(name, options, template));
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            return new ResourceOutputStream(this.getBoundSocket().newOutputStream());
        }
    }

    @Immutable
    private final class Nio2Output
    extends Output {
        Nio2Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(name, options, template);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return new ResourceSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    @Immutable
    private class Input
    extends DecoratingInputSocket<Entry> {
        Input(FsEntryName name, BitField<FsInputOption> options) {
            super(FsResourceController.this.delegate.getInputSocket(name, options));
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            return new ResourceReadOnlyFile(this.getBoundSocket().newReadOnlyFile());
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return new ResourceInputStream(this.getBoundSocket().newInputStream());
        }
    }

    @Immutable
    private final class Nio2Input
    extends Input {
        Nio2Input(FsEntryName name, BitField<FsInputOption> options) {
            super(name, options);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return new ResourceSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            InputSocket<?> newInputSocket(FsResourceController controller, FsEntryName name, BitField<FsInputOption> options) {
                FsResourceController fsResourceController = controller;
                fsResourceController.getClass();
                return fsResourceController.new Nio2Input(name, options);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsResourceController controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
                FsResourceController fsResourceController = controller;
                fsResourceController.getClass();
                return fsResourceController.new Nio2Output(name, options, template);
            }
        }
        ,
        OIO{

            @Override
            InputSocket<?> newInputSocket(FsResourceController controller, FsEntryName name, BitField<FsInputOption> options) {
                FsResourceController fsResourceController = controller;
                fsResourceController.getClass();
                return fsResourceController.new Input(name, options);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsResourceController controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
                FsResourceController fsResourceController = controller;
                fsResourceController.getClass();
                return fsResourceController.new Output(name, options, template);
            }
        };


        abstract InputSocket<?> newInputSocket(FsResourceController var1, FsEntryName var2, BitField<FsInputOption> var3);

        abstract OutputSocket<?> newOutputSocket(FsResourceController var1, FsEntryName var2, BitField<FsOutputOption> var3, @CheckForNull Entry var4);
    }
}

