/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsArchiveDriver;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntry;
import zz.de.schlichtherle.truezip.fs.FsArchiveFileSystem;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsCovariantEntry;
import zz.de.schlichtherle.truezip.fs.FsEntry;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsEntryNotFoundException;
import zz.de.schlichtherle.truezip.fs.FsFalsePositiveArchiveException;
import zz.de.schlichtherle.truezip.fs.FsFileSystemArchiveController;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsLockModel;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsNeedsLockRetryException;
import zz.de.schlichtherle.truezip.fs.FsNeedsSyncException;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsOutputOptions;
import zz.de.schlichtherle.truezip.fs.FsPersistentFalsePositiveArchiveException;
import zz.de.schlichtherle.truezip.fs.FsSyncException;
import zz.de.schlichtherle.truezip.fs.FsSyncExceptionBuilder;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.fs.FsSyncWarningException;
import zz.de.schlichtherle.truezip.io.InputClosedException;
import zz.de.schlichtherle.truezip.io.InputException;
import zz.de.schlichtherle.truezip.io.OutputClosedException;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.de.schlichtherle.truezip.socket.ClutchInputSocket;
import zz.de.schlichtherle.truezip.socket.ClutchOutputSocket;
import zz.de.schlichtherle.truezip.socket.DisconnectingInputShop;
import zz.de.schlichtherle.truezip.socket.DisconnectingOutputShop;
import zz.de.schlichtherle.truezip.socket.IOSocket;
import zz.de.schlichtherle.truezip.socket.InputService;
import zz.de.schlichtherle.truezip.socket.InputShop;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.LockInputShop;
import zz.de.schlichtherle.truezip.socket.LockOutputShop;
import zz.de.schlichtherle.truezip.socket.OutputShop;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.ControlFlowException;

@NotThreadSafe
final class FsTargetArchiveController<E extends FsArchiveEntry>
extends FsFileSystemArchiveController<E>
implements FsArchiveFileSystem.TouchListener {
    private static final BitField<FsInputOption> MOUNT_INPUT_OPTIONS = BitField.of(FsInputOption.CACHE);
    private final FsArchiveDriver<E> driver;
    private final FsController<?> parent;
    private final FsEntryName name;
    @CheckForNull
    private InputArchive<E> inputArchive;
    @CheckForNull
    private OutputArchive<E> outputArchive;

    FsTargetArchiveController(FsArchiveDriver<E> driver, FsLockModel model, FsController<? extends FsModel> parent) {
        super(model);
        if (null == driver) {
            throw new NullPointerException();
        }
        if (model.getParent() != parent.getModel()) {
            throw new IllegalArgumentException("Parent/member mismatch!");
        }
        this.driver = driver;
        this.parent = parent;
        this.name = this.getMountPoint().getPath().getEntryName();
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.driver);
        assert (null != this.parent);
        assert (null != this.name);
        FsArchiveFileSystem fs = this.getFileSystem();
        InputArchive<E> ia = this.inputArchive;
        OutputArchive<E> oa = this.outputArchive;
        assert (null == ia || null != fs) : "null != ia => null != fs";
        assert (null == oa || null != fs) : "null != oa => null != fs";
        assert (null == fs || null != ia || null != oa) : "null != fs => null != ia || null != oa";
        return true;
    }

    @Nullable
    InputArchive<E> getInputArchive() throws FsNeedsSyncException {
        InputArchive<E> ia = this.inputArchive;
        if (null != ia && ia.isClosed()) {
            throw FsNeedsSyncException.get();
        }
        return ia;
    }

    private void setInputArchive(@CheckForNull InputArchive<E> ia) {
        assert (null == ia || null == this.inputArchive);
        this.inputArchive = ia;
        if (null != ia) {
            this.setMounted(true);
        }
    }

    @Nullable
    OutputArchive<E> getOutputArchive() throws FsNeedsSyncException {
        OutputArchive<E> oa = this.outputArchive;
        if (null != oa && oa.isClosed()) {
            throw FsNeedsSyncException.get();
        }
        return oa;
    }

    private void setOutputArchive(@CheckForNull OutputArchive<E> oa) {
        assert (null == oa || null == this.outputArchive);
        this.outputArchive = oa;
        if (null != oa) {
            this.setMounted(true);
        }
    }

    @Override
    public void preTouch() throws IOException {
        this.makeOutputArchive();
    }

    @Override
    public FsController<?> getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void mount(boolean autoCreate) throws IOException {
        try {
            this.mount0(autoCreate);
        }
        finally {
            assert (this.invariants());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private void mount0(boolean autoCreate) throws IOException {
        FsArchiveFileSystem<E> fs;
        FsEntry pe;
        try {
            pe = this.parent.getEntry(this.name);
        }
        catch (FsFalsePositiveArchiveException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (IOException inaccessibleEntry) {
            if (!autoCreate) throw new FsFalsePositiveArchiveException(inaccessibleEntry);
            throw inaccessibleEntry;
        }
        if (null == pe) {
            if (!autoCreate) throw new FsFalsePositiveArchiveException(new FsEntryNotFoundException((FsModel)this.parent.getModel(), this.name, "no such entry"));
            this.makeOutputArchive();
            fs = FsArchiveFileSystem.newEmptyFileSystem(this.driver);
        } else {
            try {
                boolean ro = !this.parent.isWritable(this.name);
                InputSocket<?> is = this.driver.getInputSocket(this.parent, this.name, MOUNT_INPUT_OPTIONS);
                InputArchive<E> ia = new InputArchive<E>(this.driver.newInputShop((FsModel)this.getModel(), is));
                try {
                    fs = FsArchiveFileSystem.newPopulatedFileSystem(this.driver, ia.getArchive(), pe, ro);
                }
                catch (IOException ex) {
                    ia.close();
                    throw ex;
                }
                this.setInputArchive(ia);
                assert (this.isMounted());
            }
            catch (FsFalsePositiveArchiveException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (IOException ex) {
                throw pe.isType(Entry.Type.SPECIAL) ? new FsFalsePositiveArchiveException(ex) : new FsPersistentFalsePositiveArchiveException(ex);
            }
        }
        fs.setTouchListener(this);
        this.setFileSystem(fs);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    OutputArchive<E> makeOutputArchive() throws IOException {
        OutputArchive<E> oa = this.getOutputArchive();
        if (null != oa) {
            assert (this.isMounted());
            return oa;
        }
        BitField<FsOutputOption> options = this.getContext().getOutputOptions().and(FsOutputOptions.OUTPUT_PREFERENCES_MASK).set(FsOutputOption.CACHE);
        OutputSocket<?> os = this.driver.getOutputSocket(this.parent, this.name, options, null);
        InputArchive<E> ia = this.getInputArchive();
        try {
            oa = new OutputArchive<E>(this.driver.newOutputShop((FsModel)this.getModel(), os, null == ia ? null : ia.getArchive()));
        }
        catch (FsFalsePositiveArchiveException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (ControlFlowException ex) {
            assert (ex instanceof FsNeedsLockRetryException) : ex;
            throw ex;
        }
        this.setOutputArchive(oa);
        assert (this.isMounted());
        return oa;
    }

    @Override
    InputSocket<? extends E> getInputSocket(final String name) {
        class Input
        extends ClutchInputSocket<E> {
            Input() {
            }

            @Override
            protected InputSocket<? extends E> getLazyDelegate() throws IOException {
                return FsTargetArchiveController.this.getInputArchive().getInputSocket(name);
            }

            @Override
            public E getLocalTarget() throws IOException {
                try {
                    return (FsArchiveEntry)this.getBoundSocket().getLocalTarget();
                }
                catch (InputClosedException ex) {
                    throw this.map(ex);
                }
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                try {
                    return this.getBoundSocket().newReadOnlyFile();
                }
                catch (InputClosedException ex) {
                    throw this.map(ex);
                }
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                try {
                    return this.getBoundSocket().newSeekableByteChannel();
                }
                catch (InputClosedException ex) {
                    throw this.map(ex);
                }
            }

            @Override
            public InputStream newInputStream() throws IOException {
                try {
                    return this.getBoundSocket().newInputStream();
                }
                catch (InputClosedException ex) {
                    throw this.map(ex);
                }
            }

            ControlFlowException map(InputClosedException ex) {
                return FsNeedsSyncException.get();
            }
        }
        return new Input();
    }

    @Override
    OutputSocket<? extends E> getOutputSocket(E entry) {
        class Output
        extends ClutchOutputSocket<E> {
            final /* synthetic */ FsArchiveEntry val$entry;

            Output() {
                this.val$entry = fsArchiveEntry;
            }

            @Override
            protected OutputSocket<? extends E> getLazyDelegate() throws IOException {
                return FsTargetArchiveController.this.makeOutputArchive().getOutputSocket(this.val$entry);
            }

            @Override
            public E getLocalTarget() throws IOException {
                try {
                    return (FsArchiveEntry)this.getBoundSocket().getLocalTarget();
                }
                catch (OutputClosedException ex) {
                    throw this.map(ex);
                }
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                try {
                    return this.getBoundSocket().newSeekableByteChannel();
                }
                catch (OutputClosedException ex) {
                    throw this.map(ex);
                }
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                try {
                    return this.getBoundSocket().newOutputStream();
                }
                catch (OutputClosedException ex) {
                    throw this.map(ex);
                }
            }

            ControlFlowException map(OutputClosedException ex) {
                return FsNeedsSyncException.get();
            }
        }
        return new Output();
    }

    @Override
    void checkSync(FsEntryName name, @CheckForNull Entry.Access intention) throws FsNeedsSyncException {
        FsArchiveEntry iae;
        String aen;
        FsCovariantEntry fse;
        FsArchiveFileSystem fs = this.getFileSystem();
        if (null == fs) {
            return;
        }
        if (this.getContext().get(FsOutputOption.GROW)) {
            if (null == intention) {
                if (this.driver.getRedundantMetaDataSupport()) {
                    return;
                }
            } else if (Entry.Access.WRITE == intention && this.driver.getRedundantContentSupport()) {
                this.getOutputArchive();
                return;
            }
        }
        if (null == (fse = fs.getEntry(name))) {
            return;
        }
        if (name.isRoot()) {
            return;
        }
        OutputArchive<E> oa = this.getOutputArchive();
        if (null != oa) {
            aen = fse.getEntry().getName();
            if (null != oa.getEntry(aen)) {
                throw FsNeedsSyncException.get();
            }
        } else {
            aen = null;
        }
        if (Entry.Access.READ != intention) {
            return;
        }
        InputArchive<E> ia = this.getInputArchive();
        if (null != ia) {
            if (null == aen) {
                aen = fse.getEntry().getName();
            }
            iae = (FsArchiveEntry)ia.getEntry(aen);
        } else {
            iae = null;
        }
        if (null == iae) {
            throw FsNeedsSyncException.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(BitField<FsSyncOption> options) throws FsSyncException {
        assert (this.isWriteLockedByCurrentThread());
        try {
            FsSyncExceptionBuilder builder = new FsSyncExceptionBuilder();
            if (!options.get(FsSyncOption.ABORT_CHANGES)) {
                this.copy(builder);
            }
            this.close(options, builder);
            builder.check();
        }
        finally {
            assert (this.invariants());
        }
    }

    private void copy(FsSyncExceptionBuilder handler) throws FsSyncException {
        OutputArchive<E> oa = this.outputArchive;
        if (null == oa || oa.isClosed()) {
            return;
        }
        assert (!oa.isClosed());
        DisconnectingOutputShop<FsArchiveEntry> os = oa.getClutch();
        InputArchive<E> ia = this.inputArchive;
        if (null != ia && ia.isClosed()) {
            return;
        }
        assert (null == ia || !ia.isClosed());
        InputService<E> is = null != ia ? ia.getClutch() : new DummyInputService();
        IOException warning = null;
        for (FsCovariantEntry fse : this.getFileSystem()) {
            for (FsArchiveEntry ae : fse.getEntries()) {
                String aen = ae.getName();
                if (null != os.getEntry(aen)) continue;
                try {
                    if (Entry.Type.DIRECTORY == ae.getType()) {
                        if (fse.isRoot() || -1L == ae.getTime(Entry.Access.WRITE)) continue;
                        os.getOutputSocket(ae).newOutputStream().close();
                        continue;
                    }
                    if (null != is.getEntry(aen)) {
                        IOSocket.copy(is.getInputSocket(aen), os.getOutputSocket(ae));
                        continue;
                    }
                    for (Entry.Size size : Entry.ALL_SIZE_SET) {
                        ae.setSize(size, -1L);
                    }
                    ae.setSize(Entry.Size.DATA, 0L);
                    os.getOutputSocket(ae).newOutputStream().close();
                }
                catch (IOException ex) {
                    if (null != warning || !(ex instanceof InputException)) {
                        throw (FsSyncException)handler.fail(new FsSyncException((FsModel)this.getModel(), ex));
                    }
                    warning = ex;
                    handler.warn(new FsSyncWarningException((FsModel)this.getModel(), ex));
                }
            }
        }
    }

    private void close(BitField<FsSyncOption> options, FsSyncExceptionBuilder handler) {
        OutputArchive<E> oa;
        InputArchive<E> ia = this.inputArchive;
        if (null != ia) {
            try {
                ia.close();
            }
            catch (ControlFlowException ex) {
                assert (ex instanceof FsNeedsLockRetryException);
                throw ex;
            }
            catch (IOException ex) {
                handler.warn(new FsSyncWarningException((FsModel)this.getModel(), ex));
            }
            this.setInputArchive(null);
        }
        if (null != (oa = this.outputArchive)) {
            try {
                oa.close();
            }
            catch (ControlFlowException ex) {
                assert (ex instanceof FsNeedsLockRetryException);
                throw ex;
            }
            catch (IOException ex2) {
                handler.warn(new FsSyncException((FsModel)this.getModel(), ex2));
            }
            this.setOutputArchive(null);
        }
        this.setFileSystem(null);
        if (options.get(FsSyncOption.ABORT_CHANGES)) {
            this.setMounted(false);
        }
    }

    private static final class OutputArchive<E extends FsArchiveEntry>
    extends LockOutputShop<E> {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        OutputArchive(@WillCloseWhenClosed OutputShop<E> output) {
            super(new DisconnectingOutputShop<E>(output));
        }

        boolean isClosed() {
            return this.getClutch().isClosed();
        }

        DisconnectingOutputShop<E> getClutch() {
            return (DisconnectingOutputShop)this.delegate;
        }
    }

    private static final class InputArchive<E extends FsArchiveEntry>
    extends LockInputShop<E> {
        final InputShop<E> archive;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        InputArchive(@WillCloseWhenClosed InputShop<E> input) {
            super(new DisconnectingInputShop<E>(input));
            this.archive = input;
        }

        boolean isClosed() {
            return this.getClutch().isClosed();
        }

        DisconnectingInputShop<E> getClutch() {
            return (DisconnectingInputShop)this.delegate;
        }

        InputShop<E> getArchive() {
            assert (!this.isClosed());
            return this.archive;
        }
    }

    private static final class DummyInputService<E extends Entry>
    implements InputService<E> {
        private DummyInputService() {
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        @CheckForNull
        public E getEntry(String name) {
            return null;
        }

        @Override
        public InputSocket<? extends E> getInputSocket(String name) {
            throw new UnsupportedOperationException();
        }
    }
}

