/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonSchemaFactory;
import zz.com.networknt.schema.SchemaValidatorsConfig;
import zz.com.networknt.schema.SpecVersionDetector;

public abstract class CycloneDxSchema {
    public static final String NS_BOM_10 = "http://cyclonedx.org/schema/bom/1.0";
    public static final String NS_BOM_11 = "http://cyclonedx.org/schema/bom/1.1";
    public static final String NS_BOM_12 = "http://cyclonedx.org/schema/bom/1.2";
    public static final String NS_BOM_13 = "http://cyclonedx.org/schema/bom/1.3";
    public static final String NS_BOM_14 = "http://cyclonedx.org/schema/bom/1.4";
    public static final String NS_DEPENDENCY_GRAPH_10 = "http://cyclonedx.org/schema/ext/dependency-graph/1.0";
    public static final String NS_BOM_LATEST = "http://cyclonedx.org/schema/bom/1.4";
    public static final Version VERSION_LATEST = Version.VERSION_14;

    public JsonSchema getJsonSchema(Version schemaVersion, ObjectMapper mapper) throws IOException {
        InputStream spdxInstream = this.getJsonSchemaAsStream(schemaVersion);
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        HashMap<String, String> offlineMappings = new HashMap<String, String>();
        offlineMappings.put("http://cyclonedx.org/schema/spdx.schema.json", this.getClass().getClassLoader().getResource("spdx.schema.json").toExternalForm());
        offlineMappings.put("http://cyclonedx.org/schema/bom-1.2.schema.json", this.getClass().getClassLoader().getResource("bom-1.2-strict.schema.json").toExternalForm());
        offlineMappings.put("http://cyclonedx.org/schema/bom-1.3.schema.json", this.getClass().getClassLoader().getResource("bom-1.3-strict.schema.json").toExternalForm());
        offlineMappings.put("http://cyclonedx.org/schema/bom-1.4.schema.json", this.getClass().getClassLoader().getResource("bom-1.4.schema.json").toExternalForm());
        config.setUriMappings(offlineMappings);
        JsonNode schemaNode = mapper.readTree(spdxInstream);
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance(SpecVersionDetector.detect(schemaNode));
        return factory.getSchema(schemaNode, config);
    }

    private InputStream getJsonSchemaAsStream(Version schemaVersion) {
        if (Version.VERSION_12 == schemaVersion) {
            return this.getClass().getClassLoader().getResourceAsStream("bom-1.2-strict.schema.json");
        }
        if (Version.VERSION_13 == schemaVersion) {
            return this.getClass().getClassLoader().getResourceAsStream("bom-1.3-strict.schema.json");
        }
        return this.getClass().getClassLoader().getResourceAsStream("bom-1.4.schema.json");
    }

    public Schema getXmlSchema(Version schemaVersion) throws SAXException {
        if (Version.VERSION_10 == schemaVersion) {
            return this.getXmlSchema10();
        }
        if (Version.VERSION_11 == schemaVersion) {
            return this.getXmlSchema11();
        }
        if (Version.VERSION_12 == schemaVersion) {
            return this.getXmlSchema12();
        }
        if (Version.VERSION_13 == schemaVersion) {
            return this.getXmlSchema13();
        }
        return this.getXmlSchema14();
    }

    private Schema getXmlSchema10() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.0.xsd"));
    }

    private Schema getXmlSchema11() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.1.xsd"));
    }

    private Schema getXmlSchema12() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.2.xsd"));
    }

    private Schema getXmlSchema13() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.3.xsd"));
    }

    private Schema getXmlSchema14() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.4.xsd"));
    }

    public Schema getXmlSchema(InputStream ... inputStreams) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] schemaFiles = new Source[inputStreams.length];
        for (int i = 0; i < inputStreams.length; ++i) {
            schemaFiles[i] = new StreamSource(inputStreams[i]);
        }
        return schemaFactory.newSchema(schemaFiles);
    }

    public static enum Version {
        VERSION_10("http://cyclonedx.org/schema/bom/1.0", "1.0", 1.0),
        VERSION_11("http://cyclonedx.org/schema/bom/1.1", "1.1", 1.1),
        VERSION_12("http://cyclonedx.org/schema/bom/1.2", "1.2", 1.2),
        VERSION_13("http://cyclonedx.org/schema/bom/1.3", "1.3", 1.3),
        VERSION_14("http://cyclonedx.org/schema/bom/1.4", "1.4", 1.4);

        private final String namespace;
        private final String versionString;
        private final double version;

        public String getNamespace() {
            return this.namespace;
        }

        public String getVersionString() {
            return this.versionString;
        }

        public double getVersion() {
            return this.version;
        }

        private Version(String namespace, String versionString, double version) {
            this.namespace = namespace;
            this.versionString = versionString;
            this.version = version;
        }
    }
}

