/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.model;

import java.util.ArrayList;
import java.util.List;
import zz.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import zz.com.fasterxml.jackson.annotation.JsonInclude;
import zz.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import zz.org.cyclonedx.model.BomReference;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"aggregate", "assemblies", "dependencies"})
public class Composition {
    private Aggregate aggregate;
    private List<BomReference> assemblies;
    private List<BomReference> dependencies;

    public Aggregate getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(Aggregate aggregate) {
        this.aggregate = aggregate;
    }

    @JacksonXmlElementWrapper(localName="assemblies")
    @JacksonXmlProperty(localName="assembly")
    public List<BomReference> getAssemblies() {
        return this.assemblies;
    }

    public void setAssemblies(List<BomReference> assemblies) {
        this.assemblies = assemblies;
    }

    public void addAssembly(BomReference assembly) {
        if (this.assemblies == null) {
            this.assemblies = new ArrayList<BomReference>();
        }
        this.assemblies.add(assembly);
    }

    @JacksonXmlElementWrapper(localName="dependencies")
    @JacksonXmlProperty(localName="dependency")
    public List<BomReference> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<BomReference> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(BomReference dependency) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<BomReference>();
        }
        this.dependencies.add(dependency);
    }

    public static enum Aggregate {
        COMPLETE("complete"),
        INCOMPLETE("incomplete"),
        INCOMPLETE_FIRST_PARTY_ONLY("incomplete_first_party_only"),
        INCOMPLETE_THIRD_PARTY_ONLY("incomplete_third_party_only"),
        UNKNOWN("unknown"),
        NOT_SPECIFIED("not_specified");

        private final String name;

        public String getAggregateName() {
            return this.name;
        }

        private Aggregate(String name) {
            this.name = name;
        }
    }
}

