/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.gitrepo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import zz.org.eclipse.jgit.lib.Repository;

public class RepoProject
implements Comparable<RepoProject> {
    private final String name;
    private final String path;
    private final String revision;
    private final String remote;
    private final Set<String> groups;
    private final List<CopyFile> copyfiles;
    private final List<LinkFile> linkfiles;
    private String recommendShallow;
    private String url;
    private String defaultRevision;

    public RepoProject(String name, String path, String revision, String remote, Set<String> groups, String recommendShallow) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.path = path != null ? path : name;
        this.revision = revision;
        this.remote = remote;
        this.groups = groups;
        this.recommendShallow = recommendShallow;
        this.copyfiles = new ArrayList<CopyFile>();
        this.linkfiles = new ArrayList<LinkFile>();
    }

    public RepoProject(String name, String path, String revision, String remote, String groupsParam) {
        this(name, path, revision, remote, new HashSet<String>(), null);
        if (groupsParam != null && groupsParam.length() > 0) {
            this.setGroups(groupsParam);
        }
    }

    public RepoProject setUrl(String url) {
        this.url = url;
        return this;
    }

    public RepoProject setGroups(String groupsParam) {
        this.groups.clear();
        this.groups.addAll(Arrays.asList(groupsParam.split(",")));
        return this;
    }

    public RepoProject setDefaultRevision(String defaultRevision) {
        this.defaultRevision = defaultRevision;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getRevision() {
        return this.revision == null ? this.defaultRevision : this.revision;
    }

    public List<CopyFile> getCopyFiles() {
        return Collections.unmodifiableList(this.copyfiles);
    }

    public List<LinkFile> getLinkFiles() {
        return Collections.unmodifiableList(this.linkfiles);
    }

    public String getUrl() {
        return this.url;
    }

    public String getRemote() {
        return this.remote;
    }

    public boolean inGroup(String group) {
        return this.groups.contains(group);
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String getRecommendShallow() {
        return this.recommendShallow;
    }

    public void setRecommendShallow(String recommendShallow) {
        this.recommendShallow = recommendShallow;
    }

    public void addCopyFile(CopyFile copyfile) {
        this.copyfiles.add(copyfile);
    }

    public void addCopyFiles(Collection<CopyFile> copyFiles) {
        this.copyfiles.addAll(copyFiles);
    }

    public void clearCopyFiles() {
        this.copyfiles.clear();
    }

    public void addLinkFile(LinkFile linkfile) {
        this.linkfiles.add(linkfile);
    }

    public void addLinkFiles(Collection<LinkFile> linkFiles) {
        this.linkfiles.addAll(linkFiles);
    }

    public void clearLinkFiles() {
        this.linkfiles.clear();
    }

    private String getPathWithSlash() {
        if (this.path.endsWith("/")) {
            return this.path;
        }
        return String.valueOf(this.path) + "/";
    }

    public boolean isAncestorOf(RepoProject that) {
        return this.isAncestorOf(that.getPathWithSlash());
    }

    public boolean isAncestorOf(String thatPath) {
        return thatPath.startsWith(this.getPathWithSlash());
    }

    public boolean equals(Object o) {
        if (o instanceof RepoProject) {
            RepoProject that = (RepoProject)o;
            return this.getPathWithSlash().equals(that.getPathWithSlash());
        }
        return false;
    }

    public int hashCode() {
        return this.getPathWithSlash().hashCode();
    }

    @Override
    public int compareTo(RepoProject that) {
        return this.getPathWithSlash().compareTo(that.getPathWithSlash());
    }

    public static class CopyFile
    extends ReferenceFile {
        public CopyFile(Repository repo, String path, String src, String dest) {
            super(repo, path, src, dest);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void copy() throws IOException {
            File destFile;
            File srcFile;
            block13: {
                srcFile = new File(this.repo.getWorkTree(), String.valueOf(this.path) + "/" + this.src);
                destFile = new File(this.repo.getWorkTree(), this.dest);
                Throwable throwable = null;
                Object var4_5 = null;
                try {
                    FileInputStream input = new FileInputStream(srcFile);
                    try {
                        try (FileOutputStream output = new FileOutputStream(destFile);){
                            FileChannel channel = input.getChannel();
                            output.getChannel().transferFrom(channel, 0L, channel.size());
                        }
                        if (input == null) break block13;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (input == null) throw throwable;
                        input.close();
                        throw throwable;
                    }
                    input.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            destFile.setExecutable(srcFile.canExecute());
        }
    }

    public static class LinkFile
    extends ReferenceFile {
        public LinkFile(Repository repo, String path, String src, String dest) {
            super(repo, path, src, dest);
        }
    }

    public static class ReferenceFile {
        final Repository repo;
        final String path;
        final String src;
        final String dest;

        public ReferenceFile(Repository repo, String path, String src, String dest) {
            this.repo = repo;
            this.path = path;
            this.src = src;
            this.dest = dest;
        }
    }
}

