/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.transport;

import zz.org.eclipse.jgit.errors.UnsupportedCredentialItem;
import zz.org.eclipse.jgit.transport.CredentialItem;
import zz.org.eclipse.jgit.transport.CredentialsProvider;
import zz.org.eclipse.jgit.transport.NetRC;
import zz.org.eclipse.jgit.transport.URIish;

public class NetRCCredentialsProvider
extends CredentialsProvider {
    NetRC netrc = new NetRC();

    public static void install() {
        CredentialsProvider.setDefault(new NetRCCredentialsProvider());
    }

    @Override
    public boolean supports(CredentialItem ... items) {
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i = credentialItemArray[n2];
            if (!(i instanceof CredentialItem.Username) && !(i instanceof CredentialItem.Password)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        NetRC.NetRCEntry cc = this.netrc.getEntry(uri.getHost());
        if (cc == null) {
            return false;
        }
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i = credentialItemArray[n2];
            if (i instanceof CredentialItem.Username) {
                ((CredentialItem.Username)i).setValue(cc.login);
            } else if (i instanceof CredentialItem.Password) {
                ((CredentialItem.Password)i).setValue(cc.password);
            } else if (i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: ")) {
                ((CredentialItem.StringType)i).setValue(new String(cc.password));
            } else {
                throw new UnsupportedCredentialItem(uri, String.valueOf(i.getClass().getName()) + ":" + i.getPromptText());
            }
            ++n2;
        }
        return !NetRCCredentialsProvider.isAnyNull(items);
    }

    @Override
    public boolean isInteractive() {
        return false;
    }
}

