/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;

public class ProgressSpinner {
    private static final long MIN_REFRESH_MILLIS = 500L;
    private static final char[] STATES = new char[]{'-', '\\', '|', '/'};
    private final OutputStream out;
    private String msg;
    private int state;
    private boolean write;
    private boolean shown;
    private long nextUpdateMillis;

    public ProgressSpinner(OutputStream out) {
        this.out = out;
        this.write = true;
    }

    public void beginTask(String title, long delay, TimeUnit delayUnits) {
        this.msg = title;
        this.state = 0;
        this.shown = false;
        long now = System.currentTimeMillis();
        if (delay > 0L) {
            this.nextUpdateMillis = now + delayUnits.toMillis(delay);
        } else {
            this.send(now);
        }
    }

    public void update() {
        long now = System.currentTimeMillis();
        if (now >= this.nextUpdateMillis) {
            this.send(now);
            this.state = (this.state + 1) % STATES.length;
        }
    }

    private void send(long now) {
        StringBuilder buf = new StringBuilder(this.msg.length() + 16);
        buf.append('\r').append(this.msg).append("... (");
        buf.append(STATES[this.state]);
        buf.append(")  ");
        this.shown = true;
        this.write(buf.toString());
        this.nextUpdateMillis = now + 500L;
    }

    public void endTask(String result) {
        if (this.shown) {
            this.write(String.valueOf('\r') + this.msg + "... " + result + "\n");
        }
    }

    private void write(String s) {
        if (this.write) {
            try {
                this.out.write(s.getBytes(StandardCharsets.UTF_8));
                this.out.flush();
            }
            catch (IOException e) {
                this.write = false;
            }
        }
    }
}

