/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.util.time;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import zz.org.eclipse.jgit.util.time.MonotonicClock;
import zz.org.eclipse.jgit.util.time.ProposedTimestamp;

public class MonotonicSystemClock
implements MonotonicClock {
    private static final AtomicLong before = new AtomicLong();

    private static long nowMicros() {
        long n;
        long o;
        long now = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        while (!before.compareAndSet(o = before.get(), n = Math.max(o + 1L, now))) {
        }
        return n;
    }

    @Override
    public ProposedTimestamp propose() {
        final long u = MonotonicSystemClock.nowMicros();
        return new ProposedTimestamp(){

            @Override
            public long read(TimeUnit unit) {
                return unit.convert(u, TimeUnit.MICROSECONDS);
            }

            @Override
            public void blockUntil(Duration maxWait) {
            }
        };
    }
}

