/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.jacksonstore;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.com.fasterxml.jackson.databind.node.JsonNodeType;
import zz.org.spdx.jacksonstore.MultiFormatStore;
import zz.org.spdx.jacksonstore.SpdxJsonLDContext;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.SpdxConstants;
import zz.org.spdx.library.model.ExternalSpdxElement;
import zz.org.spdx.library.model.IndividualUriValue;
import zz.org.spdx.library.model.ModelStorageClassConverter;
import zz.org.spdx.library.model.ReferenceType;
import zz.org.spdx.library.model.SimpleUriValue;
import zz.org.spdx.library.model.SpdxDocument;
import zz.org.spdx.library.model.SpdxElement;
import zz.org.spdx.library.model.SpdxModelFactory;
import zz.org.spdx.library.model.TypedValue;
import zz.org.spdx.library.model.enumerations.RelationshipType;
import zz.org.spdx.library.model.license.AnyLicenseInfo;
import zz.org.spdx.library.model.license.LicenseInfoFactory;
import zz.org.spdx.library.referencetype.ListedReferenceTypes;
import zz.org.spdx.storage.IModelStore;

public class JacksonDeSerializer {
    static final Set<String> SKIPPED_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("packages", "files", "snippets", "SPDXID", "relationships", "documentNamespace")));
    private IModelStore store;
    private MultiFormatStore.Format format;
    private Map<String, Map<String, Map<SimpleUriValue, String>>> addedRelationships = new HashMap<String, Map<String, Map<SimpleUriValue, String>>>();

    public JacksonDeSerializer(IModelStore store, MultiFormatStore.Format format) {
        Objects.requireNonNull(store, "Model store can not be null");
        Objects.requireNonNull(format, "Format can not be null");
        this.store = store;
        this.format = format;
    }

    public void storeDocument(String documentNamespace, JsonNode doc) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentNamespace, "Null required document namespace");
        Objects.requireNonNull(doc, "Null document JSON Node");
        IModelStore.IModelStoreLock lock = this.store.enterCriticalSection(documentNamespace, false);
        try {
            HashMap<String, String> spdxIdProperties = new HashMap<String, String>();
            this.store.create(documentNamespace, "SPDXRef-DOCUMENT", "SpdxDocument");
            this.restoreObjectPropertyValues(documentNamespace, "SPDXRef-DOCUMENT", doc, spdxIdProperties);
            HashMap<String, TypedValue> addedElements = new HashMap<String, TypedValue>();
            addedElements.put("SPDXRef-DOCUMENT", new TypedValue("SPDXRef-DOCUMENT", "SpdxDocument"));
            this.restoreElements(documentNamespace, "Package", doc.get("packages"), addedElements, spdxIdProperties);
            this.restoreElements(documentNamespace, "File", doc.get("files"), addedElements, spdxIdProperties);
            this.restoreElements(documentNamespace, "Snippet", doc.get("snippets"), addedElements, spdxIdProperties);
            this.restoreRelationships(documentNamespace, doc.get("relationships"), addedElements);
            for (Map.Entry propertyToFix : spdxIdProperties.entrySet()) {
                Optional<Object> idToReplace = this.store.getValue(documentNamespace, (String)propertyToFix.getKey(), (String)propertyToFix.getValue());
                if (!idToReplace.isPresent()) {
                    throw new InvalidSPDXAnalysisException("Missing SPDX ID for " + (String)propertyToFix.getKey() + " " + (String)propertyToFix.getValue());
                }
                if (idToReplace.get() instanceof Collection) {
                    HashSet<Object> replacements = new HashSet<Object>();
                    for (Object e : (Collection)idToReplace.get()) {
                        if (!(e instanceof String)) {
                            throw new InvalidSPDXAnalysisException("Can not replace the SPDX ID with value due to invalid type for " + (String)propertyToFix.getKey() + " " + (String)propertyToFix.getValue());
                        }
                        replacements.add(this.idToObjectValue(documentNamespace, (String)e, addedElements));
                    }
                    this.store.clearValueCollection(documentNamespace, (String)propertyToFix.getKey(), (String)propertyToFix.getValue());
                    for (Object e : replacements) {
                        this.store.addValueToCollection(documentNamespace, (String)propertyToFix.getKey(), (String)propertyToFix.getValue(), e);
                    }
                    continue;
                }
                if (!(idToReplace.get() instanceof String)) {
                    throw new InvalidSPDXAnalysisException("Can not replace the SPDX ID with value due to invalid type for " + (String)propertyToFix.getKey() + " " + (String)propertyToFix.getValue());
                }
                String spdxId = (String)idToReplace.get();
                this.store.setValue(documentNamespace, (String)propertyToFix.getKey(), (String)propertyToFix.getValue(), this.idToObjectValue(documentNamespace, spdxId, addedElements));
            }
        }
        finally {
            this.store.leaveCriticalSection(lock);
        }
    }

    private void restoreElement(String documentUri, String type, @Nullable JsonNode jsonNode, Map<String, TypedValue> addedElements, Map<String, String> spdxIdProperties) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(jsonNode)) {
            return;
        }
        if (!jsonNode.isObject()) {
            throw new InvalidSPDXAnalysisException("Invalid JSON node type for SPDX element");
        }
        JsonNode idNode = jsonNode.get("SPDXID");
        if (Objects.isNull(idNode) || !idNode.isTextual()) {
            throw new InvalidSPDXAnalysisException("Missing SPDX ID for type " + type);
        }
        String id = idNode.asText();
        if (Objects.isNull(id) || id.isEmpty()) {
            throw new InvalidSPDXAnalysisException("Empty SPDX ID for type " + type);
        }
        if (addedElements.containsKey(id)) {
            throw new InvalidSPDXAnalysisException("Duplicate SPDX ID: " + id);
        }
        this.store.create(documentUri, id, type);
        try {
            this.restoreObjectPropertyValues(documentUri, id, jsonNode, spdxIdProperties);
        }
        catch (InvalidSPDXAnalysisException ex) {
            throw new InvalidSPDXAnalysisException("Error parsing JSON field for ID " + id + ": " + ex.getMessage(), ex);
        }
        addedElements.put(id, new TypedValue(id, type));
    }

    private void restoreElements(String documentUri, String type, @Nullable JsonNode jsonNode, Map<String, TypedValue> addedElements, Map<String, String> spdxIdProperties) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(jsonNode)) {
            return;
        }
        if (jsonNode.isArray()) {
            Iterator<JsonNode> iter = jsonNode.elements();
            while (iter.hasNext()) {
                this.restoreElement(documentUri, type, iter.next(), addedElements, spdxIdProperties);
            }
        } else {
            this.restoreElement(documentUri, type, jsonNode, addedElements, spdxIdProperties);
        }
    }

    private void restoreRelationships(String documentNamespace, JsonNode jsonNode, Map<String, TypedValue> addedElements) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(jsonNode)) {
            return;
        }
        if (jsonNode.isArray()) {
            Iterator<JsonNode> iter = jsonNode.elements();
            while (iter.hasNext()) {
                this.restoreRelationship(documentNamespace, iter.next(), addedElements);
            }
        } else {
            this.restoreRelationship(documentNamespace, jsonNode, addedElements);
        }
    }

    private void restoreRelationship(String documentNamespace, JsonNode relationship, Map<String, TypedValue> addedElements) throws InvalidSPDXAnalysisException {
        JsonNode elementIdNode = relationship.get("spdxElementId");
        if (Objects.isNull(elementIdNode) || !elementIdNode.isTextual()) {
            throw new InvalidSPDXAnalysisException("Missing SPDX element ID");
        }
        TypedValue element = addedElements.get(elementIdNode.asText());
        if (Objects.isNull(element)) {
            throw new InvalidSPDXAnalysisException("Missing SPDX element for ID " + elementIdNode.asText());
        }
        JsonNode relationshipTypeNode = relationship.get("relationshipType");
        if (Objects.isNull(relationshipTypeNode) || !relationshipTypeNode.isTextual()) {
            throw new InvalidSPDXAnalysisException("Missing required relationship type");
        }
        String relationshipTypeUri = null;
        try {
            relationshipTypeUri = RelationshipType.valueOf(relationshipTypeNode.asText()).getIndividualURI();
        }
        catch (Exception ex) {
            throw new InvalidSPDXAnalysisException("Unknown relationship type: " + relationshipTypeNode.asText());
        }
        SimpleUriValue relationshipType = new SimpleUriValue(relationshipTypeUri);
        JsonNode relatedElementNode = relationship.get("relatedSpdxElement");
        if (Objects.isNull(relatedElementNode) || !relatedElementNode.isTextual()) {
            throw new InvalidSPDXAnalysisException("Missing required related element");
        }
        Object relatedElement = this.idToObjectValue(documentNamespace, relatedElementNode.asText(), addedElements);
        JsonNode commentNode = relationship.get("comment");
        Optional<Object> relationshipComment = Objects.isNull(commentNode) || !commentNode.isTextual() ? Optional.empty() : Optional.of(commentNode.asText());
        this.addRelationship(documentNamespace, element.getId(), relationshipType, relatedElement, relationshipComment);
    }

    private String addRelationship(String documentNamespace, String elementId, SimpleUriValue relationshipType, Object relatedElement, Optional<String> relationshipComment) throws InvalidSPDXAnalysisException {
        String relationshipId;
        String relatedElementId;
        if (relatedElement instanceof TypedValue) {
            relatedElementId = ((TypedValue)relatedElement).getId();
        } else if (relatedElement instanceof String) {
            relatedElementId = (String)relatedElement;
        } else if (relatedElement instanceof IndividualUriValue) {
            relatedElementId = ((IndividualUriValue)relatedElement).getIndividualURI();
        } else {
            throw new InvalidSPDXAnalysisException("Related element is not of an Element type for relationship to element " + elementId);
        }
        Map<SimpleUriValue, String> relatedElementRelationships = null;
        Map<String, Map<SimpleUriValue, String>> elementRelationships = this.addedRelationships.get(elementId);
        if (Objects.nonNull(elementRelationships)) {
            relatedElementRelationships = elementRelationships.get(relatedElementId);
            if (Objects.nonNull(relatedElementRelationships)) {
                relationshipId = relatedElementRelationships.get(relationshipType);
                if (Objects.nonNull(relationshipId)) {
                    return relationshipId;
                }
            } else {
                relatedElementRelationships = new HashMap<SimpleUriValue, String>();
                elementRelationships.put(relatedElementId, relatedElementRelationships);
            }
        } else {
            elementRelationships = new HashMap<String, Map<SimpleUriValue, String>>();
            relatedElementRelationships = new HashMap<SimpleUriValue, String>();
            elementRelationships.put(relatedElementId, relatedElementRelationships);
            this.addedRelationships.put(elementId, elementRelationships);
        }
        relationshipId = this.store.getNextId(IModelStore.IdType.Anonymous, documentNamespace);
        this.store.create(documentNamespace, relationshipId, "Relationship");
        this.store.setValue(documentNamespace, relationshipId, "relationshipType", relationshipType);
        this.store.setValue(documentNamespace, relationshipId, "relatedSpdxElement", relatedElement);
        this.store.addValueToCollection(documentNamespace, elementId, "relationship", new TypedValue(relationshipId, "Relationship"));
        if (relationshipComment.isPresent()) {
            this.store.setValue(documentNamespace, relationshipId, "comment", relationshipComment.get());
        }
        relatedElementRelationships.put(relationshipType, relationshipId);
        return relationshipId;
    }

    private void restoreObjectPropertyValues(String documentUri, String id, JsonNode node, Map<String, String> spdxIdProperties) throws InvalidSPDXAnalysisException {
        Iterator<Map.Entry<String, JsonNode>> fieldIterator = node.fields();
        while (fieldIterator.hasNext()) {
            Map.Entry<String, JsonNode> field = fieldIterator.next();
            if (SKIPPED_PROPERTIES.contains(field.getKey())) continue;
            if ("documentDescribes".equals(field.getKey())) {
                this.convertFieldToRelationship(documentUri, id, field.getValue(), RelationshipType.DESCRIBES, spdxIdProperties);
                continue;
            }
            if ("hasFile".equals(MultiFormatStore.collectionPropertyNameToPropertyName(field.getKey()))) {
                this.convertFieldToRelationship(documentUri, id, field.getValue(), RelationshipType.CONTAINS, spdxIdProperties);
                continue;
            }
            this.setPropertyValueForJsonNode(documentUri, id, field.getKey(), field.getValue(), spdxIdProperties, false);
        }
    }

    private void convertFieldToRelationship(String documentUri, String id, JsonNode spdxIdField, RelationshipType relationshipType, Map<String, String> spdxIdProperties) throws InvalidSPDXAnalysisException {
        if (spdxIdField instanceof ArrayNode) {
            for (JsonNode spdxidNode : (ArrayNode)spdxIdField) {
                String relationshipId = this.addRelationship(documentUri, id, new SimpleUriValue(relationshipType.getIndividualURI()), spdxidNode.asText(), Optional.empty());
                spdxIdProperties.put(relationshipId, "relatedSpdxElement");
            }
        } else {
            String relationshipId = this.addRelationship(documentUri, id, new SimpleUriValue(relationshipType.getIndividualURI()), spdxIdField.asText(), Optional.empty());
            spdxIdProperties.put(relationshipId, "relatedSpdxElement");
        }
    }

    private void setPropertyValueForJsonNode(String documentUri, String id, String property, JsonNode value, Map<String, String> spdxIdProperties, boolean list) throws InvalidSPDXAnalysisException {
        if (SpdxJsonLDContext.getInstance().isList(property)) {
            list = true;
        }
        if (JsonNodeType.ARRAY.equals((Object)value.getNodeType())) {
            Iterator<JsonNode> iter = value.elements();
            while (iter.hasNext()) {
                this.setPropertyValueForJsonNode(documentUri, id, property, iter.next(), spdxIdProperties, true);
            }
        } else if (!JsonNodeType.NULL.equals((Object)value.getNodeType())) {
            Optional<String> propertyType = SpdxJsonLDContext.getInstance().getType(property);
            if (list) {
                this.store.addValueToCollection(documentUri, id, MultiFormatStore.collectionPropertyNameToPropertyName(property), this.toStoredObject(documentUri, id, property, value, propertyType, spdxIdProperties, list));
            } else {
                this.store.setValue(documentUri, id, property, this.toStoredObject(documentUri, id, property, value, propertyType, spdxIdProperties, list));
            }
        }
    }

    private Object toStoredObject(String documentUri, String id, String property, JsonNode value, Optional<String> propertyType, Map<String, String> spdxIdProperties, boolean list) throws InvalidSPDXAnalysisException {
        switch (value.getNodeType()) {
            case ARRAY: {
                throw new InvalidSPDXAnalysisException("Can not convert a JSON array to a stored object");
            }
            case BOOLEAN: {
                if (propertyType.isPresent()) {
                    Class<? extends Object> toStoreClass = SpdxJsonLDContext.XMLSCHEMA_TYPE_TO_JAVA_CLASS.get(propertyType.get());
                    if (Objects.isNull(toStoreClass)) {
                        return value.asBoolean();
                    }
                    if (String.class.equals(toStoreClass)) {
                        return Boolean.toString(value.asBoolean());
                    }
                    if (Boolean.class.equals(toStoreClass)) {
                        return value.asBoolean();
                    }
                    throw new InvalidSPDXAnalysisException("Can not convert a JSON BOOLEAN to a " + toStoreClass.toString());
                }
                return value.asBoolean();
            }
            case NULL: {
                throw new InvalidSPDXAnalysisException("Can not convert a JSON NULL to a stored object");
            }
            case NUMBER: {
                if (propertyType.isPresent()) {
                    Class<? extends Object> toStoreClass = SpdxJsonLDContext.XMLSCHEMA_TYPE_TO_JAVA_CLASS.get(propertyType.get());
                    if (Objects.isNull(toStoreClass)) {
                        return value.asInt();
                    }
                    if (String.class.equals(toStoreClass)) {
                        return Double.toString(value.asDouble());
                    }
                    if (Integer.class.equals(toStoreClass)) {
                        return value.asInt();
                    }
                    throw new InvalidSPDXAnalysisException("Can not convert a JSON NUMBER to a " + toStoreClass.toString());
                }
                return value.asInt();
            }
            case OBJECT: {
                if (!propertyType.isPresent()) {
                    throw new InvalidSPDXAnalysisException("Unknown type for property " + property);
                }
                if ("SinglePointer".equals(propertyType.get())) {
                    if (Objects.nonNull(value.get("offset"))) {
                        propertyType = Optional.of("ByteOffsetPointer");
                    } else if (Objects.nonNull(value.get("lineNumber"))) {
                        propertyType = Optional.of("LineCharPointer");
                    } else {
                        throw new InvalidSPDXAnalysisException("Can not determine type for snippet pointer");
                    }
                }
                String objectId = this.findObjectIdInJsonObject(documentUri, value);
                this.store.create(documentUri, objectId, propertyType.get());
                this.restoreObjectPropertyValues(documentUri, objectId, value, spdxIdProperties);
                return new TypedValue(objectId, propertyType.get());
            }
            case STRING: {
                return this.getStringPropertyValueForJsonNode(documentUri, id, property, value, propertyType, spdxIdProperties, list);
            }
        }
        throw new InvalidSPDXAnalysisException("Unsupported JSON node type: " + value.toString());
    }

    private Object getStringPropertyValueForJsonNode(String documentUri, String id, String property, JsonNode value, Optional<String> propertyType, Map<String, String> spdxIdProperties, boolean list) throws InvalidSPDXAnalysisException {
        Class<Object> clazz = null;
        if (propertyType.isPresent() && Objects.isNull(clazz = SpdxModelFactory.SPDX_TYPE_TO_CLASS.get(propertyType.get()))) {
            clazz = SpdxJsonLDContext.XMLSCHEMA_TYPE_TO_JAVA_CLASS.get(propertyType.get());
        }
        if (Objects.isNull(clazz)) {
            return value.asText();
        }
        if (AnyLicenseInfo.class.isAssignableFrom(clazz)) {
            AnyLicenseInfo parsedLicense = LicenseInfoFactory.parseSPDXLicenseString(value.asText(), this.store, documentUri, null);
            return ModelStorageClassConverter.modelObjectToStoredObject(parsedLicense, documentUri, this.store, null);
        }
        if (SpdxDocument.class.isAssignableFrom(clazz)) {
            final String uriValue = value.asText();
            return new IndividualUriValue(){

                @Override
                public String getIndividualURI() {
                    return uriValue;
                }
            };
        }
        if (ReferenceType.class.isAssignableFrom(clazz)) {
            String referenceTypeValue = value.asText();
            try {
                ReferenceType referenceType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName(referenceTypeValue);
                if (Objects.nonNull(referenceType)) {
                    return referenceType;
                }
            }
            catch (InvalidSPDXAnalysisException referenceType) {
                // empty catch block
            }
            final String uriValue = referenceTypeValue;
            return new IndividualUriValue(){

                @Override
                public String getIndividualURI() {
                    return uriValue;
                }
            };
        }
        if (SpdxElement.class.isAssignableFrom(clazz)) {
            if (list) {
                spdxIdProperties.put(id, MultiFormatStore.collectionPropertyNameToPropertyName(property));
            } else {
                spdxIdProperties.put(id, property);
            }
            return value.asText();
        }
        if (clazz.isEnum()) {
            Object[] objectArray = clazz.getEnumConstants();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object enumConst = objectArray[n2];
                if (enumConst instanceof IndividualUriValue && value.asText().replaceAll("-", "_").equals(enumConst.toString())) {
                    return new SimpleUriValue((IndividualUriValue)enumConst);
                }
                ++n2;
            }
            throw new InvalidSPDXAnalysisException("Could not find enum constants for " + value.asText() + " property " + property);
        }
        if (String.class.equals(clazz)) {
            return value.asText();
        }
        if (Boolean.class.equals(clazz)) {
            try {
                return Boolean.parseBoolean(value.asText());
            }
            catch (Exception ex) {
                throw new InvalidSPDXAnalysisException("Unable to convert " + value.asText() + " to boolean for property " + property);
            }
        }
        if (Integer.class.equals(clazz)) {
            try {
                return Integer.parseInt(value.asText());
            }
            catch (Exception ex) {
                throw new InvalidSPDXAnalysisException("Unable to convert " + value.asText() + " to integer for property " + property);
            }
        }
        throw new InvalidSPDXAnalysisException("Unknown type: " + propertyType.get() + " for property " + property);
    }

    private String findObjectIdInJsonObject(String documentUri, JsonNode jsonObject) throws InvalidSPDXAnalysisException {
        JsonNode retval = jsonObject.get("SPDXID");
        if (Objects.isNull(retval) || !retval.isTextual()) {
            retval = jsonObject.get("licenseId");
        }
        if (Objects.isNull(retval) || !retval.isTextual()) {
            retval = jsonObject.get("licenseExceptionId");
        }
        if (Objects.isNull(retval) || !retval.isTextual()) {
            retval = jsonObject.get("externalDocumentId");
        }
        if (Objects.isNull(retval) || !retval.isTextual()) {
            return this.store.getNextId(IModelStore.IdType.Anonymous, documentUri);
        }
        return retval.asText();
    }

    private Object idToObjectValue(final String documentNamespace, final String spdxId, Map<String, TypedValue> addedElements) throws InvalidSPDXAnalysisException {
        TypedValue fixedValue = addedElements.get(spdxId);
        if (Objects.isNull(fixedValue)) {
            if (spdxId.equals(SpdxConstants.NONE_VALUE)) {
                return new IndividualUriValue(){

                    @Override
                    public String getIndividualURI() {
                        return "http://spdx.org/rdf/terms#none";
                    }
                };
            }
            if (spdxId.equals(SpdxConstants.NOASSERTION_VALUE)) {
                return new IndividualUriValue(){

                    @Override
                    public String getIndividualURI() {
                        return "http://spdx.org/rdf/terms#noassertion";
                    }
                };
            }
            if (spdxId.startsWith("DocumentRef-")) {
                final IModelStore modelStore = this.store;
                IndividualUriValue spdxExternalElementRef = new IndividualUriValue(){

                    @Override
                    public String getIndividualURI() {
                        try {
                            return ExternalSpdxElement.externalSpdxElementIdToURI(spdxId, modelStore, documentNamespace, null);
                        }
                        catch (InvalidSPDXAnalysisException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                return spdxExternalElementRef;
            }
            throw new InvalidSPDXAnalysisException("No SPDX element found for SPDX ID " + spdxId);
        }
        return fixedValue;
    }
}

