/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.library.model;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.ModelCopyManager;
import zz.org.spdx.library.SpdxConstants;
import zz.org.spdx.library.model.Annotation;
import zz.org.spdx.library.model.Checksum;
import zz.org.spdx.library.model.ExternalDocumentRef;
import zz.org.spdx.library.model.ExternalRef;
import zz.org.spdx.library.model.ExternalSpdxElement;
import zz.org.spdx.library.model.GenericModelObject;
import zz.org.spdx.library.model.GenericSpdxElement;
import zz.org.spdx.library.model.GenericSpdxItem;
import zz.org.spdx.library.model.ModelObject;
import zz.org.spdx.library.model.ReferenceType;
import zz.org.spdx.library.model.Relationship;
import zz.org.spdx.library.model.SpdxCreatorInformation;
import zz.org.spdx.library.model.SpdxDocument;
import zz.org.spdx.library.model.SpdxElement;
import zz.org.spdx.library.model.SpdxFile;
import zz.org.spdx.library.model.SpdxIdNotFoundException;
import zz.org.spdx.library.model.SpdxItem;
import zz.org.spdx.library.model.SpdxNoAssertionElement;
import zz.org.spdx.library.model.SpdxNoneElement;
import zz.org.spdx.library.model.SpdxPackage;
import zz.org.spdx.library.model.SpdxPackageVerificationCode;
import zz.org.spdx.library.model.SpdxSnippet;
import zz.org.spdx.library.model.TypedValue;
import zz.org.spdx.library.model.enumerations.AnnotationType;
import zz.org.spdx.library.model.enumerations.ChecksumAlgorithm;
import zz.org.spdx.library.model.enumerations.FileType;
import zz.org.spdx.library.model.enumerations.Purpose;
import zz.org.spdx.library.model.enumerations.ReferenceCategory;
import zz.org.spdx.library.model.enumerations.RelationshipType;
import zz.org.spdx.library.model.license.AnyLicenseInfo;
import zz.org.spdx.library.model.license.ConjunctiveLicenseSet;
import zz.org.spdx.library.model.license.CrossRef;
import zz.org.spdx.library.model.license.DisjunctiveLicenseSet;
import zz.org.spdx.library.model.license.ExternalExtractedLicenseInfo;
import zz.org.spdx.library.model.license.ExtractedLicenseInfo;
import zz.org.spdx.library.model.license.License;
import zz.org.spdx.library.model.license.LicenseException;
import zz.org.spdx.library.model.license.ListedLicenseException;
import zz.org.spdx.library.model.license.ListedLicenses;
import zz.org.spdx.library.model.license.OrLaterOperator;
import zz.org.spdx.library.model.license.SimpleLicensingInfo;
import zz.org.spdx.library.model.license.SpdxListedLicense;
import zz.org.spdx.library.model.license.SpdxNoAssertionLicense;
import zz.org.spdx.library.model.license.SpdxNoneLicense;
import zz.org.spdx.library.model.license.WithExceptionOperator;
import zz.org.spdx.library.model.pointer.ByteOffsetPointer;
import zz.org.spdx.library.model.pointer.CompoundPointer;
import zz.org.spdx.library.model.pointer.LineCharPointer;
import zz.org.spdx.library.model.pointer.SinglePointer;
import zz.org.spdx.library.model.pointer.StartEndPointer;
import zz.org.spdx.storage.IModelStore;

public class SpdxModelFactory {
    static final Logger logger = LoggerFactory.getLogger(SpdxModelFactory.class);
    public static Map<String, Class<?>> SPDX_TYPE_TO_CLASS;
    public static Map<Class<?>, String> SPDX_CLASS_TO_TYPE;

    public static SpdxDocument createSpdxDocument(IModelStore modelStore, String documentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        SpdxDocument retval = new SpdxDocument(modelStore, documentUri, copyManager, true);
        String date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date());
        SpdxCreatorInformation creationInfo = new SpdxCreatorInformation(modelStore, documentUri, modelStore.getNextId(IModelStore.IdType.Anonymous, documentUri), copyManager, true);
        creationInfo.getCreators().add("Tool: SPDX Tools");
        creationInfo.setCreated(date);
        creationInfo.setLicenseListVersion(ListedLicenses.getListedLicenses().getLicenseListVersion());
        retval.setCreationInfo(creationInfo);
        retval.setDataLicense(ListedLicenses.getListedLicenses().getListedLicenseById("CC0-1.0"));
        retval.setSpecVersion("SPDX-2.3");
        return retval;
    }

    public static ModelObject createModelObject(IModelStore modelStore, String documentUri, String id, String type, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        return SpdxModelFactory.getModelObject(modelStore, documentUri, id, type, copyManager, true);
    }

    public static ModelObject getModelObject(IModelStore modelStore, String documentUri, String id, String type, ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        switch (type) {
            case "SpdxDocument": {
                return new SpdxDocument(modelStore, documentUri, copyManager, create);
            }
            case "Package": {
                return new SpdxPackage(modelStore, documentUri, id, copyManager, create);
            }
            case "CreationInfo": {
                return new SpdxCreatorInformation(modelStore, documentUri, id, copyManager, create);
            }
            case "Checksum": {
                return new Checksum(modelStore, documentUri, id, copyManager, create);
            }
            case "AnyLicenseInfo": {
                throw new InvalidSPDXAnalysisException("Can not create abstract AnyLicensing Info.  Must specify one of the concrete classes");
            }
            case "SimpleLicensingInfo": {
                throw new InvalidSPDXAnalysisException("Can not create abstract SimpleLicensingInfo.  Must specify one of the concrete classes");
            }
            case "ConjunctiveLicenseSet": {
                return new ConjunctiveLicenseSet(modelStore, documentUri, id, copyManager, create);
            }
            case "DisjunctiveLicenseSet": {
                return new DisjunctiveLicenseSet(modelStore, documentUri, id, copyManager, create);
            }
            case "ExtractedLicensingInfo": {
                return new ExtractedLicenseInfo(modelStore, documentUri, id, copyManager, create);
            }
            case "License": {
                throw new InvalidSPDXAnalysisException("Can not create abstract License.  Must specify one of the concrete classes");
            }
            case "ListedLicense": {
                return new SpdxListedLicense(modelStore, documentUri, id, copyManager, create);
            }
            case "LicenseException": {
                return new LicenseException(modelStore, documentUri, id, copyManager, create);
            }
            case "ListedLicenseException": {
                return new ListedLicenseException(modelStore, documentUri, id, copyManager, create);
            }
            case "OrLaterOperator": {
                return new OrLaterOperator(modelStore, documentUri, id, copyManager, create);
            }
            case "WithExceptionOperator": {
                return new WithExceptionOperator(modelStore, documentUri, id, copyManager, create);
            }
            case "File": {
                return new SpdxFile(modelStore, documentUri, id, copyManager, create);
            }
            case "Review": {
                throw new RuntimeException("SPDX Review class is no longer supported");
            }
            case "PackageVerificationCode": {
                return new SpdxPackageVerificationCode(modelStore, documentUri, id, copyManager, create);
            }
            case "Annotation": {
                return new Annotation(modelStore, documentUri, id, copyManager, create);
            }
            case "Relationship": {
                return new Relationship(modelStore, documentUri, id, copyManager, create);
            }
            case "SpdxItem": {
                throw new RuntimeException("SPDX item is an abstract item and can not be created.");
            }
            case "SpdxElement": {
                throw new RuntimeException("SPDX element is an abstract item and can not be created.");
            }
            case "SpdxNoneElement": {
                return new SpdxNoneElement(modelStore, documentUri);
            }
            case "SpdxNoAssertionElement": {
                return new SpdxNoAssertionElement(modelStore, documentUri);
            }
            case "ExternalDocumentRef": {
                return new ExternalDocumentRef(modelStore, documentUri, id, copyManager, create);
            }
            case "ExternalRef": {
                return new ExternalRef(modelStore, documentUri, id, copyManager, create);
            }
            case "ExternalExtractedLicenseInfo": {
                return new ExternalExtractedLicenseInfo(modelStore, documentUri, id, copyManager, create);
            }
            case "ReferenceType": {
                throw new RuntimeException("Reference type can only be created with a type supplied.");
            }
            case "Snippet": {
                return new SpdxSnippet(modelStore, documentUri, id, copyManager, create);
            }
            case "SpdxNoAssertionLicense": {
                return new SpdxNoAssertionLicense(modelStore, documentUri);
            }
            case "SpdxNoneLicense": {
                return new SpdxNoneLicense(modelStore, documentUri);
            }
            case "GenericModelObject": {
                return new GenericModelObject(modelStore, documentUri, id, copyManager, create);
            }
            case "GenericSpdxElement": {
                return new GenericSpdxElement(modelStore, documentUri, id, copyManager, create);
            }
            case "GenericSpdxItem": {
                return new GenericSpdxItem(modelStore, documentUri, id, copyManager, create);
            }
            case "ExternalSpdxElement": {
                return new ExternalSpdxElement(modelStore, documentUri, id, copyManager, create);
            }
            case "StartEndPointer": {
                return new StartEndPointer(modelStore, documentUri, id, copyManager, create);
            }
            case "ByteOffsetPointer": {
                return new ByteOffsetPointer(modelStore, documentUri, id, copyManager, create);
            }
            case "LineCharPointer": {
                return new LineCharPointer(modelStore, documentUri, id, copyManager, create);
            }
            case "CrossRef": {
                return new CrossRef(modelStore, documentUri, id, copyManager, create);
            }
        }
        throw new InvalidSPDXAnalysisException("Unknown SPDX type: " + type);
    }

    public static Class<? extends Object> typeToClass(String type) throws InvalidSPDXAnalysisException {
        Class<?> retval = SPDX_TYPE_TO_CLASS.get(type);
        if (Objects.isNull(retval)) {
            throw new InvalidSPDXAnalysisException("Unknown SPDX type: " + type);
        }
        return retval;
    }

    public static Stream<?> getElements(IModelStore store, String documentUri, ModelCopyManager copyManager, Class<?> spdxClass) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(store, "Store must not be null");
        Objects.requireNonNull(documentUri, "documentUri must not be null");
        Objects.requireNonNull(spdxClass, "spdxClass must not be null");
        String type = SPDX_CLASS_TO_TYPE.get(spdxClass);
        if (Objects.isNull(type)) {
            throw new InvalidSPDXAnalysisException("Unknow SPDX class: " + spdxClass.toString());
        }
        return store.getAllItems(documentUri, type).map(tv -> {
            try {
                return SpdxModelFactory.createModelObject(store, documentUri, tv.getId(), tv.getType(), copyManager);
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Error creating model object", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    public static Class<?> classUriToClass(String classUri) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(classUri, "Missing required class URI");
        int indexOfPound = classUri.lastIndexOf(35);
        if (indexOfPound < 1) {
            throw new InvalidSPDXAnalysisException("Invalid class URI: " + classUri);
        }
        String type = classUri.substring(indexOfPound + 1);
        return SpdxModelFactory.typeToClass(type);
    }

    public static Optional<ModelObject> getModelObject(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (id.contains(":")) {
            try {
                return Optional.of(new ExternalSpdxElement(modelStore, documentUri, id, copyManager, true));
            }
            catch (InvalidSPDXAnalysisException ex) {
                logger.warn("Attempting to get a model object for an invalid SPDX ID.  Returning empty");
                return Optional.empty();
            }
        }
        Optional<TypedValue> tv = modelStore.getTypedValue(documentUri, id);
        if (tv.isPresent()) {
            String type = tv.get().getType();
            try {
                return Optional.of(SpdxModelFactory.getModelObject(modelStore, documentUri, id, type, copyManager, false));
            }
            catch (SpdxIdNotFoundException ex) {
                return Optional.empty();
            }
        }
        if (SpdxConstants.NOASSERTION_VALUE.equals(id)) {
            return Optional.of(new SpdxNoAssertionElement());
        }
        if (SpdxConstants.NONE_VALUE.equals(id)) {
            return Optional.of(new SpdxNoneElement());
        }
        return Optional.empty();
    }

    static {
        HashMap<String, Class> typeToClass = new HashMap<String, Class>();
        typeToClass.put("SpdxDocument", SpdxDocument.class);
        typeToClass.put("Package", SpdxPackage.class);
        typeToClass.put("CreationInfo", SpdxCreatorInformation.class);
        typeToClass.put("Checksum", Checksum.class);
        typeToClass.put("AnyLicenseInfo", AnyLicenseInfo.class);
        typeToClass.put("SimpleLicensingInfo", SimpleLicensingInfo.class);
        typeToClass.put("ConjunctiveLicenseSet", ConjunctiveLicenseSet.class);
        typeToClass.put("DisjunctiveLicenseSet", DisjunctiveLicenseSet.class);
        typeToClass.put("ExtractedLicensingInfo", ExtractedLicenseInfo.class);
        typeToClass.put("License", License.class);
        typeToClass.put("ListedLicense", SpdxListedLicense.class);
        typeToClass.put("LicenseException", LicenseException.class);
        typeToClass.put("ListedLicenseException", ListedLicenseException.class);
        typeToClass.put("OrLaterOperator", OrLaterOperator.class);
        typeToClass.put("WithExceptionOperator", WithExceptionOperator.class);
        typeToClass.put("File", SpdxFile.class);
        typeToClass.put("PackageVerificationCode", SpdxPackageVerificationCode.class);
        typeToClass.put("Annotation", Annotation.class);
        typeToClass.put("Relationship", Relationship.class);
        typeToClass.put("SpdxItem", SpdxItem.class);
        typeToClass.put("SpdxElement", SpdxElement.class);
        typeToClass.put("SpdxNoneElement", SpdxNoneElement.class);
        typeToClass.put("SpdxNoAssertionElement", SpdxNoAssertionElement.class);
        typeToClass.put("ExternalDocumentRef", ExternalDocumentRef.class);
        typeToClass.put("ExternalRef", ExternalRef.class);
        typeToClass.put("ReferenceType", ReferenceType.class);
        typeToClass.put("Snippet", SpdxSnippet.class);
        typeToClass.put("SpdxNoAssertionLicense", SpdxNoAssertionLicense.class);
        typeToClass.put("SpdxNoneLicense", SpdxNoneLicense.class);
        typeToClass.put("GenericModelObject", GenericModelObject.class);
        typeToClass.put("GenericSpdxElement", GenericSpdxElement.class);
        typeToClass.put("GenericSpdxItem", GenericSpdxItem.class);
        typeToClass.put("ExternalSpdxElement", ExternalSpdxElement.class);
        typeToClass.put("StartEndPointer", StartEndPointer.class);
        typeToClass.put("ByteOffsetPointer", ByteOffsetPointer.class);
        typeToClass.put("LineCharPointer", LineCharPointer.class);
        typeToClass.put("CompoundPointer", CompoundPointer.class);
        typeToClass.put("SinglePointer", SinglePointer.class);
        typeToClass.put("CrossRef", CrossRef.class);
        typeToClass.put("FileType", FileType.class);
        typeToClass.put("AnnotationType", AnnotationType.class);
        typeToClass.put("ChecksumAlgorithm", ChecksumAlgorithm.class);
        typeToClass.put("ReferenceCategory", ReferenceCategory.class);
        typeToClass.put("RelationshipType", RelationshipType.class);
        typeToClass.put("ExternalExtractedLicenseInfo", ExternalExtractedLicenseInfo.class);
        typeToClass.put("Purpose", Purpose.class);
        SPDX_TYPE_TO_CLASS = Collections.unmodifiableMap(typeToClass);
        HashMap<Class, String> classToType = new HashMap<Class, String>();
        for (Map.Entry entry : typeToClass.entrySet()) {
            classToType.put((Class)entry.getValue(), (String)entry.getKey());
        }
        SPDX_CLASS_TO_TYPE = Collections.unmodifiableMap(classToType);
    }
}

