/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.library.model.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.ModelCopyManager;
import zz.org.spdx.library.model.ModelObject;
import zz.org.spdx.library.model.license.CrossRef;
import zz.org.spdx.library.model.license.License;
import zz.org.spdx.licenseTemplate.InvalidLicenseTemplateException;
import zz.org.spdx.licenseTemplate.LicenseTemplateRuleException;
import zz.org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import zz.org.spdx.storage.IModelStore;

public class SpdxListedLicense
extends License {
    Collection<CrossRef> crossRef = this.getObjectPropertyValueSet("crossRef", CrossRef.class);

    public SpdxListedLicense(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public SpdxListedLicense(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public SpdxListedLicense(String name, String id, String text, Collection<String> sourceUrl, String comments, String standardLicenseHeader, String template, boolean osiApproved, Boolean fsfLibre, String licenseTextHtml, boolean isDeprecated, String deprecatedVersion) throws InvalidSPDXAnalysisException {
        this(id);
        this.setName(name);
        this.setLicenseText(text);
        this.setSeeAlso(sourceUrl);
        this.setComment(comments);
        this.setStandardLicenseHeader(standardLicenseHeader);
        this.setStandardLicenseTemplate(template);
        this.setOsiApproved(osiApproved);
        this.setFsfLibre(fsfLibre);
        this.setLicenseTextHtml(licenseTextHtml);
        this.setDeprecated(isDeprecated);
        this.setDeprecatedVersion(deprecatedVersion);
        this.crossRef = this.getObjectPropertyValueSet("crossRef", CrossRef.class);
    }

    public SpdxListedLicense(Builder builder) throws InvalidSPDXAnalysisException {
        this(builder.name, builder.id, builder.text, builder.sourceUrl, builder.comments, builder.standardLicenseHeader, builder.template, builder.osiApproved, builder.fsfLibre, builder.licenseTextHtml, builder.isDeprecated, builder.deprecatedVersion);
        this.crossRef.addAll(builder.crossRefs);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        List<String> retval = super._verify(verifiedIds, specVersion);
        try {
            if (this.isDeprecated()) {
                retval.add(this.getLicenseId() + " is deprecated.");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for SPDX license isDeprecated");
        }
        return retval;
    }

    public String getLicenseTextHtml() throws InvalidLicenseTemplateException, InvalidSPDXAnalysisException {
        Optional<String> licenseTextHtml = this.getStringPropertyValue("licenseTextHtml");
        if (licenseTextHtml.isPresent()) {
            return licenseTextHtml.get();
        }
        String templateText = this.getStandardLicenseTemplate();
        if (templateText != null && !templateText.trim().isEmpty()) {
            try {
                return SpdxLicenseTemplateHelper.templateTextToHtml(templateText);
            }
            catch (LicenseTemplateRuleException ex) {
                throw new InvalidLicenseTemplateException("Invalid license expression found in license text for license " + this.getName() + ":" + ex.getMessage());
            }
        }
        return SpdxLicenseTemplateHelper.formatEscapeHTML(this.getLicenseText());
    }

    public void setLicenseTextHtml(String licenseTextHtml) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("licenseTextHtml", licenseTextHtml);
    }

    public String getLicenseHeaderHtml() throws InvalidLicenseTemplateException, InvalidSPDXAnalysisException {
        Optional<String> licenseHeaderHtml = this.getStringPropertyValue("standardLicenseHeaderHtml");
        if (licenseHeaderHtml.isPresent()) {
            return licenseHeaderHtml.get();
        }
        String templateText = this.getStandardLicenseHeaderTemplate();
        if (templateText != null && !templateText.trim().isEmpty()) {
            try {
                return SpdxLicenseTemplateHelper.templateTextToHtml(templateText);
            }
            catch (LicenseTemplateRuleException ex) {
                throw new InvalidLicenseTemplateException("Invalid license expression found in standard license header for license " + this.getName() + ":" + ex.getMessage());
            }
        }
        return SpdxLicenseTemplateHelper.formatEscapeHTML(this.getStandardLicenseHeader());
    }

    public void setLicenseHeaderHtml(String licenseHeaderHtml) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("standardLicenseHeaderHtml", licenseHeaderHtml);
    }

    public String getDeprecatedVersion() throws InvalidSPDXAnalysisException {
        Optional<String> depVersion = this.getStringPropertyValue("deprecatedVersion");
        if (depVersion.isPresent()) {
            return depVersion.get();
        }
        return "";
    }

    public void setDeprecatedVersion(String deprecatedVersion) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("deprecatedVersion", deprecatedVersion);
    }

    public Collection<CrossRef> getCrossRef() throws InvalidSPDXAnalysisException {
        return this.crossRef;
    }

    @Override
    public String getType() {
        return "ListedLicense";
    }

    @Override
    public boolean equivalent(ModelObject compare, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        if (compare instanceof SpdxListedLicense) {
            return this.getLicenseId().equals(((SpdxListedLicense)compare).getLicenseId());
        }
        return super.equivalent(compare, ignoreRelatedElements);
    }

    @Override
    public boolean equals(Object compare) {
        if (!(compare instanceof SpdxListedLicense)) {
            return false;
        }
        return Objects.equals(this.getLicenseId(), ((SpdxListedLicense)compare).getLicenseId());
    }

    @Override
    public int hashCode() {
        String licId = this.getLicenseId();
        if (Objects.isNull(licId)) {
            return 91;
        }
        return 0x5B ^ licId.hashCode();
    }

    public static class Builder {
        private String id;
        private String name;
        private String text;
        private Collection<String> sourceUrl;
        private String comments;
        private String standardLicenseHeader;
        private String template;
        private boolean osiApproved;
        private Boolean fsfLibre;
        private String licenseTextHtml;
        private boolean isDeprecated;
        private String deprecatedVersion;
        private List<CrossRef> crossRefs = new ArrayList<CrossRef>();

        public Builder(String id, String name, String text) {
            this.id = id;
            this.name = name;
            this.text = text;
        }

        public Builder setSourceUrl(Collection<String> sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public Builder setComments(String comments) {
            this.comments = comments;
            return this;
        }

        public Builder setStandardLicenseHeader(String standardLicenseHeader) {
            this.standardLicenseHeader = standardLicenseHeader;
            return this;
        }

        public Builder setTemplate(String template) {
            this.template = template;
            return this;
        }

        public Builder setOsiApproved(boolean osiApproved) {
            this.osiApproved = osiApproved;
            return this;
        }

        public Builder setFsfLibre(Boolean fsfLibre) {
            this.fsfLibre = fsfLibre;
            return this;
        }

        public Builder setLicenseTextHtml(String licenseTextHtml) {
            this.licenseTextHtml = licenseTextHtml;
            return this;
        }

        public Builder setIsDeprecated(boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            return this;
        }

        public Builder setDeprecatedVersion(String deprecatedVersion) {
            this.deprecatedVersion = deprecatedVersion;
            return this;
        }

        public Builder addCrossRefs(CrossRef crossRef) {
            this.crossRefs.add(crossRef);
            return this;
        }
    }
}

