/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.library.model.pointer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.ModelCopyManager;
import zz.org.spdx.library.model.ModelObject;
import zz.org.spdx.library.model.SpdxInvalidTypeException;
import zz.org.spdx.library.model.pointer.SinglePointer;
import zz.org.spdx.storage.IModelStore;

public abstract class CompoundPointer
extends ModelObject {
    public CompoundPointer() throws InvalidSPDXAnalysisException {
    }

    public CompoundPointer(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public CompoundPointer(IModelStore modelStore, String documentUri, String id, ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    @Nullable
    public SinglePointer getStartPointer() throws InvalidSPDXAnalysisException {
        Optional<Object> retval = this.getObjectPropertyValue("startPointer");
        if (!retval.isPresent()) {
            return null;
        }
        if (!(retval.get() instanceof SinglePointer)) {
            throw new SpdxInvalidTypeException("Incorrect type for getEndPointer - expected SinglePointer, found " + retval.get().getClass().toString());
        }
        return (SinglePointer)retval.get();
    }

    public CompoundPointer setStartPointer(SinglePointer startPointer) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.isNull(startPointer)) {
            throw new InvalidSPDXAnalysisException("Can not set required startPointer to null");
        }
        this.setPropertyValue("startPointer", startPointer);
        return this;
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            SinglePointer startPointer = this.getStartPointer();
            if (startPointer == null) {
                retval.add("Missing required start pointer");
            } else {
                retval.addAll(startPointer.verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            retval.add("Error getting start pointer: " + ex.getMessage());
        }
        return retval;
    }

    @Override
    public String getType() {
        return "CompoundPointer";
    }
}

