/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.storage.listedlicense;

import java.io.IOException;
import java.io.InputStream;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.storage.listedlicense.SpdxListedLicenseModelStore;

public class SpdxListedLicenseLocalStore
extends SpdxListedLicenseModelStore {
    static final String LISTED_LICENSE_JSON_LOCAL_DIR = "resources/stdlicenses";

    @Override
    InputStream getTocInputStream() throws IOException {
        String fileName = "resources/stdlicenses/licenses.json";
        InputStream retval = SpdxListedLicenseLocalStore.class.getResourceAsStream("/" + fileName);
        if (retval == null) {
            throw new IOException("Unable to open local local license table of contents file");
        }
        return retval;
    }

    @Override
    InputStream getLicenseInputStream(String licenseId) throws IOException {
        String fileName = "resources/stdlicenses/" + licenseId + ".json";
        InputStream retval = SpdxListedLicenseLocalStore.class.getResourceAsStream("/" + fileName);
        if (retval == null) {
            throw new IOException("Unable to open local local license JSON file for license ID " + licenseId);
        }
        return retval;
    }

    @Override
    InputStream getExceptionTocInputStream() throws IOException {
        String fileName = "resources/stdlicenses/exceptions.json";
        InputStream retval = SpdxListedLicenseLocalStore.class.getResourceAsStream("/" + fileName);
        if (retval == null) {
            throw new IOException("Unable to open local local license table of contents file");
        }
        return retval;
    }

    @Override
    InputStream getExceptionInputStream(String exceptionId) throws IOException {
        return this.getLicenseInputStream(exceptionId);
    }

    @Override
    public void close() throws Exception {
    }
}

