/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.storage.listedlicense;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.storage.listedlicense.SpdxListedLicenseModelStore;

public class SpdxListedLicenseWebStore
extends SpdxListedLicenseModelStore {
    private static final int READ_TIMEOUT = 5000;
    static final List<String> WHITE_LIST = Collections.unmodifiableList(Arrays.asList("spdx.org", "spdx.dev", "spdx.com", "spdx.info"));

    private InputStream getUrlInputStream(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setReadTimeout(5000);
        int status = connection.getResponseCode();
        if (status != 200 && (status == 302 || status == 301 || status == 303)) {
            URL redirectUrl;
            String redirectUrlStr = connection.getHeaderField("Location");
            if (Objects.isNull(redirectUrlStr) || redirectUrlStr.isEmpty()) {
                throw new IOException("Empty redirect URL response");
            }
            try {
                redirectUrl = new URL(redirectUrlStr);
            }
            catch (Exception ex) {
                throw new IOException("Invalid redirect URL");
            }
            if (!redirectUrl.getProtocol().toLowerCase().startsWith("http")) {
                throw new IOException("Invalid redirect protocol");
            }
            if (!WHITE_LIST.contains(redirectUrl.getHost())) {
                throw new IOException("Invalid redirect host - not on the allowed 'white list'");
            }
            connection = (HttpURLConnection)redirectUrl.openConnection();
        }
        return connection.getInputStream();
    }

    @Override
    InputStream getTocInputStream() throws IOException {
        return this.getUrlInputStream(new URL("https://spdx.org/licenses/licenses.json"));
    }

    @Override
    InputStream getLicenseInputStream(String licenseId) throws IOException {
        return this.getUrlInputStream(new URL("https://spdx.org/licenses/" + licenseId + ".json"));
    }

    @Override
    InputStream getExceptionTocInputStream() throws IOException {
        return this.getUrlInputStream(new URL("https://spdx.org/licenses/exceptions.json"));
    }

    @Override
    InputStream getExceptionInputStream(String exceptionId) throws IOException {
        return this.getLicenseInputStream(exceptionId);
    }

    @Override
    public void close() throws Exception {
    }
}

