/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.storage.simple;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.model.TypedValue;
import zz.org.spdx.storage.IModelStore;

public abstract class ExtendedSpdxStore
implements IModelStore {
    private IModelStore baseStore;

    public ExtendedSpdxStore(IModelStore baseStore) {
        this.baseStore = baseStore;
    }

    @Override
    public boolean exists(String documentUri, String id) {
        return this.baseStore.exists(documentUri, id);
    }

    @Override
    public void create(String documentUri, String id, String type) throws InvalidSPDXAnalysisException {
        this.baseStore.create(documentUri, id, type);
    }

    @Override
    public List<String> getPropertyValueNames(String documentUri, String id) throws InvalidSPDXAnalysisException {
        return this.baseStore.getPropertyValueNames(documentUri, id);
    }

    @Override
    public void setValue(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        this.baseStore.setValue(documentUri, id, propertyName, value);
    }

    @Override
    public Optional<Object> getValue(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        return this.baseStore.getValue(documentUri, id, propertyName);
    }

    @Override
    public String getNextId(IModelStore.IdType idType, String documentUri) throws InvalidSPDXAnalysisException {
        return this.baseStore.getNextId(idType, documentUri);
    }

    @Override
    public void removeProperty(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        this.baseStore.removeProperty(documentUri, id, propertyName);
    }

    @Override
    public List<String> getDocumentUris() {
        return this.baseStore.getDocumentUris();
    }

    @Override
    public Stream<TypedValue> getAllItems(String documentUri, String typeFilter) throws InvalidSPDXAnalysisException {
        return this.baseStore.getAllItems(documentUri, typeFilter);
    }

    @Override
    public IModelStore.IModelStoreLock enterCriticalSection(String documentUri, boolean readLockRequested) throws InvalidSPDXAnalysisException {
        return this.baseStore.enterCriticalSection(documentUri, readLockRequested);
    }

    @Override
    public void leaveCriticalSection(IModelStore.IModelStoreLock lock) {
        this.baseStore.leaveCriticalSection(lock);
    }

    @Override
    public boolean removeValueFromCollection(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        return this.baseStore.removeValueFromCollection(documentUri, id, propertyName, value);
    }

    @Override
    public int collectionSize(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        return this.baseStore.collectionSize(documentUri, id, propertyName);
    }

    @Override
    public boolean collectionContains(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        return this.baseStore.collectionContains(documentUri, id, propertyName, value);
    }

    @Override
    public void clearValueCollection(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        this.baseStore.clearValueCollection(documentUri, id, propertyName);
    }

    @Override
    public boolean addValueToCollection(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        return this.baseStore.addValueToCollection(documentUri, id, propertyName, value);
    }

    @Override
    public Iterator<Object> listValues(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        return this.baseStore.listValues(documentUri, id, propertyName);
    }

    @Override
    public boolean isCollectionMembersAssignableTo(String documentUri, String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        return this.baseStore.isCollectionMembersAssignableTo(documentUri, id, propertyName, clazz);
    }

    @Override
    public boolean isPropertyValueAssignableTo(String documentUri, String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        return this.baseStore.isPropertyValueAssignableTo(documentUri, id, propertyName, clazz);
    }

    @Override
    public boolean isCollectionProperty(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        return this.baseStore.isCollectionProperty(documentUri, id, propertyName);
    }

    @Override
    public IModelStore.IdType getIdType(String id) {
        return this.baseStore.getIdType(id);
    }

    @Override
    public Optional<String> getCaseSensisitiveId(String documentUri, String caseInsensisitiveId) {
        return this.baseStore.getCaseSensisitiveId(documentUri, caseInsensisitiveId);
    }

    @Override
    public Optional<TypedValue> getTypedValue(String documentUri, String id) throws InvalidSPDXAnalysisException {
        return this.baseStore.getTypedValue(documentUri, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear(String documentUri) throws InvalidSPDXAnalysisException {
        IModelStore.IModelStoreLock lock = this.enterCriticalSection(documentUri, false);
        try {
            for (TypedValue item : this.getAllItems(documentUri, null).collect(Collectors.toList())) {
                for (String propertyName : this.getPropertyValueNames(documentUri, item.getId())) {
                    this.removeProperty(documentUri, item.getId(), propertyName);
                }
            }
        }
        finally {
            this.leaveCriticalSection(lock);
        }
    }

    @Override
    public void delete(String documentUri, String elementId) throws InvalidSPDXAnalysisException {
        this.baseStore.delete(documentUri, elementId);
    }

    @Override
    public void close() throws Exception {
        this.baseStore.close();
    }
}

